/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.actionscript.debug;

import flash.tools.debugger.PlayerDebugException;
import flash.tools.debugger.Value;
import flash.tools.debugger.Variable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.swt.tools.actionscript.debug.ActionScriptVariable;

public class ActionScriptVariableValue
implements IValue {
    Value value;
    ActionScriptVariable variable;

    ActionScriptVariableValue(ActionScriptVariable variable, Value value) {
        this.variable = variable;
        this.value = value;
    }

    public String getReferenceTypeName() throws DebugException {
        return this.value.getClassName();
    }

    public String getValueString() throws DebugException {
        switch (this.value.getType()) {
            case 2: {
                Object obj = this.value.getValueAsObject();
                return "\"" + obj + "\"";
            }
            case 0: {
                return this.value.getValueAsString();
            }
            case 6: {
                return "null";
            }
            case 7: {
                return this.value.getValueAsString();
            }
            case 3: {
                String name = this.value.getTypeName();
                name = ActionScriptVariableValue.replace(name, "::", ".");
                name = name.substring(0, name.lastIndexOf(64));
                return String.valueOf(name) + " (id=" + this.value.getId() + ")";
            }
        }
        return this.value.getValueAsString();
    }

    static String replace(String str, String match, String replacement) {
        int index;
        StringBuffer buffer = new StringBuffer();
        int start = 0;
        while ((index = str.indexOf(match, start)) != -1) {
            buffer.append(str.substring(start, index));
            buffer.append(replacement);
            start = index + match.length();
        }
        buffer.append(str.substring(start));
        return buffer.toString();
    }

    public IVariable[] getVariables() throws DebugException {
        try {
            Variable[] members = this.value.getMembers(this.variable.target.session);
            IVariable[] result = new ActionScriptVariable[members.length];
            int i = 0;
            while (i < members.length) {
                result[i] = new ActionScriptVariable(this.variable.target, members[i]);
                ++i;
            }
            return result;
        }
        catch (PlayerDebugException e) {
            Status status = new Status(4, "org.eclipse.swt.tools.actionscript.core", "Error getting variables", (Throwable)e);
            throw new DebugException((IStatus)status);
        }
    }

    public boolean hasVariables() throws DebugException {
        try {
            return this.value.getMemberCount(this.variable.target.session) != 0;
        }
        catch (PlayerDebugException e) {
            Status status = new Status(4, "org.eclipse.swt.tools.actionscript.core", "Error getting variables", (Throwable)e);
            throw new DebugException((IStatus)status);
        }
    }

    public boolean isAllocated() throws DebugException {
        return true;
    }

    public IDebugTarget getDebugTarget() {
        return this.variable.getDebugTarget();
    }

    public ILaunch getLaunch() {
        return this.variable.getLaunch();
    }

    public String getModelIdentifier() {
        return this.variable.getModelIdentifier();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IValue.class) {
            return this;
        }
        return super.getClass();
    }
}

