/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.actionscript.debug;

import flash.tools.debugger.Frame;
import flash.tools.debugger.NotConnectedException;
import flash.tools.debugger.Session;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.DebugElement;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.swt.tools.actionscript.debug.ActionScriptDebugTarget;
import org.eclipse.swt.tools.actionscript.debug.ActionScriptFrame;

public class ActionScriptThread
extends DebugElement
implements IThread {
    private ActionScriptDebugTarget target;

    public ActionScriptThread(ActionScriptDebugTarget target) {
        super((IDebugTarget)target);
        this.target = target;
        this.fireCreationEvent();
    }

    public IBreakpoint[] getBreakpoints() {
        return new IBreakpoint[0];
    }

    public String getName() throws DebugException {
        return "Thread [main]";
    }

    public int getPriority() throws DebugException {
        return 5;
    }

    public IStackFrame[] getStackFrames() throws DebugException {
        try {
            Session session = this.target.session;
            Frame[] frames = session.getFrames();
            int len = frames.length;
            IStackFrame[] result = new IStackFrame[len];
            int i = 0;
            while (i < len) {
                result[i] = new ActionScriptFrame(this.target, frames[i]);
                ++i;
            }
            return result;
        }
        catch (NotConnectedException e) {
            Status status = new Status(4, "org.eclipse.swt.tools.actionscript.core", "Error getting stack frames", (Throwable)e);
            throw new DebugException((IStatus)status);
        }
    }

    public IStackFrame getTopStackFrame() throws DebugException {
        Frame[] frames;
        block4: {
            if (!this.target.isSuspended()) {
                return null;
            }
            try {
                Session session = this.target.session;
                frames = session.getFrames();
                if (frames.length != 0) break block4;
                return null;
            }
            catch (NotConnectedException e) {
                Status status = new Status(4, "org.eclipse.swt.tools.actionscript.core", "Error getting stack frames", (Throwable)e);
                throw new DebugException((IStatus)status);
            }
        }
        return new ActionScriptFrame(this.target, frames[0]);
    }

    public boolean hasStackFrames() throws DebugException {
        return this.target.isSuspended();
    }

    public IDebugTarget getDebugTarget() {
        return this.target;
    }

    public ILaunch getLaunch() {
        return this.target.getLaunch();
    }

    public String getModelIdentifier() {
        return this.target.getModelIdentifier();
    }

    public boolean canResume() {
        return this.target.canResume();
    }

    public boolean canSuspend() {
        return this.target.canSuspend();
    }

    public boolean isSuspended() {
        return this.target.isSuspended();
    }

    public void resume() throws DebugException {
        this.target.resume();
    }

    public void suspend() throws DebugException {
        this.target.suspend();
    }

    public boolean canStepInto() {
        return this.target.canStepInto();
    }

    public boolean canStepOver() {
        return this.target.canStepOver();
    }

    public boolean canStepReturn() {
        return this.target.canStepReturn();
    }

    public boolean isStepping() {
        return this.target.isStepping();
    }

    public void stepInto() throws DebugException {
        this.target.stepInto();
    }

    public void stepOver() throws DebugException {
        this.target.stepOver();
    }

    public void stepReturn() throws DebugException {
        this.target.stepReturn();
    }

    public boolean canTerminate() {
        return this.target.canTerminate();
    }

    public boolean isTerminated() {
        return this.target.isTerminated();
    }

    public void terminate() throws DebugException {
        this.fireTerminateEvent();
        this.target.terminate();
    }
}

