/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.actionscript.debug;

import flash.tools.debugger.Location;
import flash.tools.debugger.NoResponseException;
import flash.tools.debugger.NotConnectedException;
import flash.tools.debugger.PlayerDebugException;
import flash.tools.debugger.Session;
import flash.tools.debugger.SourceFile;
import flash.tools.debugger.SwfInfo;
import java.util.HashMap;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.DebugElement;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStep;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.swt.tools.actionscript.debug.ActionScriptLineMapper;
import org.eclipse.swt.tools.actionscript.debug.ActionScriptProcess;
import org.eclipse.swt.tools.actionscript.debug.ActionScriptThread;

public class ActionScriptDebugTarget
extends DebugElement
implements IDebugTarget,
IStep {
    Session session;
    ActionScriptThread thread;
    public ActionScriptProcess process;
    ILaunch launch;
    IBreakpointManager breakpointManager;
    boolean isStepping;
    String mainClass;
    String processName;
    HashMap<Integer, Location> locations;

    public ActionScriptDebugTarget(Session session, ILaunch launch, String mainClass, String processName) {
        super(null);
        this.session = session;
        this.launch = launch;
        this.mainClass = mainClass;
        this.processName = processName;
        this.thread = new ActionScriptThread(this);
        this.process = new ActionScriptProcess(this, launch, processName);
        this.breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        this.breakpointManager.addBreakpointListener((IBreakpointListener)this);
        this.locations = new HashMap();
        this.fireCreationEvent();
    }

    public String getName() throws DebugException {
        if (this.process.isTerminated()) {
            return "<terminated>" + this.mainClass;
        }
        return this.mainClass;
    }

    public IProcess getProcess() {
        return this.process;
    }

    public IThread[] getThreads() throws DebugException {
        if (this.isTerminated()) {
            return new IThread[0];
        }
        return new IThread[]{this.thread};
    }

    public boolean hasThreads() throws DebugException {
        return !this.isTerminated();
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        return breakpoint instanceof IJavaLineBreakpoint;
    }

    public IDebugTarget getDebugTarget() {
        return this;
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public String getModelIdentifier() {
        return "org.eclipse.swt.tools.actionscript.core.debugModelPresentation";
    }

    public boolean canTerminate() {
        return !this.process.isTerminated();
    }

    public boolean isTerminated() {
        return this.process.isTerminated();
    }

    public void terminate() throws DebugException {
        this.fireTerminateEvent();
        this.process.terminate();
    }

    public boolean canResume() {
        if (!this.session.isConnected()) {
            return false;
        }
        try {
            return this.session.isSuspended();
        }
        catch (PlayerDebugException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean canSuspend() {
        if (!this.session.isConnected()) {
            return false;
        }
        try {
            return !this.session.isSuspended();
        }
        catch (NotConnectedException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isSuspended() {
        block3: {
            try {
                if (!this.isDisconnected()) break block3;
                return false;
            }
            catch (NotConnectedException e) {
                e.printStackTrace();
                return false;
            }
        }
        return this.session.isSuspended();
    }

    public void resume() throws DebugException {
        try {
            this.session.resume();
            this.thread.fireResumeEvent(32);
        }
        catch (PlayerDebugException e) {
            Status status = new Status(4, "org.eclipse.swt.tools.actionscript.core", "Error resuming target", (Throwable)e);
            throw new DebugException((IStatus)status);
        }
    }

    public void suspend() throws DebugException {
        try {
            this.session.suspend();
            this.thread.fireSuspendEvent(32);
        }
        catch (PlayerDebugException e) {
            Status status = new Status(4, "org.eclipse.swt.tools.actionscript.core", "Error suspending target", (Throwable)e);
            throw new DebugException((IStatus)status);
        }
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        if (!(breakpoint instanceof IJavaLineBreakpoint)) {
            return;
        }
        if (this.isTerminated()) {
            return;
        }
        try {
            this.installBreakpoint((IJavaLineBreakpoint)breakpoint);
        }
        catch (PlayerDebugException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    boolean installBreakpoint(IJavaLineBreakpoint breakpoint) throws PlayerDebugException, CoreException {
        ActionScriptLineMapper mapper = ActionScriptLineMapper.getInstance();
        ActionScriptLineMapper.FileLocation fileLocation = mapper.getActionScriptLocation(breakpoint);
        if (fileLocation == null) {
            return false;
        }
        SwfInfo[] swfs = this.session.getSwfs();
        int i = 0;
        while (i < swfs.length) {
            SwfInfo swfInfo = swfs[i];
            SourceFile[] sourceFiles = swfInfo.getSourceList(this.session);
            int j = 0;
            while (j < sourceFiles.length) {
                SourceFile sourceFile = sourceFiles[j];
                String fullPath = sourceFile.getFullPath();
                if (fullPath.equals(fileLocation.fileName)) {
                    int id = sourceFile.getId();
                    Location location = this.session.setBreakpoint(id, fileLocation.lineNumber);
                    breakpoint.getMarker().setAttribute("ASID", id);
                    this.locations.put(id, location);
                    return location != null;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        if (breakpoint instanceof IJavaLineBreakpoint) {
            try {
                Location location;
                int temp = breakpoint.getMarker().getAttribute("ASID", -1);
                if (temp != -1 && (location = this.locations.get(temp)) != null) {
                    this.session.clearBreakpoint(location);
                }
                breakpoint.getMarker().setAttribute("ASID", -1);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            catch (NoResponseException e) {
                e.printStackTrace();
            }
            catch (NotConnectedException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean canDisconnect() {
        return false;
    }

    public void disconnect() throws DebugException {
    }

    public boolean isDisconnected() {
        return !this.session.isConnected();
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        return null;
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public boolean canStepInto() {
        try {
            return this.session.isSuspended();
        }
        catch (NotConnectedException notConnectedException) {
            return false;
        }
    }

    public boolean canStepOver() {
        try {
            return this.session.isSuspended();
        }
        catch (NotConnectedException notConnectedException) {
            return false;
        }
    }

    public boolean canStepReturn() {
        try {
            return this.session.isSuspended();
        }
        catch (NotConnectedException notConnectedException) {
            return false;
        }
    }

    public boolean isStepping() {
        return this.isStepping;
    }

    public void stepInto() throws DebugException {
        this.isStepping = true;
        try {
            this.session.stepInto();
            this.thread.fireResumeEvent(1);
        }
        catch (PlayerDebugException e) {
            e.printStackTrace();
        }
    }

    public void stepOver() throws DebugException {
        this.isStepping = true;
        try {
            this.session.stepOver();
            this.thread.fireResumeEvent(2);
        }
        catch (PlayerDebugException e) {
            e.printStackTrace();
        }
    }

    public void stepReturn() throws DebugException {
        this.isStepping = true;
        try {
            this.session.stepOut();
            this.thread.fireResumeEvent(4);
        }
        catch (PlayerDebugException e) {
            e.printStackTrace();
        }
    }

    void stepEnd() {
        this.isStepping = false;
        this.thread.fireSuspendEvent(8);
    }

    public IBreakpointManager getBreakpointManager() {
        return this.breakpointManager;
    }
}

