/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.actionscript.debug;

import flash.tools.debugger.PlayerDebugException;
import flash.tools.debugger.Session;
import flash.tools.debugger.events.BreakEvent;
import flash.tools.debugger.events.DebugEvent;
import flash.tools.debugger.events.SwfLoadedEvent;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.swt.tools.actionscript.debug.ActionScriptDebugTarget;
import org.eclipse.swt.tools.actionscript.debug.ActionScriptLineMapper;

public class ActionScriptDebugEventDispatcher
extends Job {
    static final int CLIENT_REQUEST = 32;
    static final int BREAKPOINT = 16;
    ActionScriptDebugTarget target;

    public ActionScriptDebugEventDispatcher(ActionScriptDebugTarget target) {
        super("ActionScript Event Dispatcher");
        this.target = target;
    }

    protected IStatus run(IProgressMonitor monitor) {
        if (this.target.isTerminated()) {
            return Status.CANCEL_STATUS;
        }
        Session session = this.target.session;
        DebugEvent nextEvent = session.nextEvent();
        while (nextEvent != null && !this.target.isTerminated()) {
            this.handleEvent(nextEvent);
            nextEvent = session.nextEvent();
        }
        if (!this.target.isTerminated()) {
            this.schedule(500L);
        }
        return Status.OK_STATUS;
    }

    void handleEvent(DebugEvent nextEvent) {
        if (nextEvent instanceof BreakEvent) {
            this.handleBreak((BreakEvent)nextEvent);
        } else if (nextEvent instanceof SwfLoadedEvent) {
            this.handleSwfLoaded((SwfLoadedEvent)nextEvent);
        }
    }

    void handleSwfLoaded(SwfLoadedEvent nextEvent) {
        IBreakpointManager breakpointManager = this.target.getBreakpointManager();
        IBreakpoint[] breakpoints = breakpointManager.getBreakpoints();
        int i = 0;
        while (i < breakpoints.length) {
            if (breakpoints[i] instanceof IJavaBreakpoint) {
                try {
                    this.target.installBreakpoint((IJavaLineBreakpoint)breakpoints[i]);
                }
                catch (PlayerDebugException e) {
                    e.printStackTrace();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
    }

    void handleBreak(BreakEvent nextEvent) {
        try {
            Session session = this.target.session;
            switch (session.suspendReason()) {
                case 0: 
                case 7: {
                    if (session.isSuspended()) {
                        session.resume();
                    }
                    return;
                }
            }
        }
        catch (PlayerDebugException e1) {
            e1.printStackTrace();
        }
        IBreakpointManager breakpointManager = this.target.getBreakpointManager();
        IBreakpoint[] breakpoints = breakpointManager.getBreakpoints();
        int i = 0;
        while (i < breakpoints.length) {
            if (breakpoints[i] instanceof IJavaLineBreakpoint) {
                IJavaLineBreakpoint bp = (IJavaLineBreakpoint)breakpoints[i];
                try {
                    int id = bp.getMarker().getAttribute("ASID", -1);
                    ActionScriptLineMapper mapper = ActionScriptLineMapper.getInstance();
                    ActionScriptLineMapper.FileLocation fileLocation = mapper.getActionScriptLocation(bp);
                    if (fileLocation != null && fileLocation.lineNumber == nextEvent.line && id == nextEvent.fileId) {
                        if (this.target.isStepping) {
                            this.target.isStepping = false;
                        }
                        this.target.thread.fireSuspendEvent(16);
                        return;
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        if (this.target.isStepping()) {
            this.target.stepEnd();
        } else {
            this.target.thread.fireSuspendEvent(32);
        }
    }
}

