/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.actionscript.build;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.BuildContext;
import org.eclipse.jdt.core.compiler.CompilationParticipant;
import org.eclipse.jdt.internal.compiler.as.Main;
import org.eclipse.swt.tools.actionscript.ActionScriptCorePlugin;
import org.eclipse.swt.tools.actionscript.build.ActionScriptLaunchConfigurationDelegate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ActionScriptParticipant
extends CompilationParticipant {
    public static final String COMPILE_ID_KEY = "swc_compile_id";
    public static final String FLEX_SDK = "flex.sdk";
    final String SOURCE_ID = "java_as";
    ArrayList sources;

    public void buildFinished(IJavaProject project) {
        if (this.sources == null) {
            return;
        }
        try {
            this.buildActionScript(project);
            this.buildSWC(project);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void buildStarting(BuildContext[] files, boolean isBatch) {
        if (this.sources == null) {
            this.sources = new ArrayList();
        }
        int i = 0;
        while (i < files.length) {
            BuildContext context = files[i];
            IFile file = context.getFile();
            this.sources.add(file.getLocation().toPortableString());
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isActive(IJavaProject project) {
        try {
            IProject proj = project.getProject();
            if (proj.getNature("org.eclipse.swt.tools.actionscript.core.actionscriptnature") != null) {
                return true;
            }
            IProject[] projects = proj.getWorkspace().getRoot().getProjects();
            int i = 0;
            while (true) {
                IJavaProject javaProject;
                if (i >= projects.length) {
                    return false;
                }
                if (projects[i].isOpen() && projects[i].getNature("org.eclipse.swt.tools.actionscript.core.actionscriptnature") != null && (javaProject = JavaCore.create((IProject)projects[i])) != null && javaProject.isOnClasspath((IResource)proj)) {
                    return true;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    void buildActionScript(IJavaProject project) throws CoreException {
        String root = String.valueOf(project.getProject().getLocation().toPortableString()) + "/.buildas";
        PrintWriter writer = null;
        try {
            try {
                IClasspathEntry entry;
                StringBuffer sp = new StringBuffer();
                StringBuffer cp = new StringBuffer();
                StringBuffer bp = new StringBuffer();
                IClasspathEntry[] entries = project.getRawClasspath();
                int i = 0;
                while (i < entries.length) {
                    entry = entries[i];
                    if (entry.getEntryKind() == 5 && entry.getPath().toPortableString().startsWith("org.eclipse.jdt.launching.JRE_CONTAINER")) {
                        IWorkspaceRoot workspaceRoot = project.getProject().getWorkspace().getRoot();
                        IProject jcl = (IProject)workspaceRoot.findMember("org.eclipse.swt.e4.jcl");
                        if (jcl != null && jcl.isOpen()) {
                            IJavaProject javaProject = JavaCore.create((IProject)jcl.getProject());
                            bp.append(workspaceRoot.findMember(javaProject.getOutputLocation()).getLocation().toPortableString());
                        } else {
                            bp.append(ActionScriptCorePlugin.getDefault().getJCLLocation().toPortableString());
                        }
                    }
                    ++i;
                }
                i = 0;
                while (i < entries.length) {
                    entry = entries[i];
                    IPath path = entry.getPath();
                    int kind = entry.getEntryKind();
                    switch (kind) {
                        case 3: {
                            if (sp.length() > 0) {
                                sp.append(File.pathSeparatorChar);
                            }
                            IResource resource = project.getProject().getWorkspace().getRoot().findMember(entry.getPath());
                            sp.append(resource.getLocation().toPortableString());
                            break;
                        }
                        case 2: {
                            if (cp.length() > 0) {
                                cp.append(File.pathSeparator);
                            }
                            IWorkspaceRoot workspaceRoot = project.getProject().getWorkspace().getRoot();
                            IResource resource = workspaceRoot.findMember(entry.getPath());
                            IJavaProject javaProject = JavaCore.create((IProject)((IProject)resource));
                            cp.append(workspaceRoot.findMember(javaProject.getOutputLocation()).getLocation().toPortableString());
                            break;
                        }
                        case 4: {
                            if (cp.length() > 0) {
                                cp.append(File.pathSeparatorChar);
                            }
                            IClasspathEntry resolvedEntry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)entry);
                            cp.append(resolvedEntry.getPath().toPortableString());
                            break;
                        }
                        case 1: {
                            if (cp.length() > 0) {
                                cp.append(File.pathSeparatorChar);
                            }
                            cp.append(entry.getPath().toPortableString());
                            break;
                        }
                        case 5: {
                            if (path.toPortableString().startsWith("org.eclipse.jdt.launching.JRE_CONTAINER")) break;
                            IClasspathContainer container = JavaCore.getClasspathContainer((IPath)path, (IJavaProject)project);
                            IClasspathEntry[] resolvedEntries = container.getClasspathEntries();
                            int j = 0;
                            while (j < resolvedEntries.length) {
                                IClasspathEntry resolvedEntry;
                                if (cp.length() > 0) {
                                    cp.append(File.pathSeparator);
                                }
                                if ((resolvedEntry = resolvedEntries[j]).getEntryKind() == 2) {
                                    IWorkspaceRoot workspaceRoot = project.getProject().getWorkspace().getRoot();
                                    IProject proj = (IProject)workspaceRoot.findMember(resolvedEntry.getPath());
                                    IJavaProject javaProject = JavaCore.create((IProject)proj);
                                    cp.append(workspaceRoot.findMember(javaProject.getOutputLocation()).getLocation().toPortableString());
                                } else {
                                    cp.append(resolvedEntry.getPath().toPortableString());
                                }
                                ++j;
                            }
                            break;
                        }
                    }
                    ++i;
                }
                String bin = root;
                if (cp.length() > 0) {
                    cp.append(File.pathSeparator);
                }
                cp.append(bin);
                ArrayList<String> args = new ArrayList<String>();
                args.addAll(Arrays.asList("-d", bin, "-bootclasspath", bp.toString(), "-cp", cp.toString(), "-log", String.valueOf(root) + "/log.xml", "-1.5", "-sourcepath", sp.toString()));
                args.addAll(this.sources);
                this.sources = null;
                IFolder newFolder = project.getProject().getFolder(".buildas");
                if (!newFolder.exists()) {
                    newFolder.create(true, true, null);
                }
                writer = new PrintWriter(new BufferedOutputStream(new FileOutputStream(String.valueOf(root) + "/out.txt")));
                Main main = new Main(writer, writer, false, null);
                main.compile(args.toArray(new String[args.size()]));
                writer.close();
                project.getProject().findMember((IPath)new Path(".buildas")).refreshLocal(2, null);
                this.createProblems(project, root);
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.swt.tools.actionscript.core", "Problem compiling ActionScript", (Throwable)e));
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    void appendLibrary(StringBuffer compc, IProject project) {
        compc.append(" -external-library-path+=");
        compc.append(String.valueOf(project.getLocation().toPortableString()) + "/.buildas/" + project.getName() + ".swc");
    }

    void appendLibrary(StringBuffer compc, IPath path) {
        IPreferencesService service = Platform.getPreferencesService();
        String globalSWCPath = service.getString("org.eclipse.swt.tools.actionscript.core", "org.eclipse.swt.tools.actionscript.core.swcpath", "", null);
        if (globalSWCPath == null || globalSWCPath.length() == 0) {
            return;
        }
        String name = path.lastSegment();
        int index = name.lastIndexOf(46);
        if (index != -1) {
            name = name.substring(0, index);
        }
        name = String.valueOf(name) + ".swc";
        File file = new File(String.valueOf(globalSWCPath) + File.separator + name);
        if (file.exists()) {
            compc.append(" -external-library-path+=");
            compc.append(new Path(file.getAbsolutePath()).toPortableString());
        }
    }

    public void buildSWC(IJavaProject project) throws CoreException {
        try {
            String compcString;
            IClasspathEntry entry;
            IProject projectResource = project.getProject();
            IResource resource = projectResource.findMember((IPath)new Path(".buildas"));
            if (resource != null && !resource.exists()) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.swt.tools.actionscript.core", "Missing .buildas folder.", null));
            }
            resource.deleteMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            final String root = String.valueOf(projectResource.getLocation().toOSString()) + File.separator + ".buildas" + File.separator;
            this.generateResourceClass(project, ".buildas");
            final StringBuffer resourceSet = new StringBuffer();
            StringBuffer compc = new StringBuffer();
            compc.append("compc ");
            compc.append("-warnings=false");
            compc.append(" ");
            compc.append("-debug=");
            IPreferencesService service = Platform.getPreferencesService();
            boolean value = service.getBoolean("org.eclipse.swt.tools.actionscript.core", "org.eclipse.swt.tools.actionscript.core.enabledebug", false, null);
            compc.append((Object)value);
            compc.append(" -external-library-path+=");
            compc.append(String.valueOf(new Path(System.getProperty(FLEX_SDK)).toPortableString()) + "/frameworks/libs/framework.swc");
            IClasspathEntry[] entries = project.getRawClasspath();
            int i = 0;
            while (i < entries.length) {
                entry = entries[i];
                if (entry.getEntryKind() == 5 && entry.getPath().toPortableString().startsWith("org.eclipse.jdt.launching.JRE_CONTAINER")) {
                    IWorkspaceRoot workspaceRoot = project.getProject().getWorkspace().getRoot();
                    IProject jcl = (IProject)workspaceRoot.findMember("org.eclipse.swt.e4.jcl");
                    if (jcl != null && jcl.isOpen()) {
                        this.appendLibrary(compc, jcl);
                    } else {
                        this.appendLibrary(compc, ActionScriptCorePlugin.getDefault().getJCLLocation());
                    }
                }
                ++i;
            }
            i = 0;
            while (i < entries.length) {
                entry = entries[i];
                IPath path = entry.getPath();
                int kind = entry.getEntryKind();
                switch (kind) {
                    case 3: {
                        break;
                    }
                    case 2: {
                        IWorkspaceRoot workspaceRoot = projectResource.getWorkspace().getRoot();
                        IProject proj = (IProject)workspaceRoot.findMember(path);
                        this.appendLibrary(compc, proj);
                        break;
                    }
                    case 4: {
                        IClasspathEntry resolvedEntry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)entry);
                        this.appendLibrary(compc, resolvedEntry.getPath());
                        break;
                    }
                    case 1: {
                        this.appendLibrary(compc, path);
                        break;
                    }
                    case 5: {
                        if (path.toPortableString().startsWith("org.eclipse.jdt.launching.JRE_CONTAINER")) break;
                        IClasspathContainer container = JavaCore.getClasspathContainer((IPath)path, (IJavaProject)project);
                        IClasspathEntry[] resolvedEntries = container.getClasspathEntries();
                        int j = 0;
                        while (j < resolvedEntries.length) {
                            IClasspathEntry resolvedEntry = resolvedEntries[j];
                            if (resolvedEntry.getEntryKind() == 2) {
                                IWorkspaceRoot workspaceRoot = project.getProject().getWorkspace().getRoot();
                                IProject proj = (IProject)workspaceRoot.findMember(resolvedEntry.getPath());
                                this.appendLibrary(compc, proj);
                            } else {
                                this.appendLibrary(compc, resolvedEntries[j].getPath());
                            }
                            ++j;
                        }
                        break;
                    }
                }
                ++i;
            }
            compc.append(" ");
            compc.append("-source-path");
            compc.append(" ");
            compc.append(root);
            compc.append(" ");
            compc.append("-include-classes");
            resource.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if ("as".equals(resource.getFileExtension())) {
                        String tempString = resource.getLocation().toPortableString();
                        tempString = tempString.substring(root.length());
                        tempString = tempString.substring(0, tempString.length() - 3);
                        tempString = tempString.replace('/', '.');
                        resourceSet.append(" ");
                        resourceSet.append(tempString);
                    }
                    return true;
                }
            });
            compc.append(resourceSet);
            compc.append(" ");
            compc.append("-output=");
            compc.append(String.valueOf(root) + projectResource.getName() + ".swc");
            int count = 0;
            String result = null;
            do {
                compcString = compc.toString();
                Object existingID = projectResource.getSessionProperty(new QualifiedName("org.eclipse.swt.tools.actionscript.core", COMPILE_ID_KEY));
                if (existingID == null || !this.parseInfo(result = ActionScriptCorePlugin.getDefault().getManager().sendCommand("info " + existingID)).equals(compcString)) continue;
                compcString = "compile " + existingID;
            } while ((result = ActionScriptCorePlugin.getDefault().getManager().sendCommand(compcString)) == null && count++ < 3);
            if (result == null) {
                throw new Exception("Out of Memory");
            }
            String id = this.parseID(result);
            if (id != null) {
                projectResource.setSessionProperty(new QualifiedName("org.eclipse.swt.tools.actionscript.core", COMPILE_ID_KEY), (Object)id);
            }
            projectResource.findMember((IPath)new Path(".buildas")).refreshLocal(2, null);
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.swt.tools.actionscript.core", "Problem compiling SWC", (Throwable)e));
        }
    }

    void generateResourceClass(IJavaProject project, final String outputDir) throws JavaModelException, CoreException {
        final StringBuffer resourceFile = new StringBuffer();
        final String newLine = System.getProperty("line.separator");
        resourceFile.append("package {");
        resourceFile.append(newLine);
        resourceFile.append(newLine);
        resourceFile.append("public class Resources {");
        resourceFile.append(newLine);
        resourceFile.append(newLine);
        final IProject projectResource = project.getProject();
        IResource outputLocation = projectResource.getWorkspace().getRoot().findMember(project.getOutputLocation());
        final String root = String.valueOf(outputLocation.getLocation().toPortableString()) + "/";
        outputLocation.accept(new IResourceVisitor(){

            public boolean visit(IResource resource) {
                if (!"class".equals(resource.getFileExtension()) && resource instanceof IFile) {
                    String tempString = resource.getLocation().toPortableString();
                    tempString = tempString.substring(root.length());
                    resourceFile.append("\t[Embed(source=\"");
                    resourceFile.append(tempString);
                    resourceFile.append("\", mimeType=\"application/octet-stream\")]");
                    resourceFile.append(newLine);
                    resourceFile.append("\tpublic var ");
                    resourceFile.append(ActionScriptParticipant.this.mangleResourceName(tempString));
                    resourceFile.append(":Class;");
                    resourceFile.append(newLine);
                    resourceFile.append(newLine);
                    try {
                        ActionScriptLaunchConfigurationDelegate.createFile(projectResource, String.valueOf(outputDir) + "/" + tempString.substring(0, tempString.length() - resource.getName().length()), resource.getName(), ((IFile)resource).getContents());
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
                return true;
            }
        });
        resourceFile.append("}");
        resourceFile.append(newLine);
        resourceFile.append("}");
        ByteArrayInputStream contentStream = new ByteArrayInputStream(resourceFile.toString().getBytes());
        ActionScriptLaunchConfigurationDelegate.createFile(projectResource, outputDir, "Resources.as", contentStream);
    }

    void createProblems(IJavaProject project, String root) throws CoreException {
        IPreferencesService service = Platform.getPreferencesService();
        boolean showErrors = service.getBoolean("org.eclipse.swt.tools.actionscript.core", "org.eclipse.swt.tools.actionscript.core.showaserrors", false, null);
        if (showErrors) {
            try {
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(String.valueOf(root) + "/log.xml"));
                Document doc = null;
                try {
                    try {
                        doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(is));
                    }
                    catch (IOException iOException) {
                        ((InputStream)is).close();
                        return;
                    }
                }
                finally {
                    ((InputStream)is).close();
                }
                if (doc == null) {
                    return;
                }
                IWorkspaceRoot workspaceRoot = project.getProject().getWorkspace().getRoot();
                String projPath = workspaceRoot.getLocation().toPortableString();
                NodeList sources = doc.getDocumentElement().getElementsByTagName("sources");
                int i = 0;
                while (i < sources.getLength()) {
                    NodeList src = ((Element)sources.item(i)).getElementsByTagName("source");
                    int j = 0;
                    while (j < src.getLength()) {
                        Element source = (Element)src.item(j);
                        String path = source.getAttribute("path").replace('\\', '/');
                        if (path.startsWith(projPath)) {
                            path = path.substring(projPath.length());
                        }
                        IResource resource = workspaceRoot.findMember((IPath)new Path(path));
                        boolean hasProblems = false;
                        IMarker[] markers = resource.findMarkers("org.eclipse.jdt.core.problem", true, 2);
                        int m = 0;
                        while (m < markers.length) {
                            IMarker marker = markers[m];
                            if ("java_as".equals(marker.getAttribute("sourceId"))) {
                                marker.delete();
                            } else {
                                Object severity = marker.getAttribute("severity");
                                hasProblems |= severity != null && (Integer)severity == 2;
                            }
                            ++m;
                        }
                        if (!hasProblems) {
                            NodeList problems = source.getElementsByTagName("problems");
                            int k = 0;
                            while (k < problems.getLength()) {
                                NodeList problem = ((Element)problems.item(k)).getElementsByTagName("problem");
                                int l = 0;
                                while (l < problem.getLength()) {
                                    Element node = (Element)problem.item(l);
                                    if (resource != null) {
                                        int start = Integer.parseInt(node.getAttribute("charStart"));
                                        int end = Integer.parseInt(node.getAttribute("charEnd")) + 1;
                                        String message = "[AS] " + ((Element)node.getElementsByTagName("message").item(0)).getAttribute("value");
                                        IMarker marker = resource.createMarker("org.eclipse.jdt.core.problem");
                                        int severity = "ERROR".equals(node.getAttribute("severity")) ? 2 : 1;
                                        marker.setAttributes(new String[]{"message", "severity", "charStart", "charEnd", "sourceId"}, new Object[]{message, new Integer(severity), new Integer(start), new Integer(end), "java_as"});
                                    }
                                    ++l;
                                }
                                ++k;
                            }
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.swt.tools.actionscript.core", "Problem creating ActionScript problems", (Throwable)e));
            }
        }
    }

    public void cleanStarting(IJavaProject project) {
        if (!this.isActive(project)) {
            return;
        }
        this.sources = null;
        IResource resource = project.getProject().findMember((IPath)new Path(".buildas"));
        if (resource != null) {
            try {
                resource.delete(true, null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    String parseID(String str) {
        String prefix = "fcsh: Assigned ";
        if (str.startsWith(prefix)) {
            int startIndex;
            int endIndex = startIndex = prefix.length();
            while (endIndex < str.length()) {
                if (Character.isWhitespace(str.charAt(endIndex))) {
                    return str.substring(startIndex, endIndex);
                }
                ++endIndex;
            }
        }
        return null;
    }

    String parseInfo(String str) {
        String prefix = "compc: ";
        int startIndex = str.indexOf(prefix) + prefix.length();
        if (startIndex != -1) {
            int endIndex = str.length();
            int index = str.indexOf(13, startIndex + prefix.length());
            if (index != -1) {
                endIndex = index - 1;
            } else if ((index = str.indexOf(10, index + prefix.length())) != -1) {
                endIndex = index - 1;
            }
            return "compc " + str.substring(startIndex, endIndex);
        }
        return "";
    }

    String mangleResourceName(String tempString) {
        String mangledName = tempString.replace(' ', '_');
        mangledName = mangledName.replace('/', '_');
        mangledName = mangledName.replace('.', '_');
        mangledName = mangledName.replace('-', '_');
        return mangledName;
    }
}

