/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.actionscript.build;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.swt.tools.actionscript.ActionScriptCorePlugin;
import org.eclipse.swt.tools.actionscript.build.IActionScriptConsole;

public class ActionScriptCompilerManager {
    IActionScriptConsole console;
    Pattern errorPattern = Pattern.compile("\\((\\d+)\\)\\: col\\: (\\d+) (.*): ((.*))");
    ActionScriptCompilerReader output_reader;
    ActionScriptCompilerReader error_reader;
    ActionScriptCompilerWriter writer;
    String result;
    boolean outOfMemory;
    int currentJob;
    StringBuffer resultBuffer = new StringBuffer();
    Process fcsh;

    public ActionScriptCompilerManager() {
        this.reset();
    }

    public synchronized void reset() {
        this.stop();
        String fcshLocation = String.valueOf(System.getProperty("flex.sdk")) + File.separator + "bin" + File.separator + "fcsh.exe";
        try {
            this.fcsh = DebugPlugin.exec((String[])new String[]{fcshLocation}, null);
            this.output_reader = new ActionScriptCompilerReader(this, this.fcsh.getInputStream(), false);
            this.writer = new ActionScriptCompilerWriter(this.fcsh);
            this.error_reader = new ActionScriptCompilerReader(this, this.fcsh.getErrorStream(), true);
            this.output_reader.startUp();
            this.error_reader.startUp();
            this.writer.startUp();
        }
        catch (CoreException e) {
            ActionScriptCorePlugin.getDefault().getLog().log(e.getStatus());
            e.printStackTrace();
        }
    }

    public synchronized void stop() {
        if (this.fcsh != null) {
            this.fcsh.destroy();
        }
        if (this.output_reader != null) {
            this.output_reader = null;
        }
        if (this.writer != null) {
            this.writer = null;
        }
        if (this.error_reader != null) {
            this.error_reader = null;
        }
    }

    public synchronized String sendCommand(String command) {
        this.result = null;
        this.outOfMemory = false;
        this.resultBuffer = new StringBuffer();
        this.writer.sendCommand(command);
        if (this.console != null) {
            this.appendToConsole(command, false);
            this.appendToConsole(System.getProperty("line.separator"), false);
        }
        while (this.result == null) {
            try {
                this.wait();
                if (!this.outOfMemory) continue;
                return null;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return this.result;
    }

    public synchronized void appendLine(String line, boolean error) {
        this.resultBuffer.append(line);
        this.appendToConsole(line, error);
        if (error) {
            this.outOfMemory = this.checkOutOfMemory(line);
            if (this.outOfMemory) {
                this.endCommand();
            } else {
                this.parseErrorOutput(line);
            }
        }
    }

    private boolean checkOutOfMemory(String line) {
        if (line.startsWith("java.lang.OutOfMemory")) {
            this.reset();
            return true;
        }
        return false;
    }

    synchronized void appendToConsole(String line, boolean error) {
        if (this.console != null) {
            this.console.appendText(line, error);
        }
    }

    public synchronized void endCommand() {
        this.result = this.resultBuffer.toString();
        this.notifyAll();
    }

    public void setConsole(IActionScriptConsole console) {
        this.console = console;
    }

    void parseErrorOutput(String line) {
        String path;
        IResource resource;
        IWorkspaceRoot root;
        String workspaceRoot;
        String file;
        Matcher matcher = this.errorPattern.matcher(line);
        if (matcher.find() && (file = line.substring(0, matcher.start())).startsWith(workspaceRoot = (root = ResourcesPlugin.getWorkspace().getRoot()).getLocation().toOSString()) && (resource = root.findMember(path = file.substring(workspaceRoot.length()))) != null) {
            try {
                IMarker newMarker = resource.createMarker("org.eclipse.core.resources.problemmarker");
                newMarker.setAttribute("message", (Object)("[AS]: " + matcher.group(4)));
                newMarker.setAttribute("severity", matcher.group(3).equals("Error") ? 2 : 1);
                newMarker.setAttribute("lineNumber", Integer.parseInt(matcher.group(1)));
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    class ActionScriptCompilerReader
    implements Runnable {
        Thread fcshThread;
        BufferedReader reader;
        ActionScriptCompilerManager manager;
        boolean isErrorStream;

        public ActionScriptCompilerReader(ActionScriptCompilerManager manager, InputStream stream, boolean isErrorStream) {
            this.manager = manager;
            this.reader = new BufferedReader(new InputStreamReader(stream));
            this.isErrorStream = isErrorStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.fcshThread != null) {
                ActionScriptCompilerReader actionScriptCompilerReader = this;
                synchronized (actionScriptCompilerReader) {
                    try {
                        int c;
                        StringBuffer buffer = new StringBuffer();
                        while ((c = this.reader.read()) != -1) {
                            buffer.append((char)c);
                            if (c == 10) {
                                this.manager.appendLine(buffer.toString(), this.isErrorStream);
                            } else {
                                if (buffer.indexOf("(fcsh) ") != 0) continue;
                                this.manager.appendLine(buffer.toString(), this.isErrorStream);
                                this.manager.endCommand();
                            }
                            break;
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        public void startUp() {
            this.fcshThread = new Thread((Runnable)this, "Flex Compiler Shell Reader Thread");
            this.fcshThread.setDaemon(true);
            this.fcshThread.setPriority(4);
            this.fcshThread.start();
        }
    }

    class ActionScriptCompilerWriter
    implements Runnable {
        Thread fcshThread;
        Process fcshProcess;
        PrintWriter writer;
        LinkedList jobs = new LinkedList();

        public ActionScriptCompilerWriter(Process fcshProcess) {
            this.fcshProcess = fcshProcess;
            this.writer = new PrintWriter(new OutputStreamWriter(fcshProcess.getOutputStream()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.fcshThread != null) {
                ActionScriptCompilerWriter actionScriptCompilerWriter = this;
                synchronized (actionScriptCompilerWriter) {
                    try {
                        if (this.jobs.isEmpty()) {
                            Thread.sleep(50L);
                        } else {
                            String nextCommand = (String)this.jobs.removeFirst();
                            this.writer.println(nextCommand);
                            this.writer.flush();
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        public void startUp() {
            this.fcshThread = new Thread((Runnable)this, "Flex Compiler Shell Writer Thread");
            this.fcshThread.setDaemon(true);
            this.fcshThread.setPriority(4);
            this.fcshThread.start();
        }

        public void sendCommand(String command) {
            this.jobs.add(command);
        }
    }
}

