/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.tools.actionscript.debug;

import org.eclipse.debug.core.*;
import org.eclipse.debug.core.model.*;

import flash.tools.debugger.*;

public class ActionScriptVariable extends DebugElement implements IVariable {

	ActionScriptDebugTarget target;
	Variable variable;

	public ActionScriptVariable(ActionScriptDebugTarget target, Variable variable) {
		super(target);
		this.target = target;
		this.variable = variable;
	}

	public String getName() throws DebugException {
		return variable.getName();
	}

	public String getReferenceTypeName() throws DebugException {
		return variable.getQualifiedName();
	}

	public IValue getValue() throws DebugException {
		Value value = variable.getValue();
		return new ActionScriptVariableValue(this, value);
	}

	public boolean hasValueChanged() throws DebugException {
		return false;
	}

	public IDebugTarget getDebugTarget() {
		return target;
	}

	public ILaunch getLaunch() {
		return target.getLaunch();
	}

	public String getModelIdentifier() {
		return target.getModelIdentifier();
	}

	public void setValue(String expression) throws DebugException {
	}

	public void setValue(IValue value) throws DebugException {
	}

	public boolean supportsValueModification() {
		return false; 
	}

	public boolean verifyValue(String expression) throws DebugException {
		return false;
	}

	public boolean verifyValue(IValue value) throws DebugException {
		return false;
	}

}
