/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.tools.actionscript.debug;

import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.DebugElement;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.swt.tools.actionscript.ActionScriptCorePlugin;

import flash.tools.debugger.Frame;
import flash.tools.debugger.NotConnectedException;
import flash.tools.debugger.Session;

public class ActionScriptThread extends DebugElement implements IThread {

	private ActionScriptDebugTarget target;

	public ActionScriptThread(ActionScriptDebugTarget target) {
		super(target);
		this.target = target;
		fireCreationEvent();
	}

	public IBreakpoint[] getBreakpoints() {
		return new IBreakpoint[0];
	}

	public String getName() throws DebugException {
		return "Thread [main]";
	}

	public int getPriority() throws DebugException {
		return Thread.NORM_PRIORITY;
	}

	public IStackFrame[] getStackFrames() throws DebugException {
		try {
			Session session = target.session;
			Frame[] frames = session.getFrames();
			int len = frames.length;
			IStackFrame[] result = new IStackFrame[len];
			for (int i = 0; i < len; i++) {
				result[i] = new ActionScriptFrame(target, frames[i]);
			}
			return result;
		} catch (NotConnectedException e) {
			Status status = new Status(Status.ERROR, ActionScriptCorePlugin.PLUGIN_ID, "Error getting stack frames", e);
			throw new DebugException(status);
		}
	}

	public IStackFrame getTopStackFrame() throws DebugException {
		if (!target.isSuspended()) return null;
		try {
			Session session = target.session;
			Frame[] frames = session.getFrames();
			if (frames.length == 0) return null;
			return new ActionScriptFrame(target, frames[0]);
		} catch (NotConnectedException e) {
			Status status = new Status(Status.ERROR, ActionScriptCorePlugin.PLUGIN_ID, "Error getting stack frames", e);
			throw new DebugException(status);
		}
	}

	public boolean hasStackFrames() throws DebugException {
		return target.isSuspended();
	}

	public IDebugTarget getDebugTarget() {
		return target;
	}

	public ILaunch getLaunch() {
		return target.getLaunch();
	}

	public String getModelIdentifier() {
		return target.getModelIdentifier();
	}

	public boolean canResume() {
		return target.canResume();
	}

	public boolean canSuspend() {
		return target.canSuspend();
	}

	public boolean isSuspended() {
		return target.isSuspended();
	}

	public void resume() throws DebugException {
		target.resume();
	}

	public void suspend() throws DebugException {
		target.suspend();
	}

	public boolean canStepInto() {
		return target.canStepInto();
	}

	public boolean canStepOver() {
		return target.canStepOver();
	}

	public boolean canStepReturn() {
		return target.canStepReturn();
	}

	public boolean isStepping() {
		return target.isStepping();
	}

	public void stepInto() throws DebugException {
		target.stepInto();
	}

	public void stepOver() throws DebugException {
		target.stepOver();
	}

	public void stepReturn() throws DebugException {
		target.stepReturn();
	}

	public boolean canTerminate() {
		return target.canTerminate();
	}

	public boolean isTerminated() {
		return target.isTerminated();
	}

	public void terminate() throws DebugException {
		fireTerminateEvent();
		target.terminate();
	}

}