/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.ui.editor.render;

import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.e4.xwt.ILoadingContext;
import org.eclipse.e4.xwt.XWT;
import org.eclipse.e4.xwt.ui.editor.render.CanvasManager;
import org.eclipse.e4.xwt.ui.utils.ProjectContext;
import org.eclipse.e4.xwt.vex.VEXRenderer;
import org.eclipse.e4.xwt.vex.swt.ImageCapture;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XWTRender
implements VEXRenderer {
    private String hostClassName;
    private Map<String, Object> options;
    private CanvasManager canvasManager;
    private ProjectContext projectContext;
    private PropertyChangeListener changeListener;
    private Shell shell;
    private int time = 0;

    public XWTRender(Canvas container, PropertyChangeListener changeListener) {
        this.changeListener = changeListener;
        this.canvasManager = new CanvasManager(container);
        this.options = new HashMap<String, Object>();
        this.options.put("XWT.DesignMode", Boolean.TRUE);
    }

    public void dispose() {
        if (this.canvasManager != null) {
            this.canvasManager.dispose();
            this.canvasManager = null;
        }
        if (this.shell != null) {
            this.shell.dispose();
        }
    }

    public boolean updateView(String code, IFile file) {
        if (this.shell != null) {
            this.shell.dispose();
        }
        Control control = Display.getCurrent().getFocusControl();
        try {
            Control rootElement;
            IJavaProject javaProject = JavaCore.create((IProject)file.getProject());
            if (!javaProject.exists()) {
                return false;
            }
            if (this.projectContext != null) {
                this.projectContext.removePropertyChangeListener(this.changeListener);
            }
            this.projectContext = ProjectContext.getContext((IJavaProject)javaProject);
            XWT.setLoadingContext((ILoadingContext)this.projectContext);
            try {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(code.getBytes());
                rootElement = XWT.loadWithOptions((InputStream)inputStream, (URL)file.getLocationURI().toURL(), this.options);
            }
            catch (Exception exception) {
                if (control != null) {
                    control.setFocus();
                }
                return false;
            }
            if (rootElement != null) {
                Rectangle rectangle = new Rectangle(0, 0, 0, 0);
                Monitor[] monitorArray = Display.getDefault().getMonitors();
                int n = monitorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Monitor monitor = monitorArray[n2];
                    Rectangle bounds = monitor.getBounds();
                    rectangle = rectangle.union(bounds);
                    ++n2;
                }
                this.shell = rootElement.getShell();
                this.shell.setFocus();
                this.shell.setLocation(rectangle.x + rectangle.width + 200, rectangle.y + rectangle.height + 200);
                this.shell.open();
                Object hostClr = XWT.getCLR((Widget)rootElement);
                if (hostClr != null) {
                    this.hostClassName = hostClr.getClass().getName();
                }
                ArrayList<Browser> browsers = new ArrayList<Browser>();
                this.findBrowser(rootElement, browsers);
                if (!browsers.isEmpty()) {
                    this.time = 0;
                    final int total = browsers.size();
                    ProgressListener listener = new ProgressListener(){

                        public void changed(ProgressEvent event) {
                            if (XWTRender.this.canvasManager == null || XWTRender.this.shell == null || XWTRender.this.shell.isDisposed()) {
                                return;
                            }
                            Image image = ImageCapture.getImageCapture().captureImage((Control)XWTRender.this.shell);
                            XWTRender.this.canvasManager.setImage(image);
                        }

                        public void completed(ProgressEvent event) {
                            if (XWTRender.this.canvasManager == null || XWTRender.this.shell == null || XWTRender.this.shell.isDisposed()) {
                                return;
                            }
                            Image image = ImageCapture.getImageCapture().captureImage((Control)XWTRender.this.shell);
                            XWTRender.this.canvasManager.setImage(image);
                            XWTRender xWTRender = XWTRender.this;
                            xWTRender.time = xWTRender.time + 1;
                            if (XWTRender.this.time == total) {
                                XWTRender.this.shell.close();
                            }
                        }
                    };
                    for (Browser browser : browsers) {
                        browser.addProgressListener(listener);
                    }
                } else if (this.shell != null && !this.shell.isDisposed()) {
                    Image image = ImageCapture.getImageCapture().defaultCapture((Control)this.shell);
                    this.canvasManager.setImage(image);
                    this.shell.close();
                }
                this.projectContext.addPropertyChangeListener(this.changeListener);
            }
        }
        finally {
            if (control != null) {
                control.setFocus();
            }
        }
        return true;
    }

    private void findBrowser(Control control, List<Browser> browsers) {
        if (control instanceof Composite) {
            Control[] children;
            Composite parent = (Composite)control;
            Control[] controlArray = children = parent.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                if (child instanceof Browser) {
                    browsers.add((Browser)child);
                }
                this.findBrowser(child, browsers);
                ++n2;
            }
        }
    }

    public String getHostClassName() {
        return this.hostClassName;
    }

    public void setHostClassName(String hostClassName) {
        this.hostClassName = hostClassName;
    }
}

