/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tests;

import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.e4.xwt.XWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XWTTestCase
extends TestCase {
    protected Control root;

    protected void runTest(URL url) {
        this.runTest(url, null, null);
    }

    protected void runTest(URL url, Runnable prepareAction, Runnable checkAction) {
        this.runTest(url, Collections.EMPTY_MAP, prepareAction, checkAction);
    }

    protected void runTest(URL url, Object dataContext, Runnable prepareAction, Runnable checkAction) {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("XWT.DataContext", dataContext);
        this.runTest(url, options, prepareAction, checkAction);
    }

    protected void runTest(URL url, Map<String, Object> options, Runnable prepareAction, Runnable checkAction) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
                this.root = XWT.loadWithOptions((URL)url, options);
                XWTTestCase.assertNotNull((Object)this.root);
                Shell shell = this.root.getShell();
                shell.open();
                Display display = shell.getDisplay();
                if (prepareAction != null) {
                    display.asyncExec(prepareAction);
                }
                while (display.readAndDispatch()) {
                }
                if (checkAction != null) {
                    display.syncExec(checkAction);
                    while (display.readAndDispatch()) {
                    }
                }
                XWTTestCase.assertFalse((boolean)this.root.isDisposed());
                shell.close();
                while (display.readAndDispatch()) {
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                XWTTestCase.fail((String)e.getMessage());
                Thread.currentThread().setContextClassLoader(classLoader);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    protected void runDebugTest(URL url, Runnable prepareAction, Runnable checkAction1) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
                this.root = XWT.load((URL)url);
                XWTTestCase.assertNotNull((Object)this.root);
                Shell shell = this.root.getShell();
                shell.open();
                Display display = shell.getDisplay();
                if (prepareAction != null) {
                    display.asyncExec(prepareAction);
                }
                while (!display.isDisposed()) {
                    display.readAndDispatch();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                XWTTestCase.fail((String)e.getMessage());
                Thread.currentThread().setContextClassLoader(classLoader);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    protected void selectButton(Button button) {
        Point size = button.getSize();
        Display display = button.getDisplay();
        Event upEvent = new Event();
        upEvent.widget = button;
        upEvent.button = 1;
        upEvent.type = 4;
        upEvent.x = size.x / 2;
        upEvent.y = size.y / 2;
        display.post(upEvent);
        button.setSelection(true);
        button.notifyListeners(13, upEvent);
    }

    protected void assertText(String name, String value) {
        Object element = XWT.findElementByName((Widget)this.root, (String)name);
        XWTTestCase.assertTrue((boolean)(element instanceof Text));
        Text text = (Text)element;
        XWTTestCase.assertEquals((String)value, (String)text.getText());
    }

    protected void setText(String name, String value) {
        Object element = XWT.findElementByName((Widget)this.root, (String)name);
        XWTTestCase.assertTrue((boolean)(element instanceof Text));
        Text text = (Text)element;
        text.setText(value);
    }

    protected void assertEqualsArray(Object[] source, Object[] target) {
        XWTTestCase.assertEquals((int)source.length, (int)target.length);
        int i = 0;
        while (i < source.length) {
            XWTTestCase.assertEquals((Object)source[i], (Object)target[i]);
            ++i;
        }
    }
}

