/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.workbench.ui.renderers.swt;

import org.eclipse.e4.ui.model.application.ApplicationPackage;
import org.eclipse.e4.ui.model.application.MPart;
import org.eclipse.e4.ui.model.application.MSashForm;
import org.eclipse.e4.workbench.ui.renderers.swt.SWTPartRenderer;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SashRenderer
extends SWTPartRenderer {
    public Widget createWidget(MPart<?> part, Object parent) {
        if (!(part instanceof MSashForm) || !(parent instanceof Composite)) {
            return null;
        }
        Widget parentWidget = (Widget)parent;
        int orientation = part.getPolicy() != null && part.getPolicy().startsWith("Horizontal") ? 256 : 512;
        SashForm newSash = new SashForm((Composite)parentWidget, 0x10000 | orientation);
        this.bindWidget(part, newSash);
        newSash.setVisible(true);
        return newSash;
    }

    @Override
    public void childAdded(MPart<?> parentElement, MPart<?> element) {
        super.childAdded(parentElement, element);
        if (!(parentElement.getWidget() instanceof SashForm)) {
            return;
        }
        for (MPart part : parentElement.getChildren()) {
            Control partCtrl = (Control)part.getWidget();
            if (partCtrl == null) continue;
            Control outerMost = this.getOutermost(partCtrl);
            outerMost.moveBelow(null);
        }
    }

    public void postProcess(MPart<?> part) {
        if (part instanceof MSashForm) {
            EList kids = part.getChildren();
            if (kids.size() == 0) {
                return;
            }
            int visCount = 0;
            for (MPart mPart : kids) {
                if (mPart.getWidget() == null) continue;
                ++visCount;
            }
            final SashForm sashForm = (SashForm)part.getWidget();
            MSashForm sashPart = (MSashForm)part;
            EList weightList = sashPart.getWeights();
            if (weightList.size() != visCount) {
                weightList.clear();
                int i = weightList.size();
                while (i < visCount) {
                    weightList.add(new Integer(100));
                    ++i;
                }
            }
            if (weightList.size() > 0) {
                int count = 0;
                int[] weights = new int[weightList.size()];
                for (Integer integer : weightList) {
                    weights[count++] = integer;
                }
                sashForm.setWeights(weights);
            }
            sashPart.eAdapters().add((Object)new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (ApplicationPackage.Literals.MSASH_FORM__WEIGHTS.equals(msg.getFeature()) && msg.getNewValue() != null) {
                        SashRenderer.this.synchWeightsToModel(sashForm);
                    }
                }
            });
            Control[] childCtrls = sashForm.getChildren();
            int i = 0;
            while (i < childCtrls.length) {
                childCtrls[i].addControlListener(new ControlListener(){

                    public void controlMoved(ControlEvent e) {
                    }

                    public void controlResized(ControlEvent e) {
                        SashRenderer.this.synchWeights((Control)e.widget);
                    }
                });
                ++i;
            }
        }
    }

    private void synchWeightsToModel(SashForm sf) {
        EList modelWeights;
        if (sf.isDisposed()) {
            return;
        }
        MSashForm sfm = (MSashForm)sf.getData("modelElement");
        int[] ctrlWeights = sf.getWeights();
        if (ctrlWeights.length == (modelWeights = sfm.getWeights()).size()) {
            boolean overWrite = false;
            int i = 0;
            for (Integer integer : modelWeights) {
                if (integer == ctrlWeights[i++]) continue;
                overWrite = true;
                break;
            }
            if (overWrite) {
                int[] weights = new int[modelWeights.size()];
                i = 0;
                while (i < weights.length) {
                    weights[i] = (Integer)modelWeights.get(i);
                    ++i;
                }
                sf.setWeights(weights);
            }
        }
    }

    protected void synchWeights(Control ctrl) {
        int i;
        if (!(ctrl.getParent() instanceof SashForm)) {
            return;
        }
        SashForm sf = (SashForm)ctrl.getParent();
        MSashForm sfm = (MSashForm)sf.getData("modelElement");
        int[] ctrlWeights = sf.getWeights();
        EList modelWeights = sfm.getWeights();
        boolean overWrite = false;
        if (ctrlWeights.length != modelWeights.size()) {
            overWrite = true;
        } else {
            i = 0;
            for (Integer integer : modelWeights) {
                if (integer == ctrlWeights[i++]) continue;
                overWrite = true;
                break;
            }
        }
        if (overWrite) {
            modelWeights.clear();
            i = 0;
            while (i < ctrlWeights.length) {
                modelWeights.add((Object)ctrlWeights[i]);
                ++i;
            }
        }
    }
}

