/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.workbench.ui.renderers.swt;

import java.util.HashMap;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.services.context.IEclipseContext;
import org.eclipse.e4.ui.model.application.ApplicationPackage;
import org.eclipse.e4.ui.model.application.MHandledItem;
import org.eclipse.e4.ui.model.application.MParameter;
import org.eclipse.e4.ui.model.application.MPart;
import org.eclipse.e4.ui.services.EBindingService;
import org.eclipse.e4.ui.services.ECommandService;
import org.eclipse.e4.ui.services.EHandlerService;
import org.eclipse.e4.ui.workbench.swt.util.ISWTResourceUtiltities;
import org.eclipse.e4.workbench.ui.IResourceUtiltities;
import org.eclipse.e4.workbench.ui.internal.Activator;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandledContributionItem
extends ContributionItem {
    private static final int VISIBLE_ITEM_REFRESH = 2000;
    private MHandledItem model;
    private Widget widget;
    private Listener menuItemListener;
    private IEclipseContext context;
    private LocalResourceManager localResourceManager;
    private AdapterImpl modelListener;
    private IMenuListener menuListener = new IMenuListener(){

        public void menuAboutToShow(IMenuManager manager) {
            HandledContributionItem.this.update(null);
        }
    };

    public HandledContributionItem(MHandledItem model, IEclipseContext context) {
        this.model = model;
        this.context = context;
        this.generateCommand();
        this.addModelListener();
        this.updateVisible();
    }

    private void generateCommand() {
        if (this.model.getCommand() == null) {
            return;
        }
        if (this.model.getWbCommand() == null) {
            ECommandService cs = (ECommandService)this.context.get(ECommandService.class.getName());
            Command cmd = cs.getCommand(this.model.getCommand().getId());
            EList modelParms = this.model.getParameters();
            if (modelParms.isEmpty()) {
                Activator.trace((String)"/trace/menus", (String)("command: " + cmd), null);
                this.model.setWbCommand(new ParameterizedCommand(cmd, null));
                return;
            }
            HashMap<String, String> parms = new HashMap<String, String>();
            for (MParameter parm : modelParms) {
                parms.put(parm.getName(), parm.getValue());
            }
            ParameterizedCommand parmCmd = ParameterizedCommand.generateCommand((Command)cmd, parms);
            Activator.trace((String)"/trace/menus", (String)("command: " + parmCmd), null);
            this.model.setWbCommand(parmCmd);
        }
    }

    public void fill(Menu menu, int index) {
        if (this.model == null) {
            return;
        }
        if (this.widget != null) {
            return;
        }
        int style = 8;
        MenuItem item = null;
        item = index >= 0 ? new MenuItem(menu, style, index) : new MenuItem(menu, style);
        item.setData((Object)this);
        item.addListener(12, this.getItemListener());
        item.addListener(13, this.getItemListener());
        this.widget = item;
        this.update(null);
        this.updateIcons();
    }

    public void fill(ToolBar parent, int index) {
        if (this.model == null) {
            return;
        }
        if (this.widget != null) {
            return;
        }
        int style = 8;
        ToolItem item = null;
        item = index >= 0 ? new ToolItem(parent, style, index) : new ToolItem(parent, style);
        item.setData((Object)this);
        item.addListener(12, this.getItemListener());
        item.addListener(13, this.getItemListener());
        this.widget = item;
        this.update(null);
        this.updateIcons();
        this.widget.getDisplay().timerExec(2000, new Runnable(){

            public void run() {
                if (HandledContributionItem.this.widget == null || HandledContributionItem.this.widget.isDisposed()) {
                    return;
                }
                ToolItem item = (ToolItem)HandledContributionItem.this.widget;
                item.setEnabled(HandledContributionItem.this.canExecuteItem(HandledContributionItem.this.widget.getDisplay()));
                HandledContributionItem.this.widget.getDisplay().timerExec(2000, (Runnable)this);
            }
        });
    }

    private void addModelListener() {
        if (this.modelListener == null) {
            this.modelListener = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (ApplicationPackage.Literals.MITEM__NAME.equals(msg.getFeature()) || ApplicationPackage.Literals.MITEM__TOOLTIP.equals(msg.getFeature())) {
                        if (HandledContributionItem.this.widget != null) {
                            HandledContributionItem.this.widget.getDisplay().asyncExec(new Runnable(){

                                public void run() {
                                    HandledContributionItem.this.update(null);
                                }
                            });
                        }
                    } else if (ApplicationPackage.Literals.MITEM__ICON_URI.equals(msg.getFeature())) {
                        if (HandledContributionItem.this.widget != null) {
                            HandledContributionItem.this.widget.getDisplay().asyncExec(new Runnable(){

                                public void run() {
                                    HandledContributionItem.this.updateIcons();
                                }
                            });
                        }
                    } else if (ApplicationPackage.Literals.MHANDLED_ITEM__VISIBLE.equals(msg.getFeature())) {
                        HandledContributionItem.this.updateVisible();
                    }
                }
            };
            this.model.eAdapters().add((Object)this.modelListener);
        }
    }

    private void updateVisible() {
        this.setVisible(this.model.isVisible());
        IContributionManager parent = this.getParent();
        if (parent != null) {
            parent.markDirty();
        }
    }

    public void update() {
        this.update(null);
    }

    public void update(String id) {
        if (this.widget instanceof MenuItem) {
            this.updateMenuItem();
        } else if (this.widget instanceof ToolItem) {
            this.updateToolItem();
        }
    }

    private void updateMenuItem() {
        TriggerSequence binding;
        EBindingService bindingService;
        MenuItem item = (MenuItem)this.widget;
        String text = this.model.getName();
        ParameterizedCommand parmCmd = this.model.getWbCommand();
        String keyBindingText = null;
        if (parmCmd != null && (bindingService = (EBindingService)this.context.get(EBindingService.class.getName())) != null && (binding = bindingService.getBestActiveBindingFor(parmCmd)) != null) {
            keyBindingText = binding.format();
        }
        if (text != null) {
            if (keyBindingText == null) {
                item.setText(text);
            } else {
                item.setText(String.valueOf(text) + '\t' + keyBindingText);
            }
        }
        item.setEnabled(this.canExecuteItem(this.widget.getDisplay()));
    }

    private void updateToolItem() {
        String tooltip;
        ToolItem item = (ToolItem)this.widget;
        String text = this.model.getName();
        if (text != null) {
            item.setText(text);
        }
        if ((tooltip = this.model.getTooltip()) != null) {
            item.setToolTipText(tooltip);
        }
        item.setEnabled(this.canExecuteItem(this.widget.getDisplay()));
    }

    private void updateIcons() {
        if (this.widget instanceof MenuItem) {
            MenuItem item = (MenuItem)this.widget;
            LocalResourceManager m = new LocalResourceManager(JFaceResources.getResources());
            String iconURI = this.model.getIconURI();
            if (iconURI != null && !iconURI.equals("null")) {
                ISWTResourceUtiltities resUtils = (ISWTResourceUtiltities)this.context.get(IResourceUtiltities.class.getName());
                ImageDescriptor icon = (ImageDescriptor)resUtils.imageDescriptorFromURI(URI.createURI((String)iconURI));
                try {
                    item.setImage(icon == null ? null : m.createImage(icon));
                }
                catch (DeviceResourceException e) {
                    icon = ImageDescriptor.getMissingImageDescriptor();
                    item.setImage(m.createImage(icon));
                    Activator.trace((String)"/trace/menus", (String)("failed to create image " + iconURI), (Throwable)e);
                }
                this.disposeOldImages();
                this.localResourceManager = m;
            }
        } else if (this.widget instanceof ToolItem) {
            ToolItem item = (ToolItem)this.widget;
            LocalResourceManager m = new LocalResourceManager(JFaceResources.getResources());
            String iconURI = this.model.getIconURI();
            if (iconURI != null && !iconURI.equals("null")) {
                ISWTResourceUtiltities resUtils = (ISWTResourceUtiltities)this.context.get(IResourceUtiltities.class.getName());
                ImageDescriptor icon = (ImageDescriptor)resUtils.imageDescriptorFromURI(URI.createURI((String)iconURI));
                try {
                    item.setImage(icon == null ? null : m.createImage(icon));
                }
                catch (DeviceResourceException e) {
                    icon = ImageDescriptor.getMissingImageDescriptor();
                    item.setImage(m.createImage(icon));
                    Activator.trace((String)"/trace/menus", (String)("failed to create image " + iconURI), (Throwable)e);
                }
                this.disposeOldImages();
                this.localResourceManager = m;
            }
        }
    }

    private void disposeOldImages() {
        if (this.localResourceManager != null) {
            this.localResourceManager.dispose();
            this.localResourceManager = null;
        }
    }

    private Listener getItemListener() {
        if (this.menuItemListener == null) {
            this.menuItemListener = new Listener(){

                public void handleEvent(Event event) {
                    switch (event.type) {
                        case 12: {
                            HandledContributionItem.this.handleWidgetDispose(event);
                            break;
                        }
                        case 13: {
                            if (event.widget == null) break;
                            HandledContributionItem.this.handleWidgetSelection(event);
                        }
                    }
                }
            };
        }
        return this.menuItemListener;
    }

    private void handleWidgetDispose(Event event) {
        if (event.widget == this.widget) {
            this.widget.removeListener(13, this.getItemListener());
            this.widget.removeListener(12, this.getItemListener());
            this.widget = null;
            this.disposeOldImages();
        }
    }

    public void dispose() {
        if (this.widget != null) {
            this.widget.dispose();
            this.widget = null;
        }
    }

    private void handleWidgetSelection(Event event) {
        if (this.widget != null && !this.widget.isDisposed() && this.canExecuteItem(this.widget.getDisplay())) {
            this.executeItem(this.widget.getDisplay());
        }
    }

    private IEclipseContext getFocusContext(Display display) {
        Control control = display.getFocusControl();
        Object partObj = null;
        Object localContext = null;
        while (control != null && localContext == null && !(partObj instanceof MPart)) {
            partObj = control.getData("modelElement");
            localContext = control.getData("localContext");
            control = control.getParent();
        }
        if (localContext != null) {
            return (IEclipseContext)localContext;
        }
        if (partObj == null) {
            return this.context;
        }
        MPart part = (MPart)partObj;
        return this.getContext(part);
    }

    private IEclipseContext getContext(MPart<?> part) {
        IEclipseContext c = null;
        while (c == null && part != null) {
            c = part.getContext();
            part = part.getParent();
        }
        return c;
    }

    protected boolean canExecuteItem(Display display) {
        ParameterizedCommand parmCmd = this.model.getWbCommand();
        if (parmCmd == null) {
            return false;
        }
        IEclipseContext context = this.getFocusContext(display);
        EHandlerService hs = (EHandlerService)context.get(EHandlerService.class.getName());
        if (hs == null) {
            return true;
        }
        return hs.canExecute(parmCmd);
    }

    protected Object executeItem(Display display) {
        ParameterizedCommand parmCmd = this.model.getWbCommand();
        if (parmCmd == null) {
            return false;
        }
        IEclipseContext context = this.getFocusContext(display);
        EHandlerService hs = (EHandlerService)context.get(EHandlerService.class.getName());
        if (hs == null) {
            return null;
        }
        return hs.executeHandler(parmCmd);
    }

    public void setParent(IContributionManager parent) {
        IMenuManager menuMgr;
        if (this.getParent() instanceof IMenuManager) {
            menuMgr = (IMenuManager)this.getParent();
            menuMgr.removeMenuListener(this.menuListener);
        }
        if (parent instanceof IMenuManager) {
            menuMgr = (IMenuManager)parent;
            menuMgr.addMenuListener(this.menuListener);
        }
        super.setParent(parent);
    }
}

