/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.widgets;

import org.eclipse.e4.ui.widgets.CTabFolder;
import org.eclipse.e4.ui.widgets.CTabItem;
import org.eclipse.e4.ui.widgets.ETabItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;

public class ETabFolder
extends CTabFolder {
    boolean webbyStyle = false;
    static final int[] E_TOP_LEFT_CORNER;
    static final int[] E_TOP_RIGHT_CORNER;
    static final int[] E_TOP_LEFT_CORNER_BORDERLESS;
    static final int[] E_TOP_RIGHT_CORNER_BORDERLESS;
    int tabTopMargin = 0;
    int tabTopSelectionPadding = 6;
    int tabTopPadding = 3;
    int tabBottomPadding = 3;
    int tabLeftMargin = 2;
    int tabRightMargin = 0;
    int tabMarginOffset = 0;
    Color topBorderColor;
    Color bottomBorderColor;
    Color tabBorderColor;
    Color unselectedTabBackgroundColor;

    static {
        int[] nArray = new int[14];
        nArray[1] = 5;
        nArray[2] = 1;
        nArray[3] = 4;
        nArray[4] = 1;
        nArray[5] = 3;
        nArray[6] = 2;
        nArray[7] = 2;
        nArray[8] = 3;
        nArray[9] = 1;
        nArray[10] = 4;
        nArray[11] = 1;
        nArray[12] = 5;
        E_TOP_LEFT_CORNER = nArray;
        int[] nArray2 = new int[14];
        nArray2[0] = -5;
        nArray2[2] = -4;
        nArray2[3] = 1;
        nArray2[4] = -3;
        nArray2[5] = 1;
        nArray2[6] = -2;
        nArray2[7] = 2;
        nArray2[8] = -1;
        nArray2[9] = 3;
        nArray2[10] = -1;
        nArray2[11] = 4;
        nArray2[13] = 5;
        E_TOP_RIGHT_CORNER = nArray2;
        E_TOP_LEFT_CORNER_BORDERLESS = new int[0];
        E_TOP_RIGHT_CORNER_BORDERLESS = new int[0];
    }

    public ETabFolder(Composite parent, int style) {
        super(parent, style);
    }

    void init(int style) {
        super.init(style);
        this.topBorderColor = this.getDisplay().getSystemColor(18);
        this.bottomBorderColor = this.getDisplay().getSystemColor(18);
        this.tabBorderColor = this.getDisplay().getSystemColor(18);
        this.unselectedTabBackgroundColor = this.getBackground();
    }

    public Color getTopBorderColor() {
        return this.topBorderColor;
    }

    public void setTopBorderColor(Color color) {
        this.checkWidget();
        if (this.topBorderColor == color) {
            return;
        }
        if (color == null) {
            color = this.getDisplay().getSystemColor(18);
        }
        this.topBorderColor = color;
        if (this.selectedIndex > -1) {
            this.redraw();
        }
    }

    public Color getBottomBorderColor() {
        return this.bottomBorderColor;
    }

    public void setBottomBorderColor(Color color) {
        this.checkWidget();
        if (this.bottomBorderColor == color) {
            return;
        }
        if (color == null) {
            color = this.getDisplay().getSystemColor(18);
        }
        this.bottomBorderColor = color;
        this.redraw();
    }

    public Color getTabBorderColor() {
        return this.tabBorderColor;
    }

    public void setTabBorderColor(Color color) {
        this.checkWidget();
        if (this.tabBorderColor == color) {
            return;
        }
        if (color == null) {
            color = this.getDisplay().getSystemColor(18);
        }
        this.tabBorderColor = color;
        this.redraw();
    }

    public Color getUnselectedTabBackgroundColor() {
        return this.unselectedTabBackgroundColor;
    }

    public void setUnselectedTabBackgroundColor(Color color) {
        this.checkWidget();
        if (this.unselectedTabBackgroundColor == color) {
            return;
        }
        if (color == null) {
            color = this.getBackground();
        }
        this.unselectedTabBackgroundColor = color;
        if (this.selectedIndex > -1) {
            this.redraw();
        }
    }

    public int getTabTopMargin() {
        return this.tabTopMargin;
    }

    public void setTabTopMargin(int tabTopMargin) {
        this.checkWidget();
        if (this.tabTopMargin == tabTopMargin) {
            return;
        }
        this.tabTopMargin = tabTopMargin;
        this.updateItems();
        this.updateTabHeight(true);
        this.redraw();
    }

    public int getTabTopPadding() {
        return this.tabTopPadding;
    }

    public void setTabTopPadding(int tabTopPadding) {
        this.checkWidget();
        if (this.tabTopPadding == tabTopPadding) {
            return;
        }
        this.tabTopPadding = tabTopPadding;
        this.updateItems();
        this.updateTabHeight(true);
        this.redraw();
    }

    public int getTabBottomPadding() {
        return this.tabBottomPadding;
    }

    public void setTabBottomPadding(int tabBottomPadding) {
        this.checkWidget();
        if (this.tabBottomPadding == tabBottomPadding) {
            return;
        }
        this.tabBottomPadding = tabBottomPadding;
        this.updateItems();
        this.updateTabHeight(true);
        this.redraw();
    }

    public int getTabTopSelectionPadding() {
        return this.tabTopSelectionPadding;
    }

    public void setTabTopSelectionPadding(int tabTopSelectionPadding) {
        this.checkWidget();
        if (this.tabTopSelectionPadding == tabTopSelectionPadding) {
            return;
        }
        this.tabTopSelectionPadding = tabTopSelectionPadding;
        this.updateItems();
        this.updateTabHeight(true);
        this.redraw();
    }

    public int getTabLeftMargin() {
        return this.tabLeftMargin;
    }

    public void setTabLeftMargin(int tabLeftMargin) {
        this.checkWidget();
        if (this.tabLeftMargin == tabLeftMargin) {
            return;
        }
        this.tabLeftMargin = tabLeftMargin;
        this.updateItems();
        this.redraw();
    }

    public int getTabRightMargin() {
        return this.tabRightMargin;
    }

    public void setTabRightMargin(int tabRightMargin) {
        this.checkWidget();
        if (this.tabRightMargin == tabRightMargin) {
            return;
        }
        this.tabRightMargin = tabRightMargin;
        this.updateItems();
        this.redraw();
    }

    public int getTabMarginOffset() {
        return this.tabMarginOffset;
    }

    public void setTabMarginOffset(int value) {
        this.checkWidget();
        if (this.tabMarginOffset == value) {
            return;
        }
        this.tabMarginOffset = value;
        this.updateItems();
        this.redraw();
    }

    public boolean getWebbyStyle() {
        return this.webbyStyle;
    }

    public void setWebbyStyle(boolean webbyStyle) {
        this.checkWidget();
        if (this.webbyStyle != webbyStyle) {
            this.webbyStyle = webbyStyle;
            this.updateTabHeight(true);
            if (webbyStyle && this.single) {
                this.setSingle(false);
                return;
            }
            Rectangle rectBefore = this.getClientArea();
            this.updateItems();
            Rectangle rectAfter = this.getClientArea();
            this.layout();
            if (!rectBefore.equals((Object)rectAfter)) {
                this.notifyListeners(11, new Event());
            }
            this.redraw();
        }
    }

    public ETabItem getETabItem(int index) {
        return (ETabItem)this.getItem(index);
    }

    public ETabItem[] getETabItems() {
        ETabItem[] tabItems = new ETabItem[this.items.length];
        System.arraycopy(this.items, 0, tabItems, 0, this.items.length);
        return tabItems;
    }

    int getTextMidline() {
        int topSpacing = this.tabTopMargin + this.getMaxTabTopPadding();
        int textHeight = this.tabHeight - topSpacing - this.tabBottomPadding;
        return textHeight / 2 + topSpacing;
    }

    void drawBody(Event event) {
        int height;
        if (!this.useWebbyStyling()) {
            super.drawBody(event);
            return;
        }
        GC gc = event.gc;
        Point size = this.getSize();
        if (!this.minimized) {
            int width = size.x - this.borderLeft - this.borderRight - 2 * this.highlight_margin;
            int height2 = size.y - this.borderTop - this.borderBottom - this.tabHeight - this.highlight_header - this.highlight_margin;
            if (this.highlight_margin > 0) {
                int x1;
                int[] shape = null;
                if (this.onBottom) {
                    x1 = this.borderLeft;
                    int y1 = this.borderTop;
                    int x2 = size.x - this.borderRight;
                    int y2 = size.y - this.borderBottom - this.tabHeight - this.highlight_header;
                    shape = new int[]{x1, y1, x2, y1, x2, y2, x2 - this.highlight_margin, y2, x2 - this.highlight_margin, y1 + this.highlight_margin, x1 + this.highlight_margin, y1 + this.highlight_margin, x1 + this.highlight_margin, y2, x1, y2};
                } else {
                    x1 = this.borderLeft;
                    int y1 = this.borderTop + this.tabHeight + this.highlight_header;
                    int x2 = size.x - this.borderRight;
                    int y2 = size.y - this.borderBottom;
                    shape = new int[]{x1, y1, x1 + this.highlight_margin, y1, x1 + this.highlight_margin, y2 - this.highlight_margin, x2 - this.highlight_margin, y2 - this.highlight_margin, x2 - this.highlight_margin, y1, x2, y1, x2, y2, x1, y2};
                }
                if (this.selectedIndex != -1 && this.selectionGradientColors != null && this.selectionGradientColors.length > 1 && !this.selectionGradientVertical) {
                    this.drawBackground(gc, shape, true);
                } else if (this.selectedIndex == -1 && this.gradientColors != null && this.gradientColors.length > 1 && !this.gradientVertical) {
                    this.drawBackground(gc, shape, false);
                } else {
                    gc.setBackground(this.selectedIndex == -1 ? this.getBackground() : this.selectionBackground);
                    gc.fillPolygon(shape);
                }
            }
            if ((this.getStyle() & 0x40000) != 0) {
                gc.setBackground(this.getBackground());
                gc.fillRectangle(this.xClient - this.marginWidth, this.yClient - this.marginHeight, width, height2);
            }
        } else if ((this.getStyle() & 0x40000) != 0 && size.y > (height = this.borderTop + this.tabHeight + this.highlight_header + this.borderBottom)) {
            gc.setBackground(this.getParent().getBackground());
            gc.fillRectangle(0, height, size.x, size.y - height);
        }
        if (this.borderLeft > 0) {
            gc.setForeground(this.bottomBorderColor);
            int x1 = this.borderLeft - 1;
            int x2 = size.x - this.borderRight;
            int y1 = this.onBottom ? this.borderTop - 1 : this.borderTop + this.tabHeight;
            int y2 = this.onBottom ? size.y - this.tabHeight - this.borderBottom - 1 : size.y - this.borderBottom;
            gc.drawLine(x1, y1, x1, y2);
            gc.drawLine(x2, y1, x2, y2);
            gc.drawLine(x1, y2, x2, y2);
        }
    }

    void drawTabArea(Event event) {
        int[] right;
        int[] left;
        if (!this.useWebbyStyling()) {
            super.drawTabArea(event);
            return;
        }
        GC gc = event.gc;
        Point size = this.getSize();
        int[] shape = null;
        Color borderColor = this.topBorderColor;
        if (this.tabHeight == 0) {
            int style = this.getStyle();
            if ((style & 0x800000) != 0 && (style & 0x800) == 0) {
                return;
            }
            int x1 = this.borderLeft - 1;
            int x2 = size.x - this.borderRight;
            int y1 = this.borderTop + this.highlight_header;
            int y2 = this.borderTop;
            if (this.borderLeft <= 0 || this.onBottom) {
                // empty if block
            }
            shape = new int[]{x1, y1, x1, --y2, x2, y2, x2, y1};
            if (this.selectedIndex != -1 && this.selectionGradientColors != null && this.selectionGradientColors.length > 1 && !this.selectionGradientVertical) {
                this.drawBackground(gc, shape, true);
            } else if (this.selectedIndex == -1 && this.gradientColors != null && this.gradientColors.length > 1 && !this.gradientVertical) {
                this.drawBackground(gc, shape, false);
            } else {
                gc.setBackground(this.selectedIndex == -1 ? this.getBackground() : this.selectionBackground);
                gc.fillPolygon(shape);
            }
            if (this.borderLeft > 0) {
                gc.setForeground(borderColor);
                gc.drawPolyline(shape);
            }
            return;
        }
        int x = Math.max(0, this.borderLeft - 1);
        int y = this.borderTop;
        int width = size.x - this.borderLeft - this.borderRight + 1;
        int height = this.tabHeight - 1;
        if ((this.getStyle() & 0x800) != 0) {
            left = E_TOP_LEFT_CORNER;
            right = E_TOP_RIGHT_CORNER;
        } else {
            left = E_TOP_LEFT_CORNER_BORDERLESS;
            right = E_TOP_RIGHT_CORNER_BORDERLESS;
        }
        shape = new int[left.length + right.length + 4];
        int index = 0;
        shape[index++] = x;
        shape[index++] = y + height + this.highlight_header + 1;
        int i = 0;
        while (i < left.length / 2) {
            shape[index++] = x + left[2 * i];
            shape[index++] = y + left[2 * i + 1];
            ++i;
        }
        i = 0;
        while (i < right.length / 2) {
            shape[index++] = x + width + right[2 * i];
            shape[index++] = y + right[2 * i + 1];
            ++i;
        }
        shape[index++] = x + width;
        shape[index++] = y + height + this.highlight_header + 1;
        boolean bkSelected = this.single && this.selectedIndex != -1;
        this.drawBackground(gc, shape, bkSelected);
        Region r = new Region();
        r.add(new Rectangle(x, y, width + 1, height + 1));
        r.subtract(shape);
        gc.setBackground(this.getParent().getBackground());
        ETabFolder.fillRegion(gc, r);
        r.dispose();
        int i2 = 0;
        while (i2 < this.items.length) {
            if (i2 != this.selectedIndex && event.getBounds().intersects(this.items[i2].getBounds())) {
                this.items[i2].onPaint(gc, false);
            }
            ++i2;
        }
        if (this.selectedIndex != -1) {
            CTabItem item = this.items[this.selectedIndex];
            item.onPaint(gc, true);
        } else {
            int x1 = this.borderLeft;
            int y1 = this.borderTop + this.tabHeight;
            int x2 = size.x - this.borderRight;
            gc.setForeground(borderColor);
            gc.drawLine(x1, y1, x2, y1);
        }
        this.drawChevron(gc);
        this.drawMinimize(gc);
        this.drawMaximize(gc);
        if (this.borderLeft > 0) {
            RGB outside = this.getParent().getBackground().getRGB();
            this.antialias(shape, borderColor.getRGB(), null, outside, gc);
            gc.setForeground(borderColor);
            gc.drawPolyline(shape);
        }
    }

    int getMaxTabTopPadding() {
        return Math.max(this.tabTopSelectionPadding, this.tabTopPadding);
    }

    boolean updateTabHeight(boolean force) {
        if (!this.useWebbyStyling() || this.fixedTabHeight != -1 || this.items.length > 0) {
            return super.updateTabHeight(force);
        }
        int tempHeight = 0;
        GC gc = new GC((Drawable)this);
        tempHeight = gc.textExtent((String)"Default", (int)9).y + this.tabTopMargin + this.getMaxTabTopPadding() + this.tabBottomPadding;
        gc.dispose();
        this.tabHeight = tempHeight;
        this.notifyListeners(11, new Event());
        return true;
    }

    boolean setItemLocation() {
        if (!this.useWebbyStyling()) {
            return super.setItemLocation();
        }
        boolean changed = false;
        if (this.items.length == 0) {
            return false;
        }
        int y = this.borderTop;
        int rightItemEdge = this.getRightItemEdge();
        int maxWidth = rightItemEdge - this.borderLeft;
        int width = 0;
        int i = 0;
        while (i < this.priority.length) {
            CTabItem item = this.items[this.priority[i]];
            item.showing = i == 0 ? true : item.width > 0 && (width += item.width) <= maxWidth;
            ++i;
        }
        int x = this.tabMarginOffset;
        int defaultX = this.getDisplay().getBounds().width + 10;
        this.firstIndex = this.items.length - 1;
        int i2 = 0;
        while (i2 < this.items.length) {
            ETabItem item = (ETabItem)this.items[i2];
            if (!item.showing) {
                if (item.x != defaultX) {
                    changed = true;
                }
                item.x = defaultX;
            } else {
                this.firstIndex = Math.min(this.firstIndex, i2);
                if (item.x != x || item.y != y) {
                    changed = true;
                }
                item.x = x += this.tabLeftMargin;
                item.y = y;
                if (i2 == this.selectedIndex) {
                    int edge = Math.min(item.x + item.width, rightItemEdge);
                    item.closeRect.x = edge - 4 - 18;
                    item.y = item.y;
                } else {
                    item.closeRect.x = item.x + item.width - 4 - 18;
                    item.y = item.y;
                }
                item.closeRect.y = this.getTextMidline() - 9;
                x = x + item.width + this.tabRightMargin;
            }
            ++i2;
        }
        return changed;
    }

    int getSelectedTabTopOffset() {
        return this.tabTopMargin + (this.getMaxTabTopPadding() - this.tabTopSelectionPadding);
    }

    int getUnselectedTabTopOffset() {
        return this.tabTopMargin + (this.getMaxTabTopPadding() - this.tabTopPadding);
    }

    private boolean useWebbyStyling() {
        return this.webbyStyle && !this.onBottom && !this.single;
    }
}

