/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.workbench;

import junit.framework.TestCase;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.CommandManager;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.services.IContributionFactory;
import org.eclipse.e4.core.services.context.EclipseContextFactory;
import org.eclipse.e4.core.services.context.IEclipseContext;
import org.eclipse.e4.core.services.context.spi.IEclipseContextStrategy;
import org.eclipse.e4.ui.internal.services.ContextCommandService;
import org.eclipse.e4.ui.internal.services.HandlerContextFunction;
import org.eclipse.e4.ui.services.ECommandService;
import org.eclipse.e4.ui.services.EHandlerService;
import org.eclipse.e4.ui.tests.Activator;
import org.eclipse.e4.ui.tests.workbench.MWindowTest;
import org.eclipse.e4.workbench.ui.internal.UISchedulerStrategy;
import org.osgi.framework.BundleContext;

public class HandlerTest
extends TestCase {
    private static final String HELP_COMMAND_ID = "org.eclipse.ui.commands.help";
    private static final String HELP_COMMAND1_ID = "org.eclipse.ui.commands.help1";

    public void testOneCommand() throws Exception {
        IEclipseContext appContext = this.createGlobalContext();
        this.defineCommands(appContext);
        ParameterizedCommand helpCommand = this.getCommand(appContext, HELP_COMMAND_ID);
        ParameterizedCommand help1Command = this.getCommand(appContext, HELP_COMMAND1_ID);
        TestHandler handler = new TestHandler(true, HELP_COMMAND_ID);
        EHandlerService service = (EHandlerService)appContext.get(EHandlerService.class.getName());
        service.activateHandler(HELP_COMMAND_ID, (Object)handler);
        Command command = (Command)appContext.get(HELP_COMMAND_ID);
        HandlerTest.assertEquals((String)HELP_COMMAND_ID, (String)command.getId());
        HandlerTest.assertEquals((Object)HELP_COMMAND_ID, (Object)service.executeHandler(helpCommand));
        HandlerTest.assertTrue((boolean)handler.ran);
        HandlerTest.assertNull((Object)service.executeHandler(help1Command));
    }

    public void testTwoCommands() throws Exception {
        IEclipseContext appContext = this.createGlobalContext();
        this.defineCommands(appContext);
        ParameterizedCommand helpCommand = this.getCommand(appContext, HELP_COMMAND_ID);
        ParameterizedCommand help1Command = this.getCommand(appContext, HELP_COMMAND1_ID);
        EHandlerService service = (EHandlerService)appContext.get(EHandlerService.class.getName());
        TestHandler handler = new TestHandler(true, HELP_COMMAND_ID);
        service.activateHandler(HELP_COMMAND_ID, (Object)handler);
        TestHandler handler1 = new TestHandler(false, HELP_COMMAND1_ID);
        service.activateHandler(HELP_COMMAND1_ID, (Object)handler1);
        HandlerTest.assertEquals((Object)HELP_COMMAND_ID, (Object)service.executeHandler(helpCommand));
        HandlerTest.assertNull((Object)service.executeHandler(help1Command));
        HandlerTest.assertFalse((boolean)handler1.ran);
        handler1.canRun = true;
        HandlerTest.assertEquals((Object)HELP_COMMAND1_ID, (Object)service.executeHandler(help1Command));
        HandlerTest.assertTrue((boolean)handler1.ran);
    }

    public void testTwoHandlers() throws Exception {
        IEclipseContext appContext = this.createGlobalContext();
        this.defineCommands(appContext);
        ParameterizedCommand helpCommand = this.getCommand(appContext, HELP_COMMAND_ID);
        EHandlerService service = (EHandlerService)appContext.get(EHandlerService.class.getName());
        TestHandler handler = new TestHandler(true, HELP_COMMAND_ID);
        service.activateHandler(HELP_COMMAND_ID, (Object)handler);
        IEclipseContext window = this.createContext(appContext, "windowContext");
        appContext.set("activeChild", (Object)window);
        EHandlerService windowService = (EHandlerService)window.get(EHandlerService.class.getName());
        String windowRC = "org.eclipse.ui.commands.help.window";
        TestHandler windowHandler = new TestHandler(false, windowRC);
        windowService.activateHandler(HELP_COMMAND_ID, (Object)windowHandler);
        HandlerTest.assertNull((Object)service.executeHandler(helpCommand));
        HandlerTest.assertFalse((boolean)windowHandler.ran);
        HandlerTest.assertFalse((boolean)handler.ran);
        windowHandler.canRun = true;
        HandlerTest.assertEquals((Object)windowRC, (Object)service.executeHandler(helpCommand));
        HandlerTest.assertTrue((boolean)windowHandler.ran);
        HandlerTest.assertFalse((boolean)handler.ran);
    }

    private ParameterizedCommand getCommand(IEclipseContext appContext, String commandId) {
        ECommandService cs = (ECommandService)appContext.get(ECommandService.class.getName());
        Command cmd = cs.getCommand(commandId);
        return new ParameterizedCommand(cmd, null);
    }

    public void testCanExecute() throws Exception {
        IEclipseContext appContext = this.createGlobalContext();
        this.defineCommands(appContext);
        ParameterizedCommand helpCommand = this.getCommand(appContext, HELP_COMMAND_ID);
        EHandlerService service = (EHandlerService)appContext.get(EHandlerService.class.getName());
        TestHandler handler = new TestHandler(true, HELP_COMMAND_ID);
        service.activateHandler(HELP_COMMAND_ID, (Object)handler);
        IEclipseContext window = this.createContext(appContext, "windowContext");
        appContext.set("activeChild", (Object)window);
        EHandlerService windowService = (EHandlerService)window.get(EHandlerService.class.getName());
        String windowRC = "org.eclipse.ui.commands.help.window";
        TestHandler windowHandler = new TestHandler(false, windowRC);
        windowService.activateHandler(HELP_COMMAND_ID, (Object)windowHandler);
        HandlerTest.assertFalse((boolean)windowService.canExecute(helpCommand));
        windowHandler.canRun = true;
        HandlerTest.assertTrue((boolean)windowService.canExecute(helpCommand));
        windowHandler.canRun = false;
        HandlerTest.assertFalse((boolean)windowService.canExecute(helpCommand));
        windowService.deactivateHandler(HELP_COMMAND_ID, (Object)windowHandler);
        HandlerTest.assertTrue((boolean)windowService.canExecute(helpCommand));
    }

    public void testThreeContexts() throws Exception {
        IEclipseContext appContext = this.createGlobalContext();
        this.defineCommands(appContext);
        ParameterizedCommand helpCommand = this.getCommand(appContext, HELP_COMMAND_ID);
        EHandlerService service = (EHandlerService)appContext.get(EHandlerService.class.getName());
        TestHandler handler = new TestHandler(true, HELP_COMMAND_ID);
        service.activateHandler(HELP_COMMAND_ID, (Object)handler);
        IEclipseContext window = this.createContext(appContext, "windowContext");
        appContext.set("activeChild", (Object)window);
        EHandlerService windowService = (EHandlerService)window.get(EHandlerService.class.getName());
        String windowRC = "org.eclipse.ui.commands.help.window";
        TestHandler windowHandler = new TestHandler(true, windowRC);
        windowService.activateHandler(HELP_COMMAND_ID, (Object)windowHandler);
        HandlerTest.assertEquals((Object)windowRC, (Object)service.executeHandler(helpCommand));
        IEclipseContext dialog = this.createContext(appContext, "dialogContext");
        appContext.set("activeChild", (Object)dialog);
        HandlerTest.assertEquals((Object)HELP_COMMAND_ID, (Object)service.executeHandler(helpCommand));
        appContext.set("activeChild", (Object)window);
        HandlerTest.assertEquals((Object)windowRC, (Object)service.executeHandler(helpCommand));
    }

    public void testDifferentExecutionContexts() throws Exception {
        IEclipseContext appContext = this.createGlobalContext();
        this.defineCommands(appContext);
        ParameterizedCommand helpCommand = this.getCommand(appContext, HELP_COMMAND_ID);
        EHandlerService service = (EHandlerService)appContext.get(EHandlerService.class.getName());
        TestHandler handler = new TestHandler(true, HELP_COMMAND_ID);
        service.activateHandler(HELP_COMMAND_ID, (Object)handler);
        IEclipseContext window = this.createContext(appContext, "windowContext");
        appContext.set("activeChild", (Object)window);
        EHandlerService windowService = (EHandlerService)window.get(EHandlerService.class.getName());
        String windowRC = "org.eclipse.ui.commands.help.window";
        TestHandler windowHandler = new TestHandler(true, windowRC);
        windowService.activateHandler(HELP_COMMAND_ID, (Object)windowHandler);
        HandlerTest.assertEquals((Object)windowRC, (Object)service.executeHandler(helpCommand));
        HandlerTest.assertEquals((Object)windowRC, (Object)windowService.executeHandler(helpCommand));
        IEclipseContext dialog = this.createContext(appContext, "dialogContext");
        EHandlerService dialogService = (EHandlerService)dialog.get(EHandlerService.class.getName());
        HandlerTest.assertEquals((Object)HELP_COMMAND_ID, (Object)dialogService.executeHandler(helpCommand));
    }

    private void defineCommands(IEclipseContext appContext) {
        ECommandService cmdService = (ECommandService)appContext.get(ECommandService.class.getName());
        Category category = cmdService.getCategory("cat.org.eclipse.ui.commands.help");
        category.define("Help Category", null);
        Command command = cmdService.getCommand(HELP_COMMAND_ID);
        command.define("Help Command", null, category);
        command = cmdService.getCommand(HELP_COMMAND1_ID);
        command.define("Help 1 Command", null, category);
    }

    private IEclipseContext createGlobalContext() {
        IEclipseContext serviceContext = EclipseContextFactory.createServiceContext((BundleContext)Activator.getDefault().getBundle().getBundleContext());
        IEclipseContext appContext = this.createContext(serviceContext, "globalContext");
        appContext.set(IContributionFactory.class.getName(), (Object)MWindowTest.getCFactory());
        appContext.set(CommandManager.class.getName(), (Object)new CommandManager());
        appContext.set(ECommandService.class.getName(), (Object)new ContextCommandService(appContext));
        appContext.set(EHandlerService.class.getName(), (Object)new HandlerContextFunction());
        return appContext;
    }

    private IEclipseContext createContext(IEclipseContext parentContext, String level) {
        IEclipseContext appContext = EclipseContextFactory.create((IEclipseContext)parentContext, (IEclipseContextStrategy)UISchedulerStrategy.getInstance());
        appContext.set("debugString", (Object)level);
        return appContext;
    }

    public static class TestHandler {
        boolean ran = false;
        boolean canRun;
        String rc;

        public TestHandler(boolean c, String ret) {
            this.canRun = c;
            this.rc = ret;
        }

        public boolean canExecute() {
            return this.canRun;
        }

        public Object execute() {
            this.ran = true;
            return this.rc;
        }
    }
}

