/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.workbench;

import junit.framework.TestCase;
import org.eclipse.core.commands.contexts.Context;
import org.eclipse.core.commands.contexts.ContextManager;
import org.eclipse.e4.core.services.IContributionFactory;
import org.eclipse.e4.core.services.context.EclipseContextFactory;
import org.eclipse.e4.core.services.context.IEclipseContext;
import org.eclipse.e4.core.services.context.spi.IEclipseContextStrategy;
import org.eclipse.e4.ui.internal.services.ActiveContextsFunction;
import org.eclipse.e4.ui.internal.services.ContextContextFunction;
import org.eclipse.e4.ui.services.EContextService;
import org.eclipse.e4.ui.tests.Activator;
import org.eclipse.e4.ui.tests.workbench.MWindowTest;
import org.eclipse.e4.workbench.ui.internal.UISchedulerStrategy;
import org.osgi.framework.BundleContext;

public class ContextTest
extends TestCase {
    private static final String WINDOW_ID = "org.eclipse.ui.contexts.window";
    private static final String DIALOG_ID = "org.eclipse.ui.contexts.dialog";
    private static final String DIALOG_AND_WINDOW_ID = "org.eclipse.ui.contexts.dialogAndWindow";

    public void testOneContext() throws Exception {
        IEclipseContext appContext = this.createGlobalContext();
        this.defineContexts(appContext);
        EContextService cs = (EContextService)appContext.get(EContextService.class.getName());
        ContextTest.assertEquals((int)0, (int)cs.getActiveContextIds().size());
        cs.activateContext(DIALOG_AND_WINDOW_ID);
        ContextTest.assertEquals((int)1, (int)cs.getActiveContextIds().size());
    }

    public void testTwoContexts() throws Exception {
        IEclipseContext appContext = this.createGlobalContext();
        this.defineContexts(appContext);
        EContextService cs = (EContextService)appContext.get(EContextService.class.getName());
        ContextTest.assertEquals((int)0, (int)cs.getActiveContextIds().size());
        IEclipseContext window = this.createContext(appContext, "windowContext");
        appContext.set("activeChild", (Object)window);
        EContextService windowService = (EContextService)window.get(EContextService.class.getName());
        cs.activateContext(DIALOG_AND_WINDOW_ID);
        ContextTest.assertEquals((int)1, (int)cs.getActiveContextIds().size());
        ContextTest.assertEquals((int)1, (int)windowService.getActiveContextIds().size());
        cs.deactivateContext(DIALOG_AND_WINDOW_ID);
        ContextTest.assertEquals((int)0, (int)windowService.getActiveContextIds().size());
        ContextTest.assertEquals((int)0, (int)cs.getActiveContextIds().size());
    }

    public void testTwoContextsBottom() throws Exception {
        IEclipseContext appContext = this.createGlobalContext();
        this.defineContexts(appContext);
        EContextService cs = (EContextService)appContext.get(EContextService.class.getName());
        ContextTest.assertEquals((int)0, (int)cs.getActiveContextIds().size());
        IEclipseContext window = this.createContext(appContext, "windowContext");
        appContext.set("activeChild", (Object)window);
        EContextService windowService = (EContextService)window.get(EContextService.class.getName());
        windowService.activateContext(DIALOG_AND_WINDOW_ID);
        ContextTest.assertEquals((int)1, (int)cs.getActiveContextIds().size());
        ContextTest.assertEquals((int)1, (int)windowService.getActiveContextIds().size());
        windowService.deactivateContext(DIALOG_AND_WINDOW_ID);
        ContextTest.assertEquals((int)0, (int)windowService.getActiveContextIds().size());
        ContextTest.assertEquals((int)0, (int)cs.getActiveContextIds().size());
        cs.activateContext(DIALOG_AND_WINDOW_ID);
        ContextTest.assertEquals((int)1, (int)cs.getActiveContextIds().size());
        ContextTest.assertEquals((int)1, (int)windowService.getActiveContextIds().size());
        cs.deactivateContext(DIALOG_AND_WINDOW_ID);
        ContextTest.assertEquals((int)0, (int)windowService.getActiveContextIds().size());
        ContextTest.assertEquals((int)0, (int)cs.getActiveContextIds().size());
    }

    public void testThreeContexts() throws Exception {
        IEclipseContext appContext = this.createGlobalContext();
        this.defineContexts(appContext);
        EContextService cs = (EContextService)appContext.get(EContextService.class.getName());
        IEclipseContext window = this.createContext(appContext, "windowContext");
        EContextService windowService = (EContextService)window.get(EContextService.class.getName());
        IEclipseContext dialog = this.createContext(appContext, "dialogContext");
        appContext.set("activeChild", (Object)dialog);
        EContextService dialogService = (EContextService)dialog.get(EContextService.class.getName());
        cs.activateContext(DIALOG_AND_WINDOW_ID);
        windowService.activateContext(WINDOW_ID);
        ContextTest.assertEquals((int)1, (int)cs.getActiveContextIds().size());
        ContextTest.assertEquals((int)1, (int)dialogService.getActiveContextIds().size());
        ContextTest.assertEquals((int)2, (int)windowService.getActiveContextIds().size());
        dialogService.activateContext(DIALOG_ID);
        ContextTest.assertEquals((int)2, (int)cs.getActiveContextIds().size());
        ContextTest.assertEquals((int)2, (int)dialogService.getActiveContextIds().size());
        ContextTest.assertEquals((int)2, (int)windowService.getActiveContextIds().size());
        ContextTest.assertTrue((boolean)cs.getActiveContextIds().contains(DIALOG_AND_WINDOW_ID));
        ContextTest.assertTrue((boolean)cs.getActiveContextIds().contains(DIALOG_ID));
        ContextTest.assertFalse((boolean)cs.getActiveContextIds().contains(WINDOW_ID));
        ContextTest.assertTrue((boolean)dialogService.getActiveContextIds().contains(DIALOG_AND_WINDOW_ID));
        ContextTest.assertTrue((boolean)dialogService.getActiveContextIds().contains(DIALOG_ID));
        ContextTest.assertFalse((boolean)dialogService.getActiveContextIds().contains(WINDOW_ID));
        ContextTest.assertTrue((boolean)windowService.getActiveContextIds().contains(DIALOG_AND_WINDOW_ID));
        ContextTest.assertFalse((boolean)windowService.getActiveContextIds().contains(DIALOG_ID));
        ContextTest.assertTrue((boolean)windowService.getActiveContextIds().contains(WINDOW_ID));
        appContext.set("activeChild", (Object)window);
        ContextTest.assertEquals((int)2, (int)cs.getActiveContextIds().size());
        ContextTest.assertEquals((int)2, (int)dialogService.getActiveContextIds().size());
        ContextTest.assertEquals((int)2, (int)windowService.getActiveContextIds().size());
        ContextTest.assertTrue((boolean)cs.getActiveContextIds().contains(DIALOG_AND_WINDOW_ID));
        ContextTest.assertFalse((boolean)cs.getActiveContextIds().contains(DIALOG_ID));
        ContextTest.assertTrue((boolean)cs.getActiveContextIds().contains(WINDOW_ID));
        ContextTest.assertTrue((boolean)dialogService.getActiveContextIds().contains(DIALOG_AND_WINDOW_ID));
        ContextTest.assertTrue((boolean)dialogService.getActiveContextIds().contains(DIALOG_ID));
        ContextTest.assertFalse((boolean)dialogService.getActiveContextIds().contains(WINDOW_ID));
        ContextTest.assertTrue((boolean)windowService.getActiveContextIds().contains(DIALOG_AND_WINDOW_ID));
        ContextTest.assertFalse((boolean)windowService.getActiveContextIds().contains(DIALOG_ID));
        ContextTest.assertTrue((boolean)windowService.getActiveContextIds().contains(WINDOW_ID));
    }

    private void defineContexts(IEclipseContext appContext) {
        EContextService cs = (EContextService)appContext.get(EContextService.class.getName());
        Context daw = cs.getContext(DIALOG_AND_WINDOW_ID);
        daw.define("Dialog and Window", null, null);
        Context d = cs.getContext(DIALOG_ID);
        d.define("Dialog", null, DIALOG_AND_WINDOW_ID);
        Context w = cs.getContext(WINDOW_ID);
        w.define("Window", null, DIALOG_AND_WINDOW_ID);
    }

    private IEclipseContext createGlobalContext() {
        IEclipseContext serviceContext = EclipseContextFactory.createServiceContext((BundleContext)Activator.getDefault().getBundle().getBundleContext());
        IEclipseContext appContext = this.createContext(serviceContext, "globalContext");
        appContext.set("globalContext", (Object)appContext);
        appContext.set(IContributionFactory.class.getName(), (Object)MWindowTest.getCFactory());
        appContext.set(ContextManager.class.getName(), (Object)new ContextManager());
        appContext.set(EContextService.class.getName(), (Object)new ContextContextFunction());
        appContext.set("activeContexts", (Object)new ActiveContextsFunction());
        return appContext;
    }

    private IEclipseContext createContext(IEclipseContext parentContext, String level) {
        IEclipseContext appContext = EclipseContextFactory.create((IEclipseContext)parentContext, (IEclipseContextStrategy)UISchedulerStrategy.getInstance());
        appContext.set("debugString", (Object)level);
        return appContext;
    }
}

