/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.swt;

import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.tests.css.swt.CSSSWTTestCase;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class LabelTest
extends CSSSWTTestCase {
    static final RGB RED = new RGB(255, 0, 0);
    static final RGB GREEN = new RGB(0, 255, 0);
    static final RGB BLUE = new RGB(0, 0, 255);
    CSSEngine engine;

    protected Label createTestLabel(String styleSheet) {
        Display display = Display.getDefault();
        this.engine = this.createEngine(styleSheet, display);
        Shell shell = new Shell(display, 1264);
        FillLayout layout = new FillLayout();
        shell.setLayout((Layout)layout);
        Composite panel = new Composite((Composite)shell, 0);
        panel.setLayout((Layout)new FillLayout());
        Label labelToTest = new Label(panel, 0);
        labelToTest.setText("Some label text");
        this.engine.applyStyles((Object)labelToTest, true);
        shell.pack();
        return labelToTest;
    }

    public void testColor() throws Exception {
        Label labelToTest = this.createTestLabel("Label { background-color: #FF0000; color: #0000FF }");
        LabelTest.assertEquals((Object)RED, (Object)labelToTest.getBackground().getRGB());
        LabelTest.assertEquals((Object)BLUE, (Object)labelToTest.getForeground().getRGB());
    }

    public void testFontRegular() throws Exception {
        Label labelToTest = this.createTestLabel("Label { font: Verdana 16px }");
        LabelTest.assertEquals((int)1, (int)labelToTest.getFont().getFontData().length);
        FontData fontData = labelToTest.getFont().getFontData()[0];
        LabelTest.assertEquals((String)"Verdana", (String)fontData.getName());
        LabelTest.assertEquals((int)16, (int)fontData.getHeight());
        LabelTest.assertEquals((int)0, (int)fontData.getStyle());
    }

    public void testFontBold() throws Exception {
        Label labelToTest = this.createTestLabel("Label { font: Arial 12px; font-weight: bold }");
        LabelTest.assertEquals((int)1, (int)labelToTest.getFont().getFontData().length);
        FontData fontData = labelToTest.getFont().getFontData()[0];
        LabelTest.assertEquals((String)"Arial", (String)fontData.getName());
        LabelTest.assertEquals((int)12, (int)fontData.getHeight());
        LabelTest.assertEquals((int)1, (int)fontData.getStyle());
    }

    public void testFontItalic() throws Exception {
        Label labelToTest = this.createTestLabel("Label { font-style: italic }");
        LabelTest.assertEquals((int)1, (int)labelToTest.getFont().getFontData().length);
        FontData fontData = labelToTest.getFont().getFontData()[0];
        LabelTest.assertEquals((int)2, (int)fontData.getStyle());
    }

    public void testAlignment() throws Exception {
        Label labelToTest = this.createTestLabel("Label { alignment: right }");
        LabelTest.assertEquals((int)131072, (int)labelToTest.getAlignment());
        labelToTest = this.createTestLabel("Label { alignment: center; }");
        LabelTest.assertEquals((int)0x1000000, (int)labelToTest.getAlignment());
        labelToTest = this.createTestLabel("Label { alignment: left; }");
        LabelTest.assertEquals((int)16384, (int)labelToTest.getAlignment());
    }

    public void testAlignment2() throws Exception {
        Label labelToTest = this.createTestLabel("Label { alignment: trail }");
        LabelTest.assertEquals((int)131072, (int)labelToTest.getAlignment());
        labelToTest = this.createTestLabel("Label { alignment: lead; }");
        LabelTest.assertEquals((int)16384, (int)labelToTest.getAlignment());
    }
}

