/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.swt;

import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.dom.SWTElement;
import org.eclipse.e4.ui.tests.css.swt.CSSSWTTestCase;
import org.eclipse.e4.ui.widgets.ETabFolder;
import org.eclipse.e4.ui.widgets.ETabItem;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Widget;

public class ETabFolderTest
extends CSSSWTTestCase {
    static final RGB RED = new RGB(255, 0, 0);
    static final RGB GREEN = new RGB(0, 255, 0);
    static final RGB BLUE = new RGB(0, 0, 255);
    static final RGB WHITE = new RGB(255, 255, 255);
    public static CSSEngine engine;

    protected ETabFolder createTestETabFolder(String styleSheet) {
        Display display = Display.getDefault();
        engine = this.createEngine(styleSheet, display);
        Shell shell = new Shell(display, 1264);
        FillLayout layout = new FillLayout();
        shell.setLayout((Layout)layout);
        Composite panel = new Composite((Composite)shell, 0);
        panel.setLayout((Layout)new FillLayout());
        ETabFolder folderToTest = new ETabFolder(panel, 0);
        ETabItem tab1 = new ETabItem(folderToTest, 0);
        tab1.setText("A TAB ITEM");
        engine.applyStyles((Object)shell, true);
        shell.pack();
        return folderToTest;
    }

    protected ToolBar[] createTestToolBars(String styleSheet) {
        Display display = Display.getDefault();
        engine = this.createEngine(styleSheet, display);
        Shell shell = new Shell(display, 1264);
        FillLayout layout = new FillLayout();
        shell.setLayout((Layout)layout);
        Composite panel = new Composite((Composite)shell, 0);
        panel.setLayout((Layout)new FillLayout());
        ETabFolder folderA = new ETabFolder(panel, 0);
        ETabItem tabA = new ETabItem(folderA, 0);
        tabA.setText("FolderA TAB ITEM");
        ToolBar toolbarA = new ToolBar((Composite)folderA, 0x800100);
        folderA.setTopRight((Control)toolbarA);
        ETabFolder folderB = new ETabFolder(panel, 0);
        ETabItem tabB = new ETabItem(folderB, 0);
        tabB.setText("FolderB TAB ITEM");
        ToolBar toolbarB = new ToolBar((Composite)folderB, 0x800100);
        folderB.setTopRight((Control)toolbarB);
        ToolBar toolbarC = new ToolBar(panel, 0x800100);
        engine.applyStyles((Object)shell, true);
        return new ToolBar[]{toolbarA, toolbarB, toolbarC};
    }

    protected Shell createShell(String styleSheet) {
        Display display = Display.getDefault();
        engine = this.createEngine(styleSheet, display);
        Shell shell = new Shell(display, 0);
        engine.applyStyles((Object)shell, true);
        shell.pack();
        return shell;
    }

    public void testBackgroundColor() throws Exception {
        ETabFolder folderToTest = this.createTestETabFolder("ETabFolder { background-color: #0000FF }");
        ETabFolderTest.assertEquals((Object)BLUE, (Object)folderToTest.getBackground().getRGB());
    }

    public void testTextColor() throws Exception {
        ETabFolder folderToTest = this.createTestETabFolder("ETabFolder { color: #0000FF }");
        ETabFolderTest.assertEquals((Object)BLUE, (Object)folderToTest.getForeground().getRGB());
    }

    public void testFontRegular() throws Exception {
        ETabFolder folderToTest = this.createTestETabFolder("ETabFolder { font: Verdana 16px }");
        ETabFolderTest.assertEquals((int)1, (int)folderToTest.getFont().getFontData().length);
        FontData fontData = folderToTest.getFont().getFontData()[0];
        ETabFolderTest.assertEquals((String)"Verdana", (String)fontData.getName());
        ETabFolderTest.assertEquals((int)16, (int)fontData.getHeight());
        ETabFolderTest.assertEquals((int)0, (int)fontData.getStyle());
    }

    public void testFontBold() throws Exception {
        ETabFolder folderToTest = this.createTestETabFolder("ETabFolder { font: Arial 12px; font-weight: bold }");
        ETabFolderTest.assertEquals((int)1, (int)folderToTest.getFont().getFontData().length);
        FontData fontData = folderToTest.getFont().getFontData()[0];
        ETabFolderTest.assertEquals((String)"Arial", (String)fontData.getName());
        ETabFolderTest.assertEquals((int)12, (int)fontData.getHeight());
        ETabFolderTest.assertEquals((int)1, (int)fontData.getStyle());
    }

    public void testFontItalic() throws Exception {
        ETabFolder folderToTest = this.createTestETabFolder("ETabFolder { font: Arial 12px; font-style: italic }");
        ETabFolderTest.assertEquals((int)1, (int)folderToTest.getFont().getFontData().length);
        FontData fontData = folderToTest.getFont().getFontData()[0];
        ETabFolderTest.assertEquals((String)"Arial", (String)fontData.getName());
        ETabFolderTest.assertEquals((int)12, (int)fontData.getHeight());
        ETabFolderTest.assertEquals((int)2, (int)fontData.getStyle());
    }

    public void testBorderVisible() throws Exception {
        ETabFolder folderToTest = this.createTestETabFolder("ETabFolder { border-visible: true}");
        ETabFolderTest.assertEquals((boolean)true, (boolean)folderToTest.getBorderVisible());
        ETabFolderTest.assertEquals((String)"true", (String)engine.retrieveCSSProperty((Object)folderToTest, "border-visible", null));
        folderToTest.getShell().close();
        folderToTest = this.createTestETabFolder("ETabFolder { border-visible: false}");
        ETabFolderTest.assertEquals((boolean)false, (boolean)folderToTest.getBorderVisible());
        ETabFolderTest.assertEquals((String)"false", (String)engine.retrieveCSSProperty((Object)folderToTest, "border-visible", null));
    }

    public void testSimple() throws Exception {
        ETabFolder folderToTest = this.createTestETabFolder("ETabFolder { simple: true}");
        ETabFolderTest.assertEquals((boolean)true, (boolean)folderToTest.getSimple());
        ETabFolderTest.assertEquals((String)"true", (String)engine.retrieveCSSProperty((Object)folderToTest, "simple", null));
        folderToTest.getShell().close();
        folderToTest = this.createTestETabFolder("ETabFolder { simple: false}");
        ETabFolderTest.assertEquals((boolean)false, (boolean)folderToTest.getSimple());
        ETabFolderTest.assertEquals((String)"false", (String)engine.retrieveCSSProperty((Object)folderToTest, "simple", null));
    }

    public void testMaximizeVisible() throws Exception {
        ETabFolder folderToTest = this.createTestETabFolder("ETabFolder { maximize-visible: true}");
        ETabFolderTest.assertEquals((boolean)true, (boolean)folderToTest.getMaximizeVisible());
        ETabFolderTest.assertEquals((String)"true", (String)engine.retrieveCSSProperty((Object)folderToTest, "maximize-visible", null));
        folderToTest.getShell().close();
        folderToTest = this.createTestETabFolder("ETabFolder { maximize-visible: false}");
        ETabFolderTest.assertEquals((boolean)false, (boolean)folderToTest.getMaximizeVisible());
        ETabFolderTest.assertEquals((String)"false", (String)engine.retrieveCSSProperty((Object)folderToTest, "maximize-visible", null));
    }

    public void testMinimizeVisible() throws Exception {
        ETabFolder folderToTest = this.createTestETabFolder("ETabFolder { minimize-visible: true}");
        ETabFolderTest.assertEquals((boolean)true, (boolean)folderToTest.getMinimizeVisible());
        ETabFolderTest.assertEquals((String)"true", (String)engine.retrieveCSSProperty((Object)folderToTest, "minimize-visible", null));
        folderToTest.getShell().close();
        folderToTest = this.createTestETabFolder("ETabFolder { minimize-visible: false}");
        ETabFolderTest.assertEquals((boolean)false, (boolean)folderToTest.getMinimizeVisible());
        ETabFolderTest.assertEquals((String)"false", (String)engine.retrieveCSSProperty((Object)folderToTest, "minimize-visible", null));
    }

    public void testMRUVisible() throws Exception {
        ETabFolder folderToTest = this.createTestETabFolder("ETabFolder { mru-visible: true}");
        ETabFolderTest.assertEquals((boolean)true, (boolean)folderToTest.getMRUVisible());
        ETabFolderTest.assertEquals((String)"true", (String)engine.retrieveCSSProperty((Object)folderToTest, "mru-visible", null));
        folderToTest.getShell().close();
        folderToTest = this.createTestETabFolder("ETabFolder { mru-visible: false}");
        ETabFolderTest.assertEquals((String)"false", (String)engine.retrieveCSSProperty((Object)folderToTest, "mru-visible", null));
        ETabFolderTest.assertEquals((boolean)false, (boolean)folderToTest.getMRUVisible());
    }

    public void testMaximized() throws Exception {
        ETabFolder folderToTest = this.createTestETabFolder("ETabFolder { maximized: true}");
        ETabFolderTest.assertEquals((boolean)true, (boolean)folderToTest.getMaximized());
        ETabFolderTest.assertEquals((String)"true", (String)engine.retrieveCSSProperty((Object)folderToTest, "maximized", null));
        folderToTest = this.createTestETabFolder("ETabFolder { maximized: false}");
        ETabFolderTest.assertEquals((boolean)false, (boolean)folderToTest.getMaximized());
        ETabFolderTest.assertEquals((String)"false", (String)engine.retrieveCSSProperty((Object)folderToTest, "maximized", null));
    }

    public void testMinimized() throws Exception {
        ETabFolder folderToTest = this.createTestETabFolder("ETabFolder { minimized: true}");
        ETabFolderTest.assertEquals((boolean)true, (boolean)folderToTest.getMinimized());
        ETabFolderTest.assertEquals((String)"true", (String)engine.retrieveCSSProperty((Object)folderToTest, "minimized", null));
        folderToTest = this.createTestETabFolder("ETabFolder { minimized: false}");
        ETabFolderTest.assertEquals((boolean)false, (boolean)folderToTest.getMinimized());
        ETabFolderTest.assertEquals((String)"false", (String)engine.retrieveCSSProperty((Object)folderToTest, "minimized", null));
    }

    public void testTabHeight() throws Exception {
        ETabFolder folderToTest = this.createTestETabFolder("ETabFolder { tab-height: 30px }");
        ETabFolderTest.assertEquals((int)30, (int)folderToTest.getTabHeight());
        folderToTest = this.createTestETabFolder("ETabFolder { tab-height: 40px }");
        ETabFolderTest.assertEquals((int)40, (int)folderToTest.getTabHeight());
        folderToTest = this.createTestETabFolder("ETabFolder { tab-height: 40px 50px }");
        ETabFolderTest.assertNotSame((Object)40, (Object)folderToTest.getTabHeight());
        ETabFolderTest.assertNotSame((Object)50, (Object)folderToTest.getTabHeight());
        folderToTest = this.createTestETabFolder("ETabFolder { tab-height: 40 }");
        ETabFolderTest.assertNotSame((Object)40, (Object)folderToTest.getTabHeight());
    }

    public void testSingle() throws Exception {
        ETabFolder folderToTest = this.createTestETabFolder("ETabFolder { single: true}");
        ETabFolderTest.assertEquals((boolean)true, (boolean)folderToTest.getSingle());
        ETabFolderTest.assertEquals((String)"true", (String)engine.retrieveCSSProperty((Object)folderToTest, "single", null));
        folderToTest = this.createTestETabFolder("ETabFolder { single: false}");
        ETabFolderTest.assertEquals((boolean)false, (boolean)folderToTest.getSingle());
        ETabFolderTest.assertEquals((String)"false", (String)engine.retrieveCSSProperty((Object)folderToTest, "single", null));
    }

    public void testUnselectedCloseVisible() throws Exception {
        ETabFolder folderToTest = this.createTestETabFolder("ETabFolder { unselected-close-visible: true}");
        ETabFolderTest.assertEquals((boolean)true, (boolean)folderToTest.getUnselectedCloseVisible());
        ETabFolderTest.assertEquals((String)"true", (String)engine.retrieveCSSProperty((Object)folderToTest, "unselected-close-visible", null));
        folderToTest = this.createTestETabFolder("ETabFolder { unselected-close-visible: false}");
        ETabFolderTest.assertEquals((boolean)false, (boolean)folderToTest.getUnselectedCloseVisible());
        ETabFolderTest.assertEquals((String)"false", (String)engine.retrieveCSSProperty((Object)folderToTest, "unselected-close-visible", null));
    }

    public void testUnselectedImageVisible() throws Exception {
        ETabFolder folderToTest = this.createTestETabFolder("ETabFolder { unselected-image-visible: true}");
        ETabFolderTest.assertEquals((boolean)true, (boolean)folderToTest.getUnselectedImageVisible());
        ETabFolderTest.assertEquals((String)"true", (String)engine.retrieveCSSProperty((Object)folderToTest, "unselected-image-visible", null));
        folderToTest = this.createTestETabFolder("ETabFolder { unselected-image-visible: false}");
        ETabFolderTest.assertEquals((boolean)false, (boolean)folderToTest.getUnselectedImageVisible());
        ETabFolderTest.assertEquals((String)"false", (String)engine.retrieveCSSProperty((Object)folderToTest, "unselected-image-visible", null));
    }

    public void testRetrievePropertyNull() {
        Shell shell = this.createShell("Shell {color:red}");
        ETabFolderTest.assertEquals(null, (String)engine.retrieveCSSProperty((Object)shell, "border-visible", null));
        ETabFolderTest.assertEquals(null, (String)engine.retrieveCSSProperty((Object)shell, "maximized", null));
        ETabFolderTest.assertEquals(null, (String)engine.retrieveCSSProperty((Object)shell, "maximize-visible", null));
        ETabFolderTest.assertEquals(null, (String)engine.retrieveCSSProperty((Object)shell, "minimize-visible", null));
        ETabFolderTest.assertEquals(null, (String)engine.retrieveCSSProperty((Object)shell, "mru-visible", null));
        ETabFolderTest.assertEquals(null, (String)engine.retrieveCSSProperty((Object)shell, "show-close", null));
        ETabFolderTest.assertEquals(null, (String)engine.retrieveCSSProperty((Object)shell, "simple", null));
        ETabFolderTest.assertEquals(null, (String)engine.retrieveCSSProperty((Object)shell, "single", null));
        ETabFolderTest.assertEquals(null, (String)engine.retrieveCSSProperty((Object)shell, "unselected-close-visible", null));
        ETabFolderTest.assertEquals(null, (String)engine.retrieveCSSProperty((Object)shell, "unselected-image-visible", null));
    }

    public void testTopRightAsDescendentChild() throws Exception {
        ToolBar[] toolBars = this.createTestToolBars("ETabFolder.special ToolBar { background: #FF0000}\nETabFolder ToolBar { background: #00FF00}\nETabFolder.extraordinary ToolBar { background: #FFFFFF}\nToolBar { background: #0000FF}");
        ToolBar barA = toolBars[0];
        ToolBar barB = toolBars[1];
        ToolBar barC = toolBars[2];
        SWTElement.setCSSClass((Widget)barA.getParent(), (String)"special");
        engine.applyStyles((Object)barA.getShell(), true);
        ETabFolderTest.assertEquals((Object)RED, (Object)barA.getBackground().getRGB());
        ETabFolderTest.assertEquals((Object)GREEN, (Object)barB.getBackground().getRGB());
        ETabFolderTest.assertEquals((Object)BLUE, (Object)barC.getBackground().getRGB());
        SWTElement.setCSSClass((Widget)barA.getParent(), (String)"extraordinary");
        engine.applyStyles((Object)barA.getShell(), true);
        ETabFolderTest.assertEquals((Object)WHITE, (Object)barA.getBackground().getRGB());
    }
}

