/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.properties.css2;

import org.eclipse.e4.ui.css.core.dom.properties.CSSBorderProperties;
import org.eclipse.e4.ui.css.core.dom.properties.ICSSPropertyHandler2;
import org.eclipse.e4.ui.css.core.dom.properties.css2.AbstractCSSPropertyBorderHandler;
import org.eclipse.e4.ui.css.core.dom.properties.css2.ICSSPropertyBorderHandler;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.core.impl.dom.properties.CSSBorderPropertiesImpl;
import org.eclipse.e4.ui.css.swt.helpers.CSSSWTHelpers;
import org.eclipse.e4.ui.css.swt.helpers.SWTElementHelpers;
import org.eclipse.e4.ui.widgets.ETabFolder;
import org.eclipse.e4.ui.widgets.ETabItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;

public class CSSPropertyBorderSWTHandler
extends AbstractCSSPropertyBorderHandler
implements ICSSPropertyHandler2 {
    public static final ICSSPropertyBorderHandler INSTANCE = new CSSPropertyBorderSWTHandler();

    public boolean applyCSSProperty(Object element, String property, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        Widget widget = SWTElementHelpers.getWidget(element);
        if (widget instanceof ETabItem && this.applyCSSPropertyBorder((ETabItem)widget, property, value, pseudo, engine)) {
            return true;
        }
        if (widget instanceof ETabFolder && this.applyCSSPropertyBorder((ETabFolder)widget, property, value, pseudo, engine)) {
            return true;
        }
        Control control = SWTElementHelpers.getControl(element);
        if (control != null) {
            Composite parent = control.getParent();
            if (parent == null) {
                return true;
            }
            CSSBorderProperties border = (CSSBorderProperties)control.getData("org.eclipse.e4.ui.core.css.swt.CONTROL_CSS2BORDER_KEY");
            if (border == null) {
                border = new CSSBorderPropertiesImpl();
                control.setData("org.eclipse.e4.ui.core.css.swt.CONTROL_CSS2BORDER_KEY", (Object)border);
                parent.addPaintListener(CSSSWTHelpers.createBorderPaintListener(engine, control));
            }
            super.applyCSSProperty((Object)border, property, value, pseudo, engine);
            if (parent.getData("CSS_SUPPORTS_BORDERS") != null && value.getCssValueType() == 1) {
                int pixelValue = (int)((CSSPrimitiveValue)value).getFloatValue((short)9);
                if (property.equals("border-width")) {
                    ((FillLayout)parent.getLayout()).marginWidth = pixelValue;
                    ((FillLayout)parent.getLayout()).marginHeight = pixelValue;
                }
            }
            return true;
        }
        if (element instanceof CSSBorderProperties) {
            super.applyCSSProperty(element, property, value, pseudo, engine);
            return true;
        }
        return false;
    }

    private boolean applyCSSPropertyBorder(ETabItem item, String property, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        Color newColor = (Color)engine.convert(value, Color.class, (Object)item.getDisplay());
        ETabFolder folder = item.getETabParent();
        if ("border-color".equals(property)) {
            folder.setTabBorderColor(newColor);
            return true;
        }
        return false;
    }

    private boolean applyCSSPropertyBorder(ETabFolder folder, String property, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        Color newColor = (Color)engine.convert(value, Color.class, (Object)folder.getDisplay());
        if ("border-color".equals(property)) {
            folder.setTopBorderColor(newColor);
            folder.setBottomBorderColor(newColor);
            return true;
        }
        if ("border-top-color".equals(property)) {
            folder.setTopBorderColor(newColor);
            return true;
        }
        if ("border-bottom-color".equals(property)) {
            folder.setBottomBorderColor(newColor);
            return true;
        }
        return false;
    }

    public void onAllCSSPropertiesApplyed(Object element, CSSEngine engine) throws Exception {
        Composite parent;
        Control control = SWTElementHelpers.getControl(element);
        if (control != null && (parent = control.getParent()) != null) {
            parent.redraw();
        }
    }
}

