/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tm.layouts.util;

import java.util.Map;
import org.eclipse.e4.tm.layouts.Layout;
import org.eclipse.e4.tm.layouts.LayoutData;
import org.eclipse.e4.tm.layouts.LayoutsPackage;
import org.eclipse.e4.tm.widgets.AbstractComposite;
import org.eclipse.e4.tm.widgets.Control;
import org.eclipse.e4.tm.widgets.WidgetsPackage;
import org.eclipse.e4.tm.widgets.util.WidgetsValidator;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutsValidator
extends EObjectValidator {
    public static final LayoutsValidator INSTANCE = new LayoutsValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.eclipse.e4.tm.layouts";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;

    protected EPackage getEPackage() {
        return LayoutsPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateLayoutData((LayoutData)value, diagnostics, context);
            }
            case 1: {
                return this.validateLayout((Layout)value, diagnostics, context);
            }
            case 2: {
                return this.validateRectangleLayout((Layout)value, diagnostics, context);
            }
            case 3: {
                return this.validateRectangleLayoutData((LayoutData)value, diagnostics, context);
            }
            case 4: {
                return this.validatePosition((EObject)value, diagnostics, context);
            }
            case 5: {
                return this.validateDimension((EObject)value, diagnostics, context);
            }
            case 6: {
                return this.validateRectangle((EObject)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateLayoutData(LayoutData layoutData, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(layoutData, diagnostics, context);
    }

    public boolean validateLayout(Layout<?> layout, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(layout, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(layout, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(layout, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(layout, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(layout, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(layout, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(layout, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateLayout_validLayoutData(layout, diagnostics, context);
        }
        return result;
    }

    public boolean validateLayout_validLayoutData(Layout<?> layout, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validateLayout_validLayoutData(layout)) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{"validLayoutData", LayoutsValidator.getObjectLabel(layout, context)}, new Object[]{layout}, context));
            }
            return false;
        }
        return true;
    }

    private boolean validateLayout_validLayoutData(Layout<?> layout) {
        if (WidgetsPackage.eINSTANCE.getAbstractComposite().isInstance((Object)layout.eContainer())) {
            AbstractComposite abstractComposite = (AbstractComposite)layout.eContainer();
            EClassifier specializedType = WidgetsValidator.getSpecializedType(layout.eClass(), LayoutsPackage.eINSTANCE.getLayout());
            if (specializedType != null) {
                for (Control control : abstractComposite.getControls()) {
                    LayoutData layoutData = control.getLayoutData();
                    if (layoutData == null || specializedType.isInstance((Object)layoutData)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean validateRectangleLayout(Layout rectangleLayout, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(rectangleLayout, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(rectangleLayout, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(rectangleLayout, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(rectangleLayout, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(rectangleLayout, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(rectangleLayout, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(rectangleLayout, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateLayout_validLayoutData(rectangleLayout, diagnostics, context);
        }
        return result;
    }

    public boolean validateRectangleLayoutData(LayoutData rectangleLayoutData, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(rectangleLayoutData, diagnostics, context);
    }

    public boolean validatePosition(EObject position, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(position, diagnostics, context);
    }

    public boolean validateDimension(EObject dimension, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(dimension, diagnostics, context);
    }

    public boolean validateRectangle(EObject rectangle, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(rectangle, diagnostics, context);
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

