/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tm.builder;

import java.awt.Color;
import java.util.List;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.e4.tm.builder.swt.SwtBuilder;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TmTestCase
extends TestCase {
    private Display display;
    private Shell shell;
    protected SwtBuilder builder;

    protected void setUp() throws Exception {
        super.setUp();
        this.display = Display.getDefault();
        this.shell = new Shell(this.display);
        this.builder = new SwtBuilder();
        this.shell.setSize(600, 600);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.shell.dispose();
        this.builder.dispose();
    }

    protected Composite getTopLevel() {
        return this.shell;
    }

    protected EObject getChild(EObject comp, int i, EClass c) {
        EList contents = comp.eContents();
        Assert.assertTrue((contents.size() > i ? 1 : 0) != 0);
        EObject child = (EObject)contents.get(i);
        Assert.assertEquals((Object)c, (Object)child.eClass());
        return child;
    }

    protected <T> T getChild(Composite comp, int i, Class<T> c, boolean assertClass) {
        Control[] children = comp.getChildren();
        Assert.assertTrue((children.length > i ? 1 : 0) != 0);
        Control control = children[i];
        if (!c.isInstance(control)) {
            Assert.fail();
        }
        if (assertClass) {
            Assert.assertEquals(c, control.getClass());
        }
        return (T)control;
    }

    protected <T> T getChild(Composite comp, int i, Class<T> c) {
        return this.getChild(comp, i, c, true);
    }

    protected <T> T getChild(int i, Class<T> c) {
        return this.getChild(this.getTopLevel(), i, c);
    }

    protected List getListFeature(EObject eObject, String featureName) {
        Object value = eObject.eGet(eObject.eClass().getEStructuralFeature(featureName));
        Assert.assertTrue((boolean)(value instanceof List));
        return (List)value;
    }

    protected Object setFeature(EObject eObject, String featureName, Object value) {
        eObject.eSet(eObject.eClass().getEStructuralFeature(featureName), value);
        return value;
    }

    protected Object getFeature(EObject eObject, String featureName) {
        return eObject.eGet(eObject.eClass().getEStructuralFeature(featureName));
    }

    public static void doRun(Class c) {
        TestRunner runner = new TestRunner();
        runner.doRun((Test)new TestSuite(c));
    }

    protected void testColor(Color col, int red, int green, int blue) {
        Assert.assertEquals((int)red, (int)col.getRed());
        Assert.assertEquals((int)green, (int)col.getGreen());
        Assert.assertEquals((int)blue, (int)col.getBlue());
    }

    protected void testColor(Color col1, Color col2) {
        Assert.assertEquals((int)col1.getRed(), (int)col2.getRed());
        Assert.assertEquals((int)col1.getGreen(), (int)col2.getGreen());
        Assert.assertEquals((int)col1.getBlue(), (int)col2.getBlue());
    }

    protected void testStyle(Control control, int style) {
        Assert.assertTrue(((control.getStyle() & style) == style ? 1 : 0) != 0);
    }
}

