/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.emf.ecore.javascript;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.e4.emf.ecore.javascript.JavascriptSupport;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.mozilla.javascript.Scriptable;

public class NameSupport {
    private JavascriptSupport javascriptSupport;
    static final String NAME_PREFIX = "$";
    public static final String NAME_FEATURE_NAME = "name";
    private Map<EClass, EStructuralFeature> nameFeatures = new HashMap<EClass, EStructuralFeature>();

    public NameSupport(JavascriptSupport javascriptSupport) {
        this.javascriptSupport = javascriptSupport;
    }

    boolean hasName(String name, EObject eObject) {
        if (!name.startsWith(NAME_PREFIX)) {
            return false;
        }
        String eName = this.getName(eObject);
        return eName != null && name.endsWith(eName) && name.length() == NAME_PREFIX.length() + eName.length();
    }

    String getName(EObject eObject) {
        EStructuralFeature feature = this.getNameFeature(eObject);
        return feature != null ? (String)eObject.eGet(feature) : null;
    }

    String getNamePropertyName(String name) {
        return (NAME_PREFIX + name).intern();
    }

    EStructuralFeature getNameFeature(EObject eObject) {
        EClass eClass = eObject.eClass();
        EStructuralFeature feature = this.nameFeatures.get(eClass);
        if (feature == null) {
            feature = eClass.getEStructuralFeature(NAME_FEATURE_NAME);
            if (feature != null && feature.getEType() == EcorePackage.eINSTANCE.getEString()) {
                this.nameFeatures.put(eClass, feature);
            } else {
                feature = null;
            }
        }
        return feature;
    }

    void handleResource(Resource res) {
        Scriptable scope = this.javascriptSupport.getScope(res);
        ResourceSet resSet = res.getResourceSet();
        if (resSet != null) {
            for (Resource siblingRes : resSet.getResources()) {
                if (siblingRes == res) continue;
                this.javascriptSupport.getScript(siblingRes.getURI(), scope);
            }
        }
        new NameAdapter(res);
    }

    private class NameAdapter
    extends EContentAdapter {
        private Scriptable scope;

        public NameAdapter(Resource resource) {
            this.scope = NameSupport.this.javascriptSupport.getResourceScope(resource);
            this.setTarget((Notifier)(resource.getResourceSet() != null ? resource.getResourceSet() : resource));
        }

        protected void setTarget(EObject target) {
            super.setTarget(target);
            this.addName(target);
        }

        protected void unsetTarget(EObject target) {
            super.unsetTarget(target);
            this.removeName(target);
        }

        private boolean isEcoreModelObject(EObject eObject) {
            while (eObject != null) {
                if (eObject == EcorePackage.eINSTANCE) {
                    return true;
                }
                eObject = eObject.eContainer();
            }
            return false;
        }

        protected void addName(EObject eObject) {
            if (this.isEcoreModelObject(eObject)) {
                return;
            }
            String name = NameSupport.this.getName(eObject);
            if (name != null) {
                this.addName(eObject, name);
            }
        }

        private void addName(EObject eObject, String name) {
            name = NameSupport.this.getNamePropertyName(name);
            EObject[] value = eObject;
            Object oldValue = this.scope.get(name, this.scope);
            if (oldValue instanceof EObject[]) {
                EObject[] oldEObjects = (EObject[])oldValue;
                EObject[] newEObjects = new EObject[oldEObjects.length + 1];
                System.arraycopy(oldEObjects, 0, newEObjects, 0, oldEObjects.length);
                newEObjects[oldEObjects.length] = eObject;
                value = newEObjects;
            } else if (oldValue instanceof EObject) {
                value = new EObject[]{(EObject)oldValue, eObject};
            }
            this.scope.put(name, this.scope, (Object)value);
        }

        protected void removeName(EObject eObject) {
            if (this.isEcoreModelObject(eObject)) {
                return;
            }
            String name = NameSupport.this.getName(eObject);
            if (name != null) {
                this.removeName(eObject, name);
            }
        }

        private void removeName(EObject eObject, String name) {
            name = NameSupport.this.getNamePropertyName(name);
            EObject value = null;
            Object oldValue = this.scope.get(name, this.scope);
            if (oldValue instanceof EObject[]) {
                EObject[] oldEObjects = (EObject[])oldValue;
                EObject newEObjects = new EObject[oldEObjects.length - 1];
                int d = 0;
                int i = 0;
                while (i < oldEObjects.length) {
                    if (oldEObjects[i] == eObject) {
                        ++d;
                    } else {
                        newEObjects[i - d] = oldEObjects[i];
                    }
                    ++i;
                }
                value = ((EObject[])newEObjects).length == 1 ? newEObjects[0] : newEObjects;
            }
            this.scope.put(name, this.scope, value);
        }

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            if (notification.getNotifier() instanceof EObject) {
                EObject eObject = (EObject)notification.getNotifier();
                if (notification.getFeature() == NameSupport.this.getNameFeature(eObject)) {
                    if (notification.getOldValue() instanceof String) {
                        this.removeName(eObject, (String)notification.getOldValue());
                    }
                    if (notification.getNewValue() instanceof String) {
                        this.addName(eObject, (String)notification.getNewValue());
                    }
                }
            }
        }
    }
}

