/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.demo.viewer;

import org.eclipse.e4.core.services.context.IEclipseContext;
import org.eclipse.e4.ui.model.application.MPart;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelUtils {
    public static void activate(MPart<?> part) {
        MPart parent = part.getParent();
        IEclipseContext partContext = part.getContext();
        while (parent != null) {
            IEclipseContext parentContext = parent.getContext();
            parent.setActiveChild(part);
            if (parentContext != null) {
                parentContext.set("activeChild", (Object)partContext);
                partContext = parentContext;
            }
            part = parent;
            parent = parent.getParent();
        }
    }

    static MPart<?> getElement(Composite composite) {
        Composite container = composite;
        while (container != null) {
            Object owner = container.getData("modelElement");
            if (owner != null && owner instanceof MPart) {
                return (MPart)owner;
            }
            container = container.getParent();
        }
        return null;
    }

    static IEclipseContext getContext(Composite composite) {
        MPart part = ModelUtils.getElement(composite);
        while (part != null) {
            IEclipseContext result = part.getContext();
            if (result != null) {
                return result;
            }
            part = part.getParent();
        }
        return null;
    }

    public static EObject topObject(MPart<?> part) {
        MPart lastTop = part;
        MPart currentTop = part.getParent();
        while (currentTop != null) {
            lastTop = currentTop;
            currentTop = currentTop.getParent();
        }
        return lastTop.eContainer();
    }

    private static MPart findElementById(MPart part, String id) {
        if (id == null || id.length() == 0) {
            return null;
        }
        if (id.equals(part.getId())) {
            return part;
        }
        EList children = part.getChildren();
        MPart foundPart = null;
        for (MPart childPart : children) {
            foundPart = ModelUtils.findElementById(childPart, id);
            if (foundPart == null) continue;
            return foundPart;
        }
        return null;
    }

    public static MPart findPart(MPart toSearch, String id) {
        MPart found = ModelUtils.findElementById(toSearch, id);
        if (found instanceof MPart) {
            return found;
        }
        return null;
    }
}

