/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.demo.modifier;

import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.e4.core.services.annotations.In;
import org.eclipse.e4.core.services.annotations.Inject;
import org.eclipse.e4.demo.modifier.EMFScriptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class ElementView {
    private Realm realm = Realm.getDefault();
    private IObservableValue selectedElement = new WritableValue(this.realm);
    private IObservableValue jsText = new ComputedValue(this.realm){

        protected Object calculate() {
            return ElementView.this.formatJSField((EObject)ElementView.this.selectedElement.getValue());
        }
    };
    private Text jsInputField;
    private Context jsContext;
    private ImporterTopLevel jsScope;

    public ElementView(Composite parent) {
        this.jsInputField = new Text(parent, 2818);
        Observables.pipe((IObservableValue)this.jsText, (IObservableValue)SWTObservables.observeText((Control)this.jsInputField));
        Button runJSBtn = new Button(parent, 8);
        runJSBtn.setText("Run Script");
        runJSBtn.setBounds(10, 320, 100, 25);
        runJSBtn.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ElementView.this.runJS(ElementView.this.jsInputField.getText());
            }
        });
        GridLayoutFactory.fillDefaults().generateLayout(parent);
        this.initJS();
    }

    protected String formatJSField(EObject value) {
        if (value == null) {
            return "";
        }
        String delim = this.jsInputField.getLineDelimiter();
        String jsString = "// " + value.eClass().getName() + " is selected...\r\n" + "me = selectedElement;" + delim + "out.println(me);" + delim;
        for (EStructuralFeature feature : value.eClass().getEAllStructuralFeatures()) {
            Object val = value.eGet(feature);
            if (!(val instanceof String) && !(val instanceof Boolean) && !(val instanceof Number)) continue;
            String propName = String.valueOf(feature.getName().substring(0, 1).toUpperCase()) + feature.getName().substring(1);
            propName = feature.getName();
            String propString = val instanceof String ? "me." + propName + "=\"" + val + "\"" : "me." + propName + "=" + val;
            jsString = String.valueOf(jsString) + propString + delim;
        }
        return jsString;
    }

    @Inject
    public void setInput(final EObject selection) {
        if (selection == null) {
            return;
        }
        this.realm.asyncExec(new Runnable(){

            public void run() {
                ElementView.this.selectedElement.setValue((Object)selection);
            }
        });
    }

    @In
    public void setSelection(final EObject selection) {
        if (selection == null) {
            return;
        }
        this.realm.asyncExec(new Runnable(){

            public void run() {
                ElementView.this.selectedElement.setValue((Object)selection);
            }
        });
    }

    protected void runJS(String jScript) {
        try {
            ScriptableObject.putProperty((Scriptable)this.jsScope, (String)"selectedElement", (Object)((Object)new EMFScriptable((EObject)this.selectedElement.getValue())));
            this.jsContext.evaluateString((Scriptable)this.jsScope, jScript, "LCV Evaluator", 0, null);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            this.initJS();
        }
    }

    private void initJS() {
        if (this.jsContext != null) {
            Context.exit();
        }
        this.jsContext = Context.enter();
        this.jsScope = new ImporterTopLevel(this.jsContext);
        Object wrappedOut = Context.javaToJS((Object)System.out, (Scriptable)this.jsScope);
        ScriptableObject.putProperty((Scriptable)this.jsScope, (String)"out", (Object)wrappedOut);
    }
}

