/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.services.internal.context;

import junit.framework.TestCase;
import org.eclipse.e4.core.services.IDisposable;
import org.eclipse.e4.core.services.annotations.In;
import org.eclipse.e4.core.services.annotations.Inject;
import org.eclipse.e4.core.services.context.EclipseContextFactory;
import org.eclipse.e4.core.services.context.IEclipseContext;
import org.eclipse.e4.core.services.context.spi.ContextInjectionFactory;
import org.eclipse.e4.core.services.internal.context.PrintService;
import org.eclipse.e4.core.services.internal.context.StringPrintService;
import org.eclipse.e4.core.tests.services.TestActivator;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class ServiceContextTest
extends TestCase {
    private IEclipseContext context;

    protected void setUp() throws Exception {
        super.setUp();
        this.context = EclipseContextFactory.createServiceContext((BundleContext)TestActivator.bundleContext);
    }

    protected void tearDown() throws Exception {
        if (this.context instanceof IDisposable) {
            ((IDisposable)this.context).dispose();
        }
        super.tearDown();
    }

    public void testDeclarativeService() {
        IEclipseContext context = EclipseContextFactory.createServiceContext((BundleContext)TestActivator.bundleContext);
        ServiceContextTest.assertTrue((boolean)context.containsKey("sum"));
        ServiceContextTest.assertEquals((Object)0, (Object)context.get("sum"));
        context.set("x", (Object)1);
        context.set("y", (Object)2);
        int result = (Integer)context.get("sum");
        ServiceContextTest.assertEquals((String)"1.0", (int)3, (int)result);
        context.set("x", (Object)5);
        result = (Integer)context.get("sum");
        ServiceContextTest.assertEquals((String)"1.0", (int)7, (int)result);
    }

    public void testServiceContextAsParent() {
        IEclipseContext child = EclipseContextFactory.create((IEclipseContext)this.context, null);
        child.set("debugString", (Object)"child");
        DebugOptions service = (DebugOptions)child.get(DebugOptions.class.getName());
        ServiceContextTest.assertNotNull((Object)service);
    }

    public void testServiceInjection() {
        Printer userObject = new Printer();
        StringPrintService stringPrint1 = new StringPrintService();
        ServiceRegistration reg1 = TestActivator.bundleContext.registerService(PrintService.SERVICE_NAME, (Object)stringPrint1, null);
        ContextInjectionFactory.inject((Object)userObject, (IEclipseContext)this.context);
        userObject.print("test");
        ServiceContextTest.assertEquals((String)"1.0", (String)"test", (String)stringPrint1.toString());
        reg1.unregister();
        userObject.print("another test");
        ServiceContextTest.assertEquals((String)"1.1", (String)"test", (String)stringPrint1.toString());
        ServiceContextTest.assertNull((String)"1.2", (Object)userObject.printer);
        StringPrintService stringPrint2 = new StringPrintService();
        ServiceRegistration reg2 = TestActivator.bundleContext.registerService(PrintService.SERVICE_NAME, (Object)stringPrint2, null);
        userObject.print("yet another test");
        ServiceContextTest.assertEquals((String)"2.0", (String)"test", (String)stringPrint1.toString());
        ServiceContextTest.assertEquals((String)"2.1", (String)"yet another test", (String)stringPrint2.toString());
        reg2.unregister();
        ServiceContextTest.assertNull((String)"2.2", (Object)userObject.printer);
    }

    public void testServiceRemovalOnContextDispose() {
        StringPrintService stringPrint1 = new StringPrintService();
        ServiceRegistration reg1 = TestActivator.bundleContext.registerService(PrintService.SERVICE_NAME, (Object)stringPrint1, null);
        ServiceReference ref = reg1.getReference();
        PrintService service = (PrintService)this.context.get(PrintService.SERVICE_NAME);
        ServiceContextTest.assertEquals((String)"1.0", (Object)stringPrint1, (Object)service);
        ServiceContextTest.assertEquals((String)"1.1", (int)1, (int)ref.getUsingBundles().length);
        service = null;
        ((IDisposable)this.context).dispose();
        ServiceContextTest.assertNull((String)"2.0", (Object)ref.getUsingBundles());
        reg1.unregister();
    }

    public void testServiceExample() {
        ServiceRegistration reg = TestActivator.bundleContext.registerService(IPaletteService.class.getName(), (Object)new PaletteImpl(Color.BLUE), null);
        IEclipseContext context = EclipseContextFactory.createServiceContext((BundleContext)TestActivator.bundleContext);
        Crayon crayon = new Crayon();
        ContextInjectionFactory.inject((Object)crayon, (IEclipseContext)context);
        crayon.draw();
        reg.unregister();
        crayon.draw();
    }

    public void testServiceRemovalOnChildContextDispose() {
        StringPrintService stringPrint1 = new StringPrintService();
        ServiceRegistration reg1 = TestActivator.bundleContext.registerService(PrintService.SERVICE_NAME, (Object)stringPrint1, null);
        ServiceReference ref = reg1.getReference();
        IEclipseContext child = EclipseContextFactory.create((IEclipseContext)this.context, null);
        child.set("debugString", (Object)"child");
        PrintService service = (PrintService)child.get(PrintService.SERVICE_NAME);
        ServiceContextTest.assertEquals((String)"1.0", (Object)stringPrint1, (Object)service);
        ServiceContextTest.assertEquals((String)"1.1", (int)1, (int)ref.getUsingBundles().length);
        ServiceContextTest.assertTrue((String)"1.2", (boolean)this.context.containsKey(PrintService.SERVICE_NAME));
        service = null;
        child = null;
        System.gc();
        System.runFinalization();
        System.gc();
        ServiceContextTest.assertTrue((String)"2.0", (boolean)this.context.containsKey(DebugOptions.class.getName()));
        ServiceContextTest.assertNull((String)"2.1", (Object)ref.getUsingBundles());
        reg1.unregister();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Color {
        RED,
        BLUE,
        YELLOW,
        GREEN,
        ORANGE,
        PURPLE;

    }

    class Crayon {
        @In
        IPaletteService palette;

        Crayon() {
        }

        public void draw() {
            if (this.palette == null) {
                System.out.println("I'm out of ink!");
            } else {
                System.out.println("My ink is  " + (Object)((Object)this.palette.getColor()));
            }
        }
    }

    static interface IPaletteService {
        public Color getColor();
    }

    class PaletteImpl
    implements IPaletteService {
        private final Color color;

        PaletteImpl(Color color) {
            this.color = color;
        }

        public Color getColor() {
            return this.color;
        }
    }

    static class Printer {
        @Inject
        PrintService printer;

        Printer() {
        }

        public void print(String message) {
            if (this.printer != null) {
                this.printer.print(message);
            } else {
                System.out.println(message);
            }
        }
    }
}

