/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.services.internal.context;

import java.beans.PropertyChangeListener;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.e4.core.services.IDisposable;
import org.eclipse.e4.core.services.annotations.In;
import org.eclipse.e4.core.services.annotations.Out;
import org.eclipse.e4.core.services.annotations.PostConstruct;
import org.eclipse.e4.core.services.context.EclipseContextFactory;
import org.eclipse.e4.core.services.context.IEclipseContext;
import org.eclipse.e4.core.services.context.spi.ContextInjectionFactory;
import org.eclipse.e4.core.services.internal.context.ObjectBasic;
import org.eclipse.e4.core.services.internal.context.ObjectSubClass;
import org.eclipse.e4.core.services.internal.context.ObjectSuperClass;
import org.eclipse.e4.core.services.internal.context.ObjectWithAnnotations;

public class ContextInjectionTest
extends TestCase {
    public static Test suite() {
        return new TestSuite(ContextInjectionTest.class);
    }

    public ContextInjectionTest() {
    }

    public ContextInjectionTest(String name) {
        super(name);
    }

    public void testContextSetOneArg() {
        IEclipseContext context = EclipseContextFactory.create();
        Object methodValue = new Object();
        context.set("injectedMethod", methodValue);
        class Injected {
            int contextSetCalled = 0;
            int setMethodCalled = 0;

            Injected() {
            }

            public void contextSet(IEclipseContext context) {
                ++this.contextSetCalled;
            }

            @In
            public void setInjectedMethod(Object arg) {
                ++this.setMethodCalled;
            }
        }
        Injected object = new Injected();
        ContextInjectionFactory.inject((Object)object, (IEclipseContext)context);
        ContextInjectionTest.assertEquals((int)1, (int)object.setMethodCalled);
        ContextInjectionTest.assertEquals((int)1, (int)object.contextSetCalled);
        context.set("injectedMethod", (Object)"AnotherValue");
        ContextInjectionTest.assertEquals((int)2, (int)object.setMethodCalled);
        ContextInjectionTest.assertEquals((int)1, (int)object.contextSetCalled);
    }

    public void testContextSetZeroArgs() {
        IEclipseContext context = EclipseContextFactory.create();
        Object methodValue = new Object();
        context.set("injectedMethod", methodValue);
        class Injected {
            int contextSetCalled = 0;
            int setMethodCalled = 0;

            Injected() {
            }

            public void contextSet() {
                ++this.contextSetCalled;
            }

            @In
            public void setInjectedMethod(Object arg) {
                ++this.setMethodCalled;
            }
        }
        Injected object = new Injected();
        ContextInjectionFactory.inject((Object)object, (IEclipseContext)context);
        ContextInjectionTest.assertEquals((int)1, (int)object.setMethodCalled);
        ContextInjectionTest.assertEquals((int)1, (int)object.contextSetCalled);
        context.set("injectedMethod", (Object)"AnotherValue");
        ContextInjectionTest.assertEquals((int)2, (int)object.setMethodCalled);
        ContextInjectionTest.assertEquals((int)1, (int)object.contextSetCalled);
    }

    public void testFieldMethodOrder() {
        AssertionFailedError[] error = new AssertionFailedError[1];
        IEclipseContext context = EclipseContextFactory.create();
        Object fieldValue = new Object();
        Object methodValue = new Object();
        context.set("injectedField", fieldValue);
        context.set("injectedMethod", methodValue);
        class Injected {
            @In
            Object injectedField;
            Object methodValue;
            private final /* synthetic */ AssertionFailedError[] val$error;

            Injected(AssertionFailedError[] assertionFailedErrorArray) {
                this.val$error = assertionFailedErrorArray;
            }

            @In
            public void setInjectedMethod(Object arg) {
                try {
                    ContextInjectionTest.assertTrue((this.injectedField != null ? 1 : 0) != 0);
                }
                catch (AssertionFailedError e) {
                    this.val$error[0] = e;
                }
                this.methodValue = arg;
            }
        }
        Injected object = new Injected(error);
        ContextInjectionFactory.inject((Object)object, (IEclipseContext)context);
        if (error[0] != null) {
            throw error[0];
        }
        ContextInjectionTest.assertEquals((Object)fieldValue, (Object)object.injectedField);
        ContextInjectionTest.assertEquals((Object)methodValue, (Object)object.methodValue);
        context.remove("injectedMethod");
        if (error[0] != null) {
            throw error[0];
        }
        ContextInjectionTest.assertEquals((Object)fieldValue, (Object)object.injectedField);
        ContextInjectionTest.assertNull((Object)object.methodValue);
        ((IDisposable)context).dispose();
        if (error[0] != null) {
            throw error[0];
        }
    }

    public void testInheritedPostConstruct() {
        IEclipseContext context = EclipseContextFactory.create();
        context.set("OverriddenMethod", new Object());
        context.set("StringViaMethod", (Object)"");
        context.set("ObjectViaMethod", new Object());
        ObjectSubClass userObject = new ObjectSubClass();
        ContextInjectionFactory.inject((Object)userObject, (IEclipseContext)context);
        ContextInjectionTest.assertEquals((int)1, (int)userObject.superPostConstructCount);
        ContextInjectionTest.assertEquals((int)1, (int)userObject.subPostConstructCount);
        context.set("OverriddenMethod", new Object());
        ContextInjectionTest.assertEquals((int)1, (int)userObject.superPostConstructCount);
        ContextInjectionTest.assertEquals((int)1, (int)userObject.subPostConstructCount);
    }

    public void testInheritedPreDestroy() {
        IEclipseContext context = EclipseContextFactory.create();
        context.set("OverriddenMethod", new Object());
        context.set("StringViaMethod", (Object)"");
        context.set("ObjectViaMethod", new Object());
        ObjectSubClass userObject = new ObjectSubClass();
        ContextInjectionFactory.inject((Object)userObject, (IEclipseContext)context);
        ContextInjectionTest.assertEquals((int)0, (int)userObject.superPreDestroyCount);
        ContextInjectionTest.assertEquals((int)0, (int)userObject.subPreDestroyCount);
        context.set("OverriddenMethod", new Object());
        ContextInjectionTest.assertEquals((int)0, (int)userObject.superPreDestroyCount);
        ContextInjectionTest.assertEquals((int)0, (int)userObject.subPreDestroyCount);
        ((IDisposable)context).dispose();
        ContextInjectionTest.assertEquals((int)1, (int)userObject.superPreDestroyCount);
        ContextInjectionTest.assertEquals((int)1, (int)userObject.subPreDestroyCount);
    }

    public void testOverriddenPreDestroy() {
        IEclipseContext context = EclipseContextFactory.create();
        context.set("OverriddenMethod", new Object());
        context.set("StringViaMethod", (Object)"");
        context.set("ObjectViaMethod", new Object());
        ObjectSubClass userObject = new ObjectSubClass();
        ContextInjectionFactory.inject((Object)userObject, (IEclipseContext)context);
        ContextInjectionTest.assertEquals((int)0, (int)userObject.overriddenPreDestroyCount);
        context.set("OverriddenMethod", new Object());
        ContextInjectionTest.assertEquals((int)0, (int)userObject.overriddenPreDestroyCount);
        ((IDisposable)context).dispose();
        ContextInjectionTest.assertEquals((int)1, (int)userObject.overriddenPreDestroyCount);
    }

    public void testOutMethod() {
        IEclipseContext parent = EclipseContextFactory.create();
        IEclipseContext context = EclipseContextFactory.create((IEclipseContext)parent, null);
        IEclipseContext outputContent = EclipseContextFactory.create();
        context.set("outputs", (Object)outputContent);
        parent.set("OverriddenMethod", new Object());
        parent.set("StringViaMethod", (Object)"oldValue");
        context.set("input", (Object)"Hello");
        class Injected
        extends ObjectSuperClass {
            private String input;

            Injected() {
            }

            @In
            private void setInput(String input) {
                this.input = input;
            }

            @Out
            private String getOutput() {
                return this.input;
            }

            public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            }
        }
        Injected object = new Injected();
        ContextInjectionFactory.inject((Object)object, (IEclipseContext)context);
        ContextInjectionTest.assertEquals((Object)"Hello", (Object)outputContent.get("output"));
        parent.set("StringViaMethod", (Object)"value");
    }

    public synchronized void testInjection() {
        Integer testInt = new Integer(123);
        String testString = new String("abc");
        Boolean testBoolean = new Boolean(true);
        String testStringViaMethod = new String("abcd");
        Object testObjectViaMethod = new Object();
        IEclipseContext context = EclipseContextFactory.create();
        context.set("Integer", (Object)testInt);
        context.set("string", (Object)testString);
        context.set("Boolean", (Object)testBoolean);
        context.set("StringViaMethod", (Object)testStringViaMethod);
        context.set("objectViaMethod", testObjectViaMethod);
        ObjectBasic userObject = new ObjectBasic();
        ContextInjectionFactory.inject((Object)userObject, (IEclipseContext)context);
        ContextInjectionTest.assertEquals((String)testString, (String)userObject.getString());
        ContextInjectionTest.assertEquals((Object)testInt, (Object)userObject.getInteger());
        ContextInjectionTest.assertEquals((Object)context, (Object)userObject.getContext());
        ContextInjectionTest.assertEquals((int)1, (int)userObject.setStringCalled);
        ContextInjectionTest.assertEquals((int)1, (int)userObject.setObjectCalled);
        ContextInjectionTest.assertEquals((String)testStringViaMethod, (String)userObject.getStringViaMethod());
        ContextInjectionTest.assertEquals((Object)testObjectViaMethod, (Object)userObject.getObjectViaMethod());
        ContextInjectionTest.assertTrue((boolean)userObject.isFinalized());
    }

    public synchronized void testInjectionAndInheritance() {
        Integer testInt = new Integer(123);
        String testString = new String("abc");
        String testStringViaMethod = new String("abcd");
        Object testObjectViaMethod = new Object();
        IEclipseContext context = EclipseContextFactory.create();
        context.set("Integer", (Object)testInt);
        context.set("string", (Object)testString);
        context.set("StringViaMethod", (Object)testStringViaMethod);
        context.set("objectViaMethod", testObjectViaMethod);
        context.set("OverriddenMethod", new Object());
        ObjectSubClass userObject = new ObjectSubClass();
        ContextInjectionFactory.inject((Object)userObject, (IEclipseContext)context);
        ContextInjectionTest.assertEquals((String)testString, (String)userObject.getString());
        ContextInjectionTest.assertEquals((Object)context, (Object)userObject.getContext());
        ContextInjectionTest.assertEquals((String)testStringViaMethod, (String)userObject.getStringViaMethod());
        ContextInjectionTest.assertEquals((int)1, (int)userObject.setStringCalled);
        ContextInjectionTest.assertEquals((Object)testInt, (Object)userObject.getInteger());
        ContextInjectionTest.assertEquals((Object)testObjectViaMethod, (Object)userObject.getObjectViaMethod());
        ContextInjectionTest.assertEquals((int)1, (int)userObject.setObjectCalled);
        ContextInjectionTest.assertEquals((int)1, (int)userObject.getFinalizedCalled());
    }

    public synchronized void testInjectionFromParent() {
        Integer testInt = new Integer(123);
        String testStringViaMethod = new String("abcd");
        Object testObjectViaMethod = new Object();
        IEclipseContext parentContext = EclipseContextFactory.create();
        parentContext.set("Integer", (Object)testInt);
        parentContext.set("StringViaMethod", (Object)testStringViaMethod);
        IEclipseContext context = EclipseContextFactory.create((IEclipseContext)parentContext, null);
        context.set("objectViaMethod", testObjectViaMethod);
        context.set("string", (Object)"foo");
        ObjectBasic userObject = new ObjectBasic();
        ContextInjectionFactory.inject((Object)userObject, (IEclipseContext)context);
        ContextInjectionTest.assertEquals((Object)testInt, (Object)userObject.getInteger());
        ContextInjectionTest.assertEquals((Object)context, (Object)userObject.getContext());
        ContextInjectionTest.assertEquals((String)testStringViaMethod, (String)userObject.getStringViaMethod());
        ContextInjectionTest.assertEquals((Object)testObjectViaMethod, (Object)userObject.getObjectViaMethod());
        ContextInjectionTest.assertEquals((int)1, (int)userObject.setStringCalled);
        ContextInjectionTest.assertEquals((int)1, (int)userObject.setObjectCalled);
        ContextInjectionTest.assertTrue((boolean)userObject.isFinalized());
    }

    public void testOptionalInjection() {
        Integer testInt = new Integer(123);
        String testString = new String("abc");
        Boolean testBoolean = new Boolean(true);
        String testStringViaMethod = new String("abcd");
        Object testObjectViaMethod = new Object();
        IEclipseContext context = EclipseContextFactory.create();
        context.set("Integer", (Object)testInt);
        context.set("string", (Object)testString);
        context.set("Boolean", (Object)testBoolean);
        context.set("StringViaMethod", (Object)testStringViaMethod);
        context.set("objectViaMethod", testObjectViaMethod);
        ObjectWithAnnotations userObject = new ObjectWithAnnotations();
        ContextInjectionFactory.inject((Object)userObject, (IEclipseContext)context);
        ContextInjectionTest.assertEquals((String)testString, (String)userObject.getString());
        ContextInjectionTest.assertEquals((Object)testInt, (Object)userObject.getInteger());
        ContextInjectionTest.assertEquals((Object)context, (Object)userObject.getContext());
        ContextInjectionTest.assertEquals((int)1, (int)userObject.setStringCalled);
        ContextInjectionTest.assertEquals((int)1, (int)userObject.setObjectCalled);
        ContextInjectionTest.assertEquals((String)testStringViaMethod, (String)userObject.getStringViaMethod());
        ContextInjectionTest.assertEquals((Object)testObjectViaMethod, (Object)userObject.getObjectViaMethod());
        ContextInjectionTest.assertNull((Object)userObject.diMissing);
        ContextInjectionTest.assertNull((Object)userObject.myMissing);
        ContextInjectionTest.assertEquals((int)0, (int)userObject.setMissingCalled);
        ContextInjectionTest.assertNull((Object)userObject.diBoolean);
        ContextInjectionTest.assertNull((Object)userObject.myBoolean);
        ContextInjectionTest.assertEquals((int)0, (int)userObject.setBooleanCalled);
        ContextInjectionTest.assertNull((Object)userObject.diBoolean);
        ContextInjectionTest.assertNull((Object)userObject.myBoolean);
        ContextInjectionTest.assertEquals((int)0, (int)userObject.setBooleanCalled);
        ContextInjectionTest.assertTrue((boolean)userObject.isFinalized());
    }

    public void testOverriddenSetter() {
        IEclipseContext context = EclipseContextFactory.create();
        context.set("OverriddenMethod", new Object());
        context.set("StringViaMethod", (Object)"");
        context.set("ObjectViaMethod", new Object());
        ObjectSubClass userObject = new ObjectSubClass();
        ContextInjectionFactory.inject((Object)userObject, (IEclipseContext)context);
        ContextInjectionTest.assertEquals((int)1, (int)userObject.getOverriddenCount());
        context.set("OverriddenMethod", new Object());
        ContextInjectionTest.assertEquals((int)2, (int)userObject.getOverriddenCount());
    }

    public void testPostConstruct() {
        IEclipseContext context = EclipseContextFactory.create();
        Object methodValue = new Object();
        context.set("injectedMethod", methodValue);
        class Injected {
            int postConstructCalled = 0;
            int setMethodCalled = 0;

            Injected() {
            }

            @PostConstruct
            public void init() {
                ++this.postConstructCalled;
            }

            @In
            public void setInjectedMethod(Object arg) {
                ++this.setMethodCalled;
            }
        }
        Injected object = new Injected();
        ContextInjectionFactory.inject((Object)object, (IEclipseContext)context);
        ContextInjectionTest.assertEquals((int)1, (int)object.setMethodCalled);
        ContextInjectionTest.assertEquals((int)1, (int)object.postConstructCalled);
        context.set("injectedMethod", (Object)"AnotherValue");
        ContextInjectionTest.assertEquals((int)2, (int)object.setMethodCalled);
        ContextInjectionTest.assertEquals((int)1, (int)object.postConstructCalled);
    }

    public void testPostConstructAfterSetters() {
        IEclipseContext context = EclipseContextFactory.create();
        context.set("OverriddenMethod", new Object());
        context.set("StringViaMethod", (Object)"");
        context.set("ObjectViaMethod", new Object());
        ObjectSubClass userObject = new ObjectSubClass();
        ContextInjectionFactory.inject((Object)userObject, (IEclipseContext)context);
        ContextInjectionTest.assertEquals((int)1, (int)userObject.postConstructSetObjectCalled);
        ContextInjectionTest.assertEquals((int)1, (int)userObject.postConstructSetStringCalled);
        ContextInjectionTest.assertEquals((int)1, (int)userObject.postConstructSetOverriddenCalled);
    }
}

