/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.services.internal.context;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.e4.core.services.context.EclipseContextFactory;
import org.eclipse.e4.core.services.context.IContextFunction;
import org.eclipse.e4.core.services.context.IEclipseContext;
import org.eclipse.e4.core.services.context.spi.ContextInjectionFactory;
import org.eclipse.e4.core.services.internal.context.ObjectBasic;

public class ContextDynamicTest
extends TestCase {
    public ContextDynamicTest() {
    }

    public ContextDynamicTest(String name) {
        super(name);
    }

    public void testReplaceFunctionWithStaticValue() {
        IEclipseContext parent = EclipseContextFactory.create();
        IEclipseContext context = EclipseContextFactory.create((IEclipseContext)parent, null);
        ContextDynamicTest.assertNull((Object)context.getLocal("bar"));
        context.set("bar", (Object)"baz1");
        context.set("bar", (Object)new IContextFunction(){

            public Object compute(IEclipseContext context, Object[] arguments) {
                return "baz1";
            }
        });
        parent.set("bar", (Object)"baz2");
        ContextDynamicTest.assertEquals((Object)"baz1", (Object)context.get("bar"));
        context.set("bar", (Object)"baz3");
        ContextDynamicTest.assertEquals((Object)"baz3", (Object)context.get("bar"));
    }

    public synchronized void testAddRemove() {
        Integer testInt = new Integer(123);
        String testString = new String("abc");
        String testStringViaMethod = new String("abcd");
        Object testObjectViaMethod = new Object();
        IEclipseContext context = EclipseContextFactory.create();
        context.set("Integer", (Object)testInt);
        context.set("StringViaMethod", (Object)testStringViaMethod);
        context.set("objectViaMethod", null);
        context.set("string", null);
        ObjectBasic userObject = new ObjectBasic();
        ContextInjectionFactory.inject((Object)userObject, (IEclipseContext)context);
        ContextDynamicTest.assertEquals((Object)testInt, (Object)userObject.getInteger());
        ContextDynamicTest.assertEquals((String)testStringViaMethod, (String)userObject.getStringViaMethod());
        ContextDynamicTest.assertEquals((int)1, (int)userObject.setStringCalled);
        ContextDynamicTest.assertNull((Object)userObject.getString());
        ContextDynamicTest.assertNull((Object)userObject.getObjectViaMethod());
        ContextDynamicTest.assertEquals((int)1, (int)userObject.setObjectCalled);
        context.set("string", (Object)testString);
        context.set("objectViaMethod", testObjectViaMethod);
        ContextDynamicTest.assertEquals((String)testString, (String)userObject.getString());
        ContextDynamicTest.assertEquals((Object)testInt, (Object)userObject.getInteger());
        ContextDynamicTest.assertEquals((int)1, (int)userObject.setStringCalled);
        ContextDynamicTest.assertEquals((int)2, (int)userObject.setObjectCalled);
        ContextDynamicTest.assertEquals((String)testStringViaMethod, (String)userObject.getStringViaMethod());
        ContextDynamicTest.assertEquals((Object)testObjectViaMethod, (Object)userObject.getObjectViaMethod());
        context.remove("Integer");
        context.remove("StringViaMethod");
        ContextDynamicTest.assertNull((Object)userObject.getInteger());
        ContextDynamicTest.assertEquals((String)testString, (String)userObject.getString());
        ContextDynamicTest.assertEquals((int)2, (int)userObject.setStringCalled);
        ContextDynamicTest.assertEquals((int)2, (int)userObject.setObjectCalled);
        ContextDynamicTest.assertNull((Object)userObject.getStringViaMethod());
        ContextDynamicTest.assertEquals((Object)testObjectViaMethod, (Object)userObject.getObjectViaMethod());
    }

    public synchronized void testParentAddRemove() {
        Integer testInt = new Integer(123);
        String testString = new String("abc");
        String testStringViaMethod = new String("abcd");
        Object testObjectViaMethod = new Object();
        IEclipseContext parentContext = EclipseContextFactory.create();
        parentContext.set("Integer", (Object)testInt);
        parentContext.set("StringViaMethod", (Object)testStringViaMethod);
        parentContext.set("objectViaMethod", null);
        parentContext.set("string", null);
        IEclipseContext context = EclipseContextFactory.create((IEclipseContext)parentContext, null);
        ObjectBasic userObject = new ObjectBasic();
        ContextInjectionFactory.inject((Object)userObject, (IEclipseContext)context);
        ContextDynamicTest.assertEquals((Object)testInt, (Object)userObject.getInteger());
        ContextDynamicTest.assertEquals((String)testStringViaMethod, (String)userObject.getStringViaMethod());
        ContextDynamicTest.assertEquals((int)1, (int)userObject.setStringCalled);
        ContextDynamicTest.assertNull((Object)userObject.getString());
        ContextDynamicTest.assertNull((Object)userObject.getObjectViaMethod());
        ContextDynamicTest.assertEquals((int)1, (int)userObject.setObjectCalled);
        parentContext.set("string", (Object)testString);
        parentContext.set("objectViaMethod", testObjectViaMethod);
        ContextDynamicTest.assertEquals((String)testString, (String)userObject.getString());
        ContextDynamicTest.assertEquals((Object)testInt, (Object)userObject.getInteger());
        ContextDynamicTest.assertEquals((int)1, (int)userObject.setStringCalled);
        ContextDynamicTest.assertEquals((int)2, (int)userObject.setObjectCalled);
        ContextDynamicTest.assertEquals((String)testStringViaMethod, (String)userObject.getStringViaMethod());
        ContextDynamicTest.assertEquals((Object)testObjectViaMethod, (Object)userObject.getObjectViaMethod());
        parentContext.remove("Integer");
        parentContext.remove("StringViaMethod");
        ContextDynamicTest.assertNull((Object)userObject.getInteger());
        ContextDynamicTest.assertEquals((String)testString, (String)userObject.getString());
        ContextDynamicTest.assertEquals((int)2, (int)userObject.setStringCalled);
        ContextDynamicTest.assertEquals((int)2, (int)userObject.setObjectCalled);
        ContextDynamicTest.assertNull((Object)userObject.getStringViaMethod());
        ContextDynamicTest.assertEquals((Object)testObjectViaMethod, (Object)userObject.getObjectViaMethod());
    }

    public synchronized void testContextAware() {
        IEclipseContext context = EclipseContextFactory.create();
        context.set("stringViaMethod", null);
        context.set("objectViaMethod", null);
        context.set("string", null);
        context.set("integer", null);
        ObjectBasic userObject = new ObjectBasic();
        ContextInjectionFactory.inject((Object)userObject, (IEclipseContext)context);
        ContextDynamicTest.assertTrue((boolean)userObject.isFinalized());
    }

    public static Test suite() {
        return new TestSuite(ContextDynamicTest.class);
    }
}

