/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.services.internal.context;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.e4.core.services.context.ContextChangeEvent;
import org.eclipse.e4.core.services.context.IEclipseContext;
import org.eclipse.e4.core.services.context.IRunAndTrack;
import org.eclipse.e4.core.services.context.spi.IContextConstants;
import org.eclipse.e4.core.services.internal.context.EclipseContext;

public class ContextToObjectLink
implements IRunAndTrack,
IContextConstants {
    private static final String IN = ".In";
    private static final String INJECT = ".Inject";
    private static final String JAVA_OBJECT = "java.lang.Object";
    private static final String NAMED = ".Named";
    private static final String OUT = ".Out";
    private static final String POST_CONSTRUCT = ".PostConstruct";
    private static final String PRE_DESTROY = ".PreDestroy";
    private static final String RESOURCE = ".Resource";
    protected IEclipseContext context;
    protected final String fieldPrefix;
    protected final int fieldPrefixLength;
    protected final String setMethodPrefix;
    protected List userObjects = new ArrayList(3);
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public ContextToObjectLink(IEclipseContext context, String fieldPrefix, String setMethodPrefix) {
        this.context = context;
        this.fieldPrefix = fieldPrefix != null ? fieldPrefix : "di_";
        this.setMethodPrefix = setMethodPrefix != null ? setMethodPrefix : "set";
        this.fieldPrefixLength = this.fieldPrefix.length();
    }

    protected String altKey(String key) {
        if (key.length() == 0) {
            return null;
        }
        char firstChar = key.charAt(0);
        String candidate = null;
        if (Character.isUpperCase(firstChar)) {
            firstChar = Character.toLowerCase(firstChar);
            candidate = key.length() == 1 ? Character.toString(firstChar) : String.valueOf(Character.toString(firstChar)) + key.substring(1);
        } else if (Character.isLowerCase(firstChar)) {
            firstChar = Character.toUpperCase(firstChar);
            candidate = key.length() == 1 ? Character.toString(firstChar) : String.valueOf(Character.toString(firstChar)) + key.substring(1);
        }
        return candidate;
    }

    void callMethod(Object object, Method m, Object[] args) {
        block6: {
            try {
                if (!m.isAccessible()) {
                    m.setAccessible(true);
                    try {
                        m.invoke(object, args);
                        break block6;
                    }
                    finally {
                        m.setAccessible(false);
                    }
                }
                m.invoke(object, args);
            }
            catch (Exception e) {
                this.logWarning(object, e);
            }
        }
    }

    private void findAndCallDispose(Object object, Class objectsClass, ProcessMethodsResult result) {
        Method[] methods = objectsClass.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            if (method.getParameterTypes().length <= 0) {
                try {
                    Object[] annotations = (Object[])method.getClass().getMethod("getAnnotations", new Class[0]).invoke((Object)method, new Object[0]);
                    int j = 0;
                    while (j < annotations.length) {
                        Object annotation = annotations[j];
                        try {
                            String annotationName = ((Class)annotation.getClass().getMethod("annotationType", new Class[0]).invoke(annotation, new Object[0])).getName();
                            if (annotationName.endsWith(PRE_DESTROY) && !result.seen(method)) {
                                this.callMethod(object, method, null);
                            }
                        }
                        catch (Exception ex) {
                            this.logWarning(method, ex);
                        }
                        ++j;
                    }
                }
                catch (Exception exception) {}
            }
            ++i;
        }
        try {
            Class[] classArray = new Class[1];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.e4.core.services.context.IEclipseContext");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Method dispose = objectsClass.getDeclaredMethod("contextDisposed", classArray);
            if (result.seenMethods.isEmpty() && !result.seen(dispose)) {
                this.callMethod(object, dispose, new Object[]{this.context});
            }
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        try {
            Method dispose = objectsClass.getDeclaredMethod("contextDisposed", new Class[0]);
            if (result.seenMethods.isEmpty() && !result.seen(dispose)) {
                this.callMethod(object, dispose, null);
            }
            return;
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        try {
            Method dispose = objectsClass.getDeclaredMethod("dispose", null);
            if (result.seenMethods.isEmpty() && !result.seen(dispose)) {
                this.callMethod(object, dispose, null);
            }
            return;
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        Class superClass = objectsClass.getSuperclass();
        if (!superClass.getName().equals(JAVA_OBJECT)) {
            this.findAndCallDispose(object, superClass, result);
        }
    }

    protected String findKey(String key, Class clazz) {
        if (this.context.containsKey(key)) {
            return key;
        }
        String candidate = this.altKey(key);
        if (candidate != null && this.context.containsKey(candidate)) {
            return candidate;
        }
        if (this.context.containsKey(clazz.getName())) {
            return clazz.getName();
        }
        return null;
    }

    private void handleAdd(final ContextChangeEvent event) {
        final String name = event.getName();
        if ("parentContext".equals(name)) {
            this.handleParentChange(event);
            return;
        }
        Processor processor = new Processor(true){

            void processField(Field field, String injectName, boolean optional) {
                String injectKey = ContextToObjectLink.this.findKey(name, field.getType());
                if (injectKey != null && (ContextToObjectLink.this.keyMatches(name, injectName) || field.getType().getName().equals(name))) {
                    ContextToObjectLink.this.setField(this.userObject, field, event.getContext().get(injectKey));
                }
            }

            void processMethod(Method method, boolean optional) {
                String candidateName = method.getName();
                if (candidateName.length() <= ContextToObjectLink.this.setMethodPrefix.length()) {
                    return;
                }
                candidateName = candidateName.substring(ContextToObjectLink.this.setMethodPrefix.length());
                Object[] parameterTypes = method.getParameterTypes();
                if (parameterTypes.length != 1) {
                    return;
                }
                if (ContextToObjectLink.this.keyMatches(name, candidateName)) {
                    String key = ContextToObjectLink.this.findKey(name, parameterTypes[0]);
                    ContextToObjectLink.this.setMethod(this.userObject, method, event.getContext().get(key, parameterTypes));
                }
            }
        };
        Object[] objectsCopy = this.safeObjectsCopy();
        int i = 0;
        while (i < objectsCopy.length) {
            this.processClassHierarchy(objectsCopy[i], processor);
            ++i;
        }
    }

    private void handleParentChange(final ContextChangeEvent event) {
        EclipseContext newParent;
        final EclipseContext eventContext = (EclipseContext)event.getContext();
        final EclipseContext oldParent = (EclipseContext)event.getOldValue();
        if (oldParent == (newParent = (EclipseContext)eventContext.get("parentContext"))) {
            return;
        }
        Processor processor = new Processor(true){

            private boolean hasChanged(String key) {
                Object newValue;
                if (eventContext.getLocal(key) != null) {
                    return false;
                }
                Object oldValue = oldParent == null ? null : oldParent.internalGet(eventContext, key, null, false);
                Object object = newValue = newParent == null ? null : newParent.internalGet(eventContext, key, null, false);
                return oldValue != newValue;
            }

            void processField(Field field, String injectName, boolean optional) {
                String key = ContextToObjectLink.this.findKey(injectName, field.getType());
                if (key != null) {
                    if (this.hasChanged(key)) {
                        ContextToObjectLink.this.setField(event.getArguments()[0], field, event.getContext().get(key));
                    }
                } else if (!optional) {
                    throw new IllegalStateException("Could not set " + field + " because of missing: " + injectName);
                }
            }

            void processMethod(Method method, boolean optional) {
                String candidateName = method.getName();
                if (candidateName.length() <= ContextToObjectLink.this.setMethodPrefix.length()) {
                    return;
                }
                candidateName = candidateName.substring(ContextToObjectLink.this.setMethodPrefix.length());
                Object[] parameterTypes = method.getParameterTypes();
                if (parameterTypes.length != 1) {
                    return;
                }
                String key = ContextToObjectLink.this.findKey(candidateName, parameterTypes[0]);
                if (key != null) {
                    if (this.hasChanged(key)) {
                        ContextToObjectLink.this.setMethod(this.userObject, method, event.getContext().get(key, parameterTypes));
                    }
                } else if (!optional) {
                    throw new IllegalStateException("Could not invoke " + method + " because of missing: " + candidateName);
                }
            }
        };
        Object[] objectsCopy = this.safeObjectsCopy();
        int i = 0;
        while (i < objectsCopy.length) {
            this.processClassHierarchy(objectsCopy[i], processor);
            ++i;
        }
    }

    private void handleDispose(ContextChangeEvent event) {
        Iterator it = this.userObjects.iterator();
        while (it.hasNext()) {
            WeakReference ref = (WeakReference)it.next();
            Object referent = ref.get();
            if (referent == null) continue;
            this.findAndCallDispose(referent, referent.getClass(), new ProcessMethodsResult());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleInitial(final ContextChangeEvent event) {
        if (event.getArguments() == null || event.getArguments().length == 0 || event.getArguments()[0] == null) {
            throw new IllegalArgumentException();
        }
        Processor processor = new Processor(true){

            void processField(Field field, String injectName, boolean optional) {
                String key = ContextToObjectLink.this.findKey(injectName, field.getType());
                if (key != null) {
                    ContextToObjectLink.this.setField(event.getArguments()[0], field, event.getContext().get(key));
                } else if (!optional) {
                    throw new IllegalStateException("Could not set " + field + " because of missing: " + injectName);
                }
            }

            void processMethod(Method method, boolean optional) {
                String candidateName = method.getName();
                if (candidateName.length() <= ContextToObjectLink.this.setMethodPrefix.length()) {
                    return;
                }
                candidateName = candidateName.substring(ContextToObjectLink.this.setMethodPrefix.length());
                Object[] parameterTypes = method.getParameterTypes();
                if (parameterTypes.length != 1) {
                    return;
                }
                String key = ContextToObjectLink.this.findKey(candidateName, parameterTypes[0]);
                if (key != null) {
                    ContextToObjectLink.this.setMethod(this.userObject, method, event.getContext().get(key, parameterTypes));
                } else if (!optional) {
                    throw new IllegalStateException("Could not invoke " + method + " because of missing: " + candidateName);
                }
            }

            public void processOutMethod(Method m, String name) {
                EclipseContext outputContext = (EclipseContext)event.getContext().get("outputs");
                if (outputContext == null) {
                    throw new IllegalStateException("No output context available for @Out " + m + " in " + this.userObject);
                }
                try {
                    Object value;
                    if (!m.isAccessible()) {
                        m.setAccessible(true);
                        try {
                            value = m.invoke(this.userObject, new Object[0]);
                        }
                        finally {
                            m.setAccessible(false);
                        }
                    } else {
                        value = m.invoke(this.userObject, new Object[0]);
                    }
                    outputContext.schedule(new Runnable(this, outputContext, name, value){
                        final /* synthetic */ 3 this$1;
                        private final /* synthetic */ EclipseContext val$outputContext;
                        private final /* synthetic */ String val$name;
                        private final /* synthetic */ Object val$value;
                        {
                            this.this$1 = var1_1;
                            this.val$outputContext = eclipseContext;
                            this.val$name = string;
                            this.val$value = object;
                        }

                        public void run() {
                            this.val$outputContext.set(this.val$name, this.val$value);
                        }
                    });
                    Class<?> clazz = this.userObject.getClass();
                    Class[] classArray = new Class[2];
                    Class<?> clazz2 = class$1;
                    if (clazz2 == null) {
                        try {
                            clazz2 = class$1 = Class.forName("java.lang.String");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    classArray[0] = clazz2;
                    Class<?> clazz3 = class$2;
                    if (clazz3 == null) {
                        try {
                            clazz3 = class$2 = Class.forName("java.beans.PropertyChangeListener");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    classArray[1] = clazz3;
                    Method addListener = clazz.getMethod("addPropertyChangeListener", classArray);
                    ContextToObjectLink.this.callMethod(this.userObject, addListener, new Object[]{name, new PropertyChangeListenerImplementation(name, outputContext)});
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }

            void processPostConstructMethod(Method m) {
                block7: {
                    Object[] methodArgs = null;
                    if (m.getParameterTypes().length == 1) {
                        methodArgs = new Object[]{ContextToObjectLink.this.context};
                    }
                    try {
                        if (!m.isAccessible()) {
                            m.setAccessible(true);
                            try {
                                m.invoke(this.userObject, methodArgs);
                                break block7;
                            }
                            finally {
                                m.setAccessible(false);
                            }
                        }
                        m.invoke(this.userObject, methodArgs);
                    }
                    catch (Exception e) {
                        ContextToObjectLink.this.logWarning(this.userObject, e);
                    }
                }
            }
        };
        processor.shouldProcessOutMethods = true;
        processor.shouldProcessPostConstruct = true;
        this.processClassHierarchy(event.getArguments()[0], processor);
        WeakReference<Object> ref = new WeakReference<Object>(event.getArguments()[0]);
        List list = this.userObjects;
        synchronized (list) {
            this.userObjects.add(ref);
        }
    }

    private void handleRemove(ContextChangeEvent event) {
        final String name = event.getName();
        if ("parentContext".equals(name)) {
            this.handleParentChange(event);
            return;
        }
        Processor processor = new Processor(false){

            void processField(Field field, String injectName, boolean optional) {
                if (ContextToObjectLink.this.keyMatches(name, injectName) || field.getType().getName().equals(name)) {
                    ContextToObjectLink.this.setField(this.userObject, field, null);
                }
            }

            void processMethod(Method method, boolean optional) {
                String candidateName = method.getName();
                if (candidateName.length() <= ContextToObjectLink.this.setMethodPrefix.length()) {
                    return;
                }
                candidateName = candidateName.substring(ContextToObjectLink.this.setMethodPrefix.length());
                Class<?>[] parameterTypes = method.getParameterTypes();
                if (parameterTypes.length != 1) {
                    return;
                }
                if (ContextToObjectLink.this.keyMatches(name, candidateName)) {
                    ContextToObjectLink.this.setMethod(this.userObject, method, null);
                }
            }
        };
        Object[] objectsCopy = this.safeObjectsCopy();
        int i = 0;
        while (i < objectsCopy.length) {
            this.processClassHierarchy(objectsCopy[i], processor);
            ++i;
        }
    }

    private boolean isPostConstruct(Method method) {
        if (!method.getName().equals("contextSet")) {
            return false;
        }
        Class<?>[] parms = method.getParameterTypes();
        if (parms.length == 0) {
            return true;
        }
        if (parms.length == 1) {
            Class<?> clazz = parms[0];
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.e4.core.services.context.IEclipseContext");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz.equals(clazz2)) {
                return true;
            }
        }
        return false;
    }

    protected boolean keyMatches(String key1, String key2) {
        if (key1 == null && key2 == null) {
            return true;
        }
        if (key1 == null || key2 == null) {
            return false;
        }
        if (key1.equals(key2)) {
            return true;
        }
        String candidate = this.altKey(key2);
        if (candidate == null) {
            return false;
        }
        return key1.equals(candidate);
    }

    void logWarning(Object destination, Exception e) {
        System.out.println("Injection failed " + destination.toString());
        if (e != null) {
            e.printStackTrace();
        }
    }

    public boolean notify(ContextChangeEvent event) {
        switch (event.getEventType()) {
            case 0: {
                this.handleInitial(event);
                break;
            }
            case 1: {
                this.handleAdd(event);
                break;
            }
            case 2: {
                this.handleRemove(event);
                break;
            }
            case 3: {
                this.handleDispose(event);
            }
        }
        return !this.userObjects.isEmpty();
    }

    private void processClass(Class objectsClass, Processor processor, ProcessMethodsResult result) {
        if (processor.isSetter) {
            this.processFields(objectsClass, processor);
            this.processMethods(objectsClass, processor, result);
        } else {
            this.processMethods(objectsClass, processor, result);
            this.processFields(objectsClass, processor);
        }
        Class superClass = objectsClass.getSuperclass();
        if (!superClass.getName().equals(JAVA_OBJECT)) {
            this.processClass(superClass, processor, result);
        }
    }

    private void processClassHierarchy(Object userObject, Processor processor) {
        Method m;
        Iterator it;
        processor.setObject(userObject);
        Class<?> objectsClass = userObject.getClass();
        ProcessMethodsResult processMethodsResult = new ProcessMethodsResult();
        this.processClass(objectsClass, processor, processMethodsResult);
        if (processor.shouldProcessPostConstruct) {
            it = processMethodsResult.postConstructMethods.iterator();
            while (it.hasNext()) {
                m = (Method)it.next();
                processor.processPostConstructMethod(m);
            }
        }
        if (!processor.shouldProcessOutMethods) {
            return;
        }
        it = processMethodsResult.outMethods.iterator();
        while (it.hasNext()) {
            char firstChar;
            m = (Method)it.next();
            String name = m.getName();
            if (name.startsWith("get") && name.length() > 3 && Character.isUpperCase(firstChar = (name = name.substring(3)).charAt(0))) {
                firstChar = Character.toLowerCase(firstChar);
                name = name.length() == 1 ? Character.toString(firstChar) : String.valueOf(Character.toString(firstChar)) + name.substring(1);
            }
            processor.processOutMethod(m, name);
        }
    }

    private void processFields(Class objectsClass, Processor processor) {
        Field[] fields = objectsClass.getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            Field field = fields[i];
            String injectName = field.getName();
            boolean inject = false;
            boolean optional = true;
            try {
                Object[] annotations = (Object[])field.getClass().getMethod("getAnnotations", new Class[0]).invoke((Object)field, new Object[0]);
                int j = 0;
                while (j < annotations.length) {
                    block17: {
                        Object annotation = annotations[j];
                        try {
                            String annotationName = ((Class)annotation.getClass().getMethod("annotationType", new Class[0]).invoke(annotation, new Object[0])).getName();
                            if (annotationName.endsWith(INJECT) || annotationName.endsWith(IN)) {
                                inject = true;
                                try {
                                    optional = (Boolean)annotation.getClass().getMethod("optional", new Class[0]).invoke(annotation, new Object[0]);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                break block17;
                            }
                            if (annotationName.endsWith(NAMED)) {
                                try {
                                    injectName = (String)annotation.getClass().getMethod("value", new Class[0]).invoke(annotation, new Object[0]);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                break block17;
                            }
                            if (!annotationName.endsWith(RESOURCE)) break block17;
                            inject = true;
                            String resourceName = null;
                            try {
                                resourceName = (String)annotation.getClass().getMethod("name", new Class[0]).invoke(annotation, new Object[0]);
                            }
                            catch (Exception e) {
                                this.logWarning(field, e);
                            }
                            if (resourceName != null && !resourceName.equals("")) {
                                injectName = resourceName;
                            }
                        }
                        catch (Exception e1) {
                            this.logWarning(field, e1);
                        }
                    }
                    ++j;
                }
            }
            catch (Exception exception) {}
            if (!inject && injectName.startsWith(this.fieldPrefix)) {
                inject = true;
                injectName = injectName.substring(this.fieldPrefixLength);
            }
            if (inject) {
                processor.processField(field, injectName, optional);
            }
            ++i;
        }
    }

    private ProcessMethodsResult processMethods(Class objectsClass, Processor processor, ProcessMethodsResult result) {
        Method[] methods = objectsClass.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            if (!result.seen(method)) {
                if (this.isPostConstruct(method)) {
                    result.postConstructMethods.add(method);
                } else {
                    String candidateName = method.getName();
                    boolean inject = candidateName.startsWith(this.setMethodPrefix);
                    boolean optional = false;
                    try {
                        Object[] annotations = (Object[])method.getClass().getMethod("getAnnotations", new Class[0]).invoke((Object)method, new Object[0]);
                        int j = 0;
                        while (j < annotations.length) {
                            Object annotation = annotations[j];
                            try {
                                String annotationName = ((Class)annotation.getClass().getMethod("annotationType", new Class[0]).invoke(annotation, new Object[0])).getName();
                                if (annotationName.endsWith(INJECT) || annotationName.endsWith(IN)) {
                                    inject = true;
                                    try {
                                        optional = (Boolean)annotation.getClass().getMethod("optional", new Class[0]).invoke(annotation, new Object[0]);
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                } else if (processor.shouldProcessPostConstruct && annotationName.endsWith(POST_CONSTRUCT)) {
                                    inject = false;
                                    result.postConstructMethods.add(method);
                                } else if (processor.shouldProcessOutMethods && annotationName.endsWith(OUT)) {
                                    inject = false;
                                    result.outMethods.add(method);
                                }
                            }
                            catch (Exception ex) {
                                this.logWarning(method, ex);
                            }
                            ++j;
                        }
                    }
                    catch (Exception exception) {}
                    if (inject) {
                        processor.processMethod(method, optional);
                    }
                }
            }
            ++i;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] safeObjectsCopy() {
        Object[] result;
        int pos = 0;
        List list = this.userObjects;
        synchronized (list) {
            result = new Object[this.userObjects.size()];
            Iterator i = this.userObjects.iterator();
            while (i.hasNext()) {
                WeakReference ref = (WeakReference)i.next();
                Object userObject = ref.get();
                if (userObject == null) {
                    i.remove();
                    continue;
                }
                result[pos] = userObject;
                ++pos;
            }
        }
        if (pos == result.length) {
            return result;
        }
        Object[] tmp = new Object[pos];
        System.arraycopy(result, 0, tmp, 0, pos);
        return tmp;
    }

    protected boolean setField(Object userObject, Field field, Object value) {
        if (value != null && !field.getType().isAssignableFrom(value.getClass())) {
            return false;
        }
        boolean wasAccessible = true;
        if (!field.isAccessible()) {
            field.setAccessible(true);
            wasAccessible = false;
        }
        try {
            try {
                field.set(userObject, value);
            }
            catch (IllegalArgumentException e) {
                this.logWarning(field, e);
                if (!wasAccessible) {
                    field.setAccessible(false);
                }
                return false;
            }
            catch (IllegalAccessException e) {
                this.logWarning(field, e);
                if (!wasAccessible) {
                    field.setAccessible(false);
                }
                return false;
            }
        }
        finally {
            if (!wasAccessible) {
                field.setAccessible(false);
            }
        }
        return true;
    }

    /*
     * Loose catch block
     */
    protected boolean setMethod(Object userObject, Method method, Object value) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length != 1) {
            return false;
        }
        if (value != null && !parameterTypes[0].isAssignableFrom(value.getClass())) {
            return false;
        }
        boolean wasAccessible = true;
        if (!method.isAccessible()) {
            method.setAccessible(true);
            wasAccessible = false;
        }
        try {
            try {
                method.invoke(userObject, value);
            }
            catch (IllegalArgumentException e) {
                this.logWarning(method, e);
                if (!wasAccessible) {
                    method.setAccessible(false);
                }
                return false;
            }
            catch (IllegalAccessException e) {
                this.logWarning(method, e);
                if (!wasAccessible) {
                    method.setAccessible(false);
                }
                return false;
            }
            catch (InvocationTargetException e) {
                this.logWarning(method, e);
                if (!wasAccessible) {
                    method.setAccessible(false);
                }
                return false;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
        }
        finally {
            if (!wasAccessible) {
                method.setAccessible(false);
            }
        }
        return true;
    }

    public String toString() {
        return "InjectionTracker(" + this.context + ')';
    }

    static class ProcessMethodsResult {
        List outMethods = new ArrayList();
        List postConstructMethods = new ArrayList();
        Set seenMethods = new HashSet();

        ProcessMethodsResult() {
        }

        boolean seen(Method method) {
            StringBuffer sig = new StringBuffer();
            sig.append(method.getName());
            Class<?>[] parms = method.getParameterTypes();
            int i = 0;
            while (i < parms.length) {
                sig.append(parms[i]);
                sig.append(',');
                ++i;
            }
            return !this.seenMethods.add(sig.toString());
        }
    }

    private abstract class Processor {
        protected boolean isSetter;
        protected boolean shouldProcessOutMethods = false;
        protected boolean shouldProcessPostConstruct = false;
        protected Object userObject;

        public Processor(boolean isSetter) {
            this.isSetter = isSetter;
        }

        void processField(Field field, String injectName, boolean optional) {
        }

        void processMethod(Method method, boolean optional) {
        }

        void processOutMethod(Method m, String name) {
        }

        void processPostConstructMethod(Method m) {
        }

        public void setObject(Object userObject) {
            this.userObject = userObject;
        }
    }

    private static class PropertyChangeListenerImplementation
    implements PropertyChangeListener {
        private final String name;
        private final IEclipseContext outputContext;

        PropertyChangeListenerImplementation(String name, IEclipseContext outputContext) {
            this.name = name;
            this.outputContext = outputContext;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            this.outputContext.set(this.name, evt.getNewValue());
        }
    }
}

