/*******************************************************************************
 * Copyright (c) 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.e4.core.services.context.spi;

import org.eclipse.e4.core.services.context.IContextFunction;
import org.eclipse.e4.core.services.context.IEclipseContext;

/**
 * The base class for all computed value implementations. Clients may subclass
 * this class. See the class comment of {@link IContextFunction} for specific
 * rules that must be followed by function implementations.
 * <p>
 * This class is intended to be subclassed by clients.
 * </p>
 * @see IContextFunction
 */
public abstract class ContextFunction implements IContextFunction {

	/**
	 * {@inheritDoc}
	 */
	public abstract Object compute(IEclipseContext context, Object[] arguments);

}
