/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.projectVariables;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectVariableProvider;
import org.eclipse.core.runtime.IPath;

public class ParentVariableProvider
implements IProjectVariableProvider {
    public static final String NAME = "PARENT";

    public Object[] getExtensions(String variable, IProject project) {
        LinkedList<String> result = new LinkedList<String>();
        Iterator<String> it = Arrays.asList(project.getPathVariableManager().getPathVariableNames()).iterator();
        while (it.hasNext()) {
            String value = it.next();
            if (value.equals(NAME)) continue;
            result.add("1-" + value);
        }
        return result.toArray();
    }

    public String getValue(String variable, IProject project) {
        int index = variable.indexOf(45);
        if (index == -1 || index == variable.length() - 1) {
            return Messages.parentVariableProvider_noVariableSpecified;
        }
        String countRemaining = variable.substring(index + 1);
        if ((index = countRemaining.indexOf(45)) == -1 || index == variable.length() - 1) {
            return Messages.parentVariableProvider_noVariableSpecified;
        }
        String countString = countRemaining.substring(0, index);
        int count = 0;
        try {
            count = Integer.parseInt(countString);
            if (count < 0) {
                return Messages.parentVariableProvider_noVariableSpecified;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return Messages.parentVariableProvider_noVariableSpecified;
        }
        String argument = countRemaining.substring(index + 1);
        IPath value = project.getPathVariableManager().getValue(argument);
        if (value == null) {
            return null;
        }
        value = project.getPathVariableManager().resolvePath(value);
        value = value.removeLastSegments(count);
        return value.toPortableString();
    }
}

