/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.internal.view.impl;

import org.eclipse.platform.discovery.ui.internal.SlidingComposite;
import org.eclipse.platform.discovery.ui.internal.util.DiscoveryUiUtil;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.ScrollBar;

public class SashOffsetCalculator
implements SlidingComposite.IOffsetCalculator {
    private final SlidingComposite.ORIENTATION currentOrientation;
    private final Sash sash;
    private final boolean upperVisible;
    private final ScrolledComposite scrolledUpperComposite;
    private final Canvas hideButton;
    private final Point paramsSectionSize;

    public SashOffsetCalculator(Sash sash, ScrolledComposite scrolledUpperComposite, Point paramsSectionSize, Canvas hideButton, SlidingComposite.ORIENTATION orientation, Boolean upperPartVisible) {
        this.currentOrientation = orientation;
        this.sash = sash;
        this.upperVisible = upperPartVisible;
        this.scrolledUpperComposite = scrolledUpperComposite;
        this.hideButton = hideButton;
        this.paramsSectionSize = paramsSectionSize;
    }

    @Override
    public int determineDefaultOffest() {
        int offset;
        int paramsSectionSizeValue;
        DiscoveryUiUtil uiUtil = DiscoveryUiUtil.instance();
        int parentSize = uiUtil.getHeightOrWidthDependingOnOrientation((Control)this.sash.getParent(), this.currentOrientation);
        int delta = parentSize - (paramsSectionSizeValue = uiUtil.pointComponent(this.paramsSectionSize, this.currentOrientation)) - this.sashComponentHeight();
        if (delta < this.sashComponentHeight()) {
            offset = parentSize;
        } else {
            offset = paramsSectionSizeValue + this.sashComponentHeight();
            if (this.currentOrientation == SlidingComposite.ORIENTATION.HORIZONTAL && this.scrolledCompositeVerticalBar().isVisible()) {
                offset += this.scrolledCompositeVerticalBar().getSize().x;
            }
        }
        return offset;
    }

    @Override
    public int effectiveOffset(int desiredOffset) {
        int effectiveOffset = 0;
        DiscoveryUiUtil uiUtil = DiscoveryUiUtil.instance();
        Composite sashParent = this.sash.getParent();
        if (this.currentOrientation == SlidingComposite.ORIENTATION.VERTICAL) {
            int maxVerticalOffset = uiUtil.getHeightOrWidthDependingOnOrientation((Control)sashParent, this.currentOrientation) - this.sashComponentHeight();
            effectiveOffset = Math.min(Math.max(Math.min(desiredOffset, maxVerticalOffset), this.sashComponentHeight()), this.paramsSectionSize.y + this.sashComponentHeight());
        } else if (this.upperVisible) {
            int paramsSectionSizeValue = uiUtil.pointComponent(this.paramsSectionSize, this.currentOrientation);
            int verticalBarWidth = this.scrolledCompositeVerticalBar().isVisible() ? this.scrolledCompositeVerticalBar().getSize().x : 0;
            int horizontalOffset = Math.min(paramsSectionSizeValue + this.sashComponentHeight() + verticalBarWidth, desiredOffset);
            effectiveOffset = horizontalOffset = Math.min(horizontalOffset, uiUtil.getHeightOrWidthDependingOnOrientation((Control)sashParent, this.currentOrientation) - 1);
        } else {
            effectiveOffset = this.sashComponentHeight();
        }
        return Math.max(effectiveOffset, this.sashComponentHeight());
    }

    @Override
    public int sashComponentHeight() {
        int buttonSize = DiscoveryUiUtil.instance().getHeightOrWidthDependingOnOrientation((Control)this.hideButton, this.currentOrientation);
        int sashSize = DiscoveryUiUtil.instance().getHeightOrWidthDependingOnOrientation((Control)this.sash, this.currentOrientation);
        return buttonSize + (this.sash.getVisible() ? sashSize : 0) + 1;
    }

    private ScrollBar scrolledCompositeVerticalBar() {
        return this.scrolledUpperComposite.getVerticalBar();
    }
}

