/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.test.unit.internal;

import java.util.List;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.platform.discovery.runtime.internal.xp.impl.AbstractExtensionPointParser;
import org.eclipse.platform.discovery.testutils.utils.registry.ExtensionRegistryBuilder;
import org.eclipse.platform.discovery.testutils.utils.testcases.AbstractExtensionPointParserTest;
import org.eclipse.platform.discovery.ui.api.ISearchResultCustomUiCreator;
import org.eclipse.platform.discovery.ui.internal.selector.ICustomResultUiContributorDescription;
import org.eclipse.platform.discovery.ui.internal.xp.impl.CustomResultUiXpParser;
import org.junit.Assert;
import org.mockito.Mockito;

public class CustomResultUiXpParserTest
extends AbstractExtensionPointParserTest<ICustomResultUiContributorDescription> {
    private static final String CONTRIBUTOR_ID = "mycontributor";
    private static final String SEARCH_PROVIDER_ID = "mysearchprovider";
    private static final String CREATOR_CLASS = "org.eclipse.test.MyUiCreator";
    private ISearchResultCustomUiCreator uiCreator;

    protected AbstractExtensionPointParser<ICustomResultUiContributorDescription> createParser(IExtensionRegistry registry) {
        return new CustomResultUiXpParser(registry);
    }

    protected void setupRegistry(ExtensionRegistryBuilder registryBuilder) {
        this.uiCreator = (ISearchResultCustomUiCreator)Mockito.mock(ISearchResultCustomUiCreator.class);
        registryBuilder.addCustomResultUiContributor(CONTRIBUTOR_ID, SEARCH_PROVIDER_ID, CREATOR_CLASS, this.uiCreator);
    }

    protected void verifyContributions(List<ICustomResultUiContributorDescription> contributions) {
        Assert.assertEquals((String)"One contributor expected", (long)1L, (long)contributions.size());
        ICustomResultUiContributorDescription contributorDescription = contributions.get(0);
        Assert.assertEquals((String)"unexpected id", (Object)CONTRIBUTOR_ID, (Object)contributorDescription.getId());
        Assert.assertEquals((String)"unexpected search provider id", (Object)SEARCH_PROVIDER_ID, (Object)contributorDescription.getSearchProviderId());
        Assert.assertSame((String)"unexpected ui creator", (Object)this.uiCreator, (Object)contributorDescription.createUiCreator());
    }
}

