/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.runtime.internal.persistence.util;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.platform.discovery.runtime.api.persistence.DestinationItemPair;
import org.eclipse.platform.discovery.runtime.api.persistence.IMementoLoadProvider;
import org.eclipse.platform.discovery.runtime.api.persistence.IMementoStoreProvider;
import org.eclipse.platform.discovery.runtime.internal.persistence.impl.XpPersistenceParsersFactory;
import org.eclipse.platform.discovery.runtime.internal.persistence.model.descriptions.IMementoLoadProviderDescription;
import org.eclipse.platform.discovery.runtime.internal.persistence.model.descriptions.IMementoStoreProviderDescription;
import org.eclipse.platform.discovery.runtime.internal.persistence.util.IPersistenceProviderRegistry;
import org.eclipse.ui.IMemento;

public class PersistenceProviderRegistryImpl
implements IPersistenceProviderRegistry {
    private XpPersistenceParsersFactory xpPersistenceFactory = null;
    private Set<IMementoLoadProvider> loadProviderSet = null;
    private Set<IMementoStoreProvider> storeProviderSet = null;

    public PersistenceProviderRegistryImpl() {
        this.updateRegistry();
    }

    @Override
    public final void updateRegistry() {
        this.xpPersistenceFactory = new XpPersistenceParsersFactory();
        this.loadProviderSet = this.collectAllLoadProviders();
        this.storeProviderSet = this.collectAllStoreProviders();
    }

    @Override
    public Set<IMementoLoadProvider> collectAllLoadProviders() {
        HashSet<IMementoLoadProvider> resultSet = new HashSet<IMementoLoadProvider>();
        IMementoLoadProvider resultItem = null;
        List descriptionSet = this.xpPersistenceFactory.createMementoLoadProviderParser().readContributions();
        for (IMementoLoadProviderDescription description : descriptionSet) {
            resultItem = description.createInstance();
            resultSet.add(resultItem);
        }
        return resultSet;
    }

    @Override
    public Set<IMementoStoreProvider> collectAllStoreProviders() {
        HashSet<IMementoStoreProvider> resultSet = new HashSet<IMementoStoreProvider>();
        IMementoStoreProvider resultItem = null;
        List descriptionSet = this.xpPersistenceFactory.createMementoStoreProviderParser().readContributions();
        for (IMementoStoreProviderDescription description : descriptionSet) {
            resultItem = description.createInstance();
            resultSet.add(resultItem);
        }
        return resultSet;
    }

    @Override
    public Set<IMementoLoadProvider> findLoadProviders(IMemento container) {
        HashSet<IMementoLoadProvider> resultSet = new HashSet<IMementoLoadProvider>();
        for (IMementoLoadProvider loadProvider : this.loadProviderSet) {
            if (!loadProvider.canLoad(container)) continue;
            resultSet.add(loadProvider);
        }
        return resultSet;
    }

    @Override
    public Set<IMementoStoreProvider> findStoreProviders(DestinationItemPair pair) {
        HashSet<IMementoStoreProvider> resultSet = new HashSet<IMementoStoreProvider>();
        for (IMementoStoreProvider storeProvider : this.storeProviderSet) {
            if (!storeProvider.canStore(pair)) continue;
            resultSet.add(storeProvider);
        }
        return resultSet;
    }
}

