/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.core.internal.favorites;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.platform.discovery.core.api.ISearchFavoritesMasterController;
import org.eclipse.platform.discovery.core.internal.favorites.IPersistenceUtil;
import org.eclipse.platform.discovery.core.internal.favorites.ISearchFavoritesControllerOutputView;
import org.eclipse.platform.discovery.runtime.api.ISearchDestination;
import org.eclipse.platform.discovery.runtime.api.persistence.DestinationItemPair;
import org.eclipse.platform.discovery.runtime.api.persistence.IDestinationItemPairAdapter;
import org.eclipse.platform.discovery.util.api.env.IDiscoveryEnvironment;

public class SearchFavoritesController
implements ISearchFavoritesMasterController {
    private final ISearchFavoritesControllerOutputView favoritesView;
    private final IDiscoveryEnvironment environment;
    private final IPersistenceUtil persistenceUtil;

    public SearchFavoritesController(ISearchFavoritesControllerOutputView view, IDiscoveryEnvironment env, IPersistenceUtil persistenceUtil) {
        this.favoritesView = view;
        this.environment = env;
        this.persistenceUtil = persistenceUtil;
        this.updateView();
    }

    private void updateView() {
        this.favoritesView.showFavorites(this.loadItems());
    }

    @Override
    public IDiscoveryEnvironment getEnvironment() {
        return this.environment;
    }

    @Override
    public void deleteItems(Set<Object> data) {
        try {
            this.persistenceUtil.deleteItems(data, this.environment.operationRunner());
        }
        catch (Exception e) {
            this.getEnvironment().errorHandler().handleException(e);
        }
        this.updateView();
    }

    @Override
    public void importData(Object data) {
        DestinationItemPair[] pairs;
        if (data == null) {
            this.favoritesView.showUnsupportedContentWindow();
            return;
        }
        try {
            pairs = this.toPairs(data);
        }
        catch (Exception e) {
            this.environment.errorHandler().handleException(e);
            return;
        }
        if (pairs == null) {
            this.favoritesView.showUnsupportedContentWindow();
            return;
        }
        if (pairs.length == 0) {
            this.favoritesView.showNoContentFoundWindow();
            return;
        }
        this.saveInFavorites(pairs);
        this.updateView();
    }

    private DestinationItemPair[] toPairs(Object data) {
        if (data instanceof DestinationItemPair[]) {
            return (DestinationItemPair[])data;
        }
        return this.adaptToPairs(data);
    }

    private DestinationItemPair[] adaptToPairs(Object data) {
        IDestinationItemPairAdapter adapter = this.adapterFor(data);
        if (adapter == null) {
            return null;
        }
        DestinationItemPair[] pairs = adapter.adapt(this.environment.operationRunner());
        return pairs;
    }

    @Override
    public boolean isImportPossible(Object data) {
        return this.adapterFor(data) != null;
    }

    private void saveInFavorites(DestinationItemPair[] pairs) {
        Map<ISearchDestination, Set<DestinationItemPair>> destinationsMap = this.groupByDestination(pairs);
        try {
            for (ISearchDestination searchDestination : destinationsMap.keySet()) {
                this.persistenceUtil.addItems(destinationsMap.get(searchDestination), this.environment.operationRunner());
            }
        }
        catch (Exception e) {
            this.getEnvironment().errorHandler().handleException(e);
        }
    }

    private Map<ISearchDestination, Set<DestinationItemPair>> groupByDestination(DestinationItemPair[] pairs) {
        HashMap<ISearchDestination, Set<DestinationItemPair>> destinationsMap = new HashMap<ISearchDestination, Set<DestinationItemPair>>();
        DestinationItemPair[] destinationItemPairArray = pairs;
        int n = pairs.length;
        int n2 = 0;
        while (n2 < n) {
            DestinationItemPair importedData = destinationItemPairArray[n2];
            ISearchDestination destination = importedData.getDestination();
            if (!destinationsMap.containsKey(destination)) {
                destinationsMap.put(destination, new HashSet());
            }
            ((Set)destinationsMap.get(destination)).add(importedData);
            ++n2;
        }
        return destinationsMap;
    }

    private IDestinationItemPairAdapter adapterFor(Object object) {
        IDestinationItemPairAdapter adapter = (IDestinationItemPairAdapter)this.getAdapterManager().getAdapter(object, IDestinationItemPairAdapter.class);
        return adapter == null ? (IDestinationItemPairAdapter)this.getAdapterManager().loadAdapter(object, IDestinationItemPairAdapter.class.getName()) : adapter;
    }

    protected IAdapterManager getAdapterManager() {
        return Platform.getAdapterManager();
    }

    private Set<Object> loadItems() {
        HashSet<Object> loadedItems = new HashSet<Object>();
        try {
            for (DestinationItemPair pair : this.persistenceUtil.loadItems(this.getEnvironment().operationRunner())) {
                loadedItems.add(pair.getItem());
            }
        }
        catch (Exception e) {
            this.getEnvironment().errorHandler().handleException(e);
            return Collections.emptySet();
        }
        return loadedItems;
    }
}

