/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.core.test.unit.internal;

import org.eclipse.platform.discovery.core.test.unit.internal.SearchFavoritesControllerTestFixture;
import org.eclipse.platform.discovery.runtime.api.persistence.DestinationItemPair;
import org.eclipse.platform.discovery.runtime.api.persistence.IDestinationItemPairAdapter;
import org.eclipse.platform.discovery.testutils.utils.jmock.Mock;
import org.eclipse.platform.discovery.testutils.utils.jmock.MockObjectTestCase;
import org.eclipse.platform.discovery.util.api.longop.ILongOperationRunner;
import org.jmock.core.Constraint;

public class SearchFavoritesControllerImportDataFailedTest
extends MockObjectTestCase {
    private final Object optimisticallyAllowed = new Object();
    private final Object completelyDenied = new Object();
    protected SearchFavoritesControllerTestFixture fixture;
    private Mock<IDestinationItemPairAdapter> adapter;

    protected void setUp() throws Exception {
        this.fixture = new SearchFavoritesControllerTestFixture(this);
        this.fixture.adapterManager.stubs().method("getAdapter").with((Constraint)this.same(this.completelyDenied), (Constraint)this.same(IDestinationItemPairAdapter.class)).will(this.returnValue(null));
        this.fixture.adapterManager.stubs().method("loadAdapter").with((Constraint)this.same(this.completelyDenied), (Constraint)this.same(IDestinationItemPairAdapter.class.getName())).will(this.returnValue(null));
        this.adapter = this.mock(IDestinationItemPairAdapter.class);
        this.fixture.adapterManager.stubs().method("getAdapter").with((Constraint)this.same(this.optimisticallyAllowed), (Constraint)this.same(IDestinationItemPairAdapter.class)).will(this.returnValue(this.adapter.proxy()));
    }

    public void testImportData_OptimisticCheckFailed() {
        this.fixture.favoritesView.expects(this.once()).method("showUnsupportedContentWindow");
        this.fixture.controller.importData(this.completelyDenied);
    }

    public void testImportData_RealImportFailed() {
        this.adapter.stubs().method("adapt").with((Constraint)this.isA(ILongOperationRunner.class)).will(this.returnValue(null));
        this.fixture.favoritesView.expects(this.once()).method("showUnsupportedContentWindow");
        this.fixture.controller.importData(this.optimisticallyAllowed);
    }

    public void testImportDataWithEmptyArray() {
        this.adapter.stubs().method("adapt").with((Constraint)this.isA(ILongOperationRunner.class)).will(this.returnValue(new DestinationItemPair[0]));
        this.fixture.favoritesView.expects(this.once()).method("showNoContentFoundWindow");
        this.fixture.controller.importData(this.optimisticallyAllowed);
    }

    public void testImportDataWithException() {
        RuntimeException e = new RuntimeException();
        this.fixture.adapterManager.stubs().method("getAdapter").with((Constraint)this.same(this.optimisticallyAllowed), (Constraint)this.same(IDestinationItemPairAdapter.class)).will(this.throwException(e));
        this.fixture.errorHandler.expects(this.once()).method("handleException").with((Constraint)this.same(e));
        this.fixture.controller.importData(this.optimisticallyAllowed);
    }
}

