/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.examples.databinding.snippets;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.IBeanValueProperty;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.Properties;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.CellEditorProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapCellLabelProvider;
import org.eclipse.jface.databinding.viewers.ObservableValueEditingSupport;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class Snippet032TableViewerColumnEditing {
    public static void main(String[] args) {
        final Display display = new Display();
        Realm.runWithDefault((Realm)SWTObservables.getRealm((Display)display), (Runnable)new Runnable(){

            public void run() {
                ViewModel viewModel = new ViewModel();
                Shell shell = new View(viewModel).createShell();
                while (!shell.isDisposed()) {
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
            }
        });
    }

    public static abstract class AbstractModelObject {
        private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.propertyChangeSupport.addPropertyChangeListener(listener);
        }

        public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.propertyChangeSupport.removePropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
        }

        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    static class Person
    extends AbstractModelObject {
        String name;
        String firstName;

        public Person(String firstName, String name) {
            this.name = name;
            this.firstName = firstName;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
            this.firePropertyChange("name", this.name, this.name);
        }

        public String getFirstName() {
            return this.firstName;
        }

        public void setFirstName(String firstName) {
            this.firstName = firstName;
            this.firePropertyChange("firstName", this.firstName, this.firstName);
        }
    }

    static class View {
        private ViewModel viewModel;
        private Table committers;
        private Label selectedCommitterName;
        private Label selectedCommitterFirstName;

        public View(ViewModel viewModel) {
            this.viewModel = viewModel;
        }

        public Shell createShell() {
            Display display = Display.getDefault();
            Shell shell = new Shell(display);
            shell.setLayout((Layout)new GridLayout(2, true));
            this.committers = new Table((Composite)shell, 67584);
            this.committers.setLinesVisible(true);
            this.committers.setHeaderVisible(true);
            GridData layoutData = new GridData(4, 4, true, true);
            layoutData.horizontalSpan = 2;
            this.committers.setLayoutData((Object)layoutData);
            GridData fieldLayoutData = new GridData(4, 1, true, false);
            this.selectedCommitterName = new Label((Composite)shell, 0);
            this.selectedCommitterName.setLayoutData((Object)fieldLayoutData);
            this.selectedCommitterFirstName = new Label((Composite)shell, 0);
            this.selectedCommitterFirstName.setLayoutData((Object)fieldLayoutData);
            DataBindingContext bindingContext = new DataBindingContext();
            this.bindGUI(bindingContext);
            shell.setSize(250, 300);
            shell.open();
            return shell;
        }

        protected void bindGUI(DataBindingContext bindingContext) {
            TableViewer peopleViewer = new TableViewer(this.committers);
            TableViewerColumn columnName = new TableViewerColumn(peopleViewer, 0);
            columnName.getColumn().setText("Name");
            columnName.getColumn().setWidth(100);
            TableViewerColumn columnFirstName = new TableViewerColumn(peopleViewer, 0);
            columnFirstName.getColumn().setText("FirstName");
            columnFirstName.getColumn().setWidth(100);
            IBeanValueProperty propName = BeanProperties.value(Person.class, (String)"name");
            IBeanValueProperty propFirstname = BeanProperties.value(Person.class, (String)"firstName");
            IValueProperty cellEditorControlText = CellEditorProperties.control().value((IValueProperty)WidgetProperties.text());
            columnName.setEditingSupport(ObservableValueEditingSupport.create((ColumnViewer)peopleViewer, (DataBindingContext)bindingContext, (CellEditor)new TextCellEditor((Composite)this.committers), (IValueProperty)cellEditorControlText, (IValueProperty)propName));
            columnFirstName.setEditingSupport(ObservableValueEditingSupport.create((ColumnViewer)peopleViewer, (DataBindingContext)bindingContext, (CellEditor)new TextCellEditor((Composite)this.committers), (IValueProperty)cellEditorControlText, (IValueProperty)propFirstname));
            ObservableListContentProvider contentProvider = new ObservableListContentProvider();
            peopleViewer.setContentProvider((IContentProvider)contentProvider);
            IObservableMap[] result = Properties.observeEach((IObservableSet)contentProvider.getKnownElements(), (IValueProperty[])new IBeanValueProperty[]{propName, propFirstname});
            columnName.setLabelProvider((CellLabelProvider)new ObservableMapCellLabelProvider(result[0]));
            columnFirstName.setLabelProvider((CellLabelProvider)new ObservableMapCellLabelProvider(result[1]));
            peopleViewer.setInput((Object)new WritableList(this.viewModel.getPeople(), Person.class));
            IViewerObservableValue selection = ViewersObservables.observeSingleSelection((Viewer)peopleViewer);
            bindingContext.bindValue((IObservableValue)SWTObservables.observeText((Label)this.selectedCommitterName), BeansObservables.observeDetailValue((IObservableValue)selection, (String)"name", String.class));
            bindingContext.bindValue((IObservableValue)SWTObservables.observeText((Label)this.selectedCommitterFirstName), BeansObservables.observeDetailValue((IObservableValue)selection, (String)"firstName", String.class));
        }
    }

    static class ViewModel {
        private List people = new LinkedList();

        ViewModel() {
            this.people.add(new Person("Dave", "Orme"));
            this.people.add(new Person("Gili", "Mendel"));
            this.people.add(new Person("Joe", "Winchester"));
            this.people.add(new Person("Boris", "Bokowski"));
            this.people.add(new Person("Brad", "Reynolds"));
            this.people.add(new Person("Matthew", "Hall"));
        }

        public List getPeople() {
            return this.people;
        }
    }
}

