/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.examples.databinding.snippets;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewerSupport;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class Snippet017TableViewerWithDerivedColumns {
    private static Person UNKNOWN = new Person("unknown", null, null);

    public static void main(String[] args) {
        final Display display = new Display();
        Realm.runWithDefault((Realm)SWTObservables.getRealm((Display)display), (Runnable)new Runnable(){

            public void run() {
                ViewModel viewModel = new ViewModel();
                Shell shell = new View(viewModel).createShell();
                while (!shell.isDisposed()) {
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
            }
        });
    }

    public static abstract class AbstractModelObject {
        private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.propertyChangeSupport.addPropertyChangeListener(listener);
        }

        public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.propertyChangeSupport.removePropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
        }

        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    static class Person
    extends AbstractModelObject {
        String name = "Donald Duck";
        Person mother;
        Person father;

        public Person(String name, Person mother, Person father) {
            this.name = name;
            this.mother = mother;
            this.father = father;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            String oldValue = this.name;
            this.name = name;
            this.firePropertyChange("name", oldValue, name);
        }

        public Person getMother() {
            return this.mother;
        }

        public void setMother(Person mother) {
            this.mother = mother;
            this.firePropertyChange("mother", this.mother, this.mother);
        }

        public Person getFather() {
            return this.father;
        }

        public void setFather(Person father) {
            this.father = father;
            this.firePropertyChange("father", this.father, this.father);
        }

        public String toString() {
            return this.name;
        }
    }

    static class View {
        private ViewModel viewModel;
        private Table duckFamily;
        private Text nameText;
        private Combo motherCombo;
        private Combo fatherCombo;

        public View(ViewModel viewModel) {
            this.viewModel = viewModel;
        }

        public Shell createShell() {
            Display display = Display.getDefault();
            Shell shell = new Shell(display);
            this.duckFamily = new Table((Composite)shell, 67584);
            this.duckFamily.setHeaderVisible(true);
            GridDataFactory.defaultsFor((Control)this.duckFamily).span(2, 1).applyTo((Control)this.duckFamily);
            this.createColumn("Name");
            this.createColumn("Mother");
            this.createColumn("Father");
            this.createColumn("Grandmother");
            this.duckFamily.setLinesVisible(true);
            new Label((Composite)shell, 0).setText("Name:");
            this.nameText = new Text((Composite)shell, 2048);
            GridDataFactory.defaultsFor((Control)this.nameText).grab(true, false).applyTo((Control)this.nameText);
            new Label((Composite)shell, 0).setText("Mother:");
            this.motherCombo = new Combo((Composite)shell, 8);
            new Label((Composite)shell, 0).setText("Father:");
            this.fatherCombo = new Combo((Composite)shell, 8);
            DataBindingContext bindingContext = new DataBindingContext();
            this.bindGUI(bindingContext);
            GridLayoutFactory.swtDefaults().numColumns(2).applyTo((Composite)shell);
            shell.setSize(500, 300);
            shell.open();
            return shell;
        }

        private void createColumn(String string) {
            TableColumn column = new TableColumn(this.duckFamily, 0);
            column.setWidth(100);
            column.setText(string);
        }

        protected void bindGUI(DataBindingContext bindingContext) {
            TableViewer peopleViewer = new TableViewer(this.duckFamily);
            peopleViewer.addFilter(new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    return element != UNKNOWN;
                }
            });
            ViewerSupport.bind((StructuredViewer)peopleViewer, (IObservableList)this.viewModel.getPeople(), (IValueProperty[])BeanProperties.values((String[])new String[]{"name", "mother.name", "father.name", "mother.mother.name"}));
            IViewerObservableValue selection = ViewersObservables.observeSingleSelection((Viewer)peopleViewer);
            bindingContext.bindValue((IObservableValue)SWTObservables.observeText((Text)this.nameText, (int)24), BeansObservables.observeDetailValue((IObservableValue)selection, (String)"name", String.class));
            ComboViewer mothercomboViewer = new ComboViewer(this.motherCombo);
            ViewerSupport.bind((StructuredViewer)mothercomboViewer, (IObservableList)this.viewModel.getPeople(), (IValueProperty)BeanProperties.value((String)"name"));
            bindingContext.bindValue((IObservableValue)ViewersObservables.observeSingleSelection((Viewer)mothercomboViewer), BeansObservables.observeDetailValue((IObservableValue)selection, (String)"mother", Person.class));
            ComboViewer fatherComboViewer = new ComboViewer(this.fatherCombo);
            ViewerSupport.bind((StructuredViewer)fatherComboViewer, (IObservableList)this.viewModel.getPeople(), (IValueProperty)BeanProperties.value((String)"name"));
            bindingContext.bindValue((IObservableValue)ViewersObservables.observeSingleSelection((Viewer)fatherComboViewer), BeansObservables.observeDetailValue((IObservableValue)selection, (String)"father", Person.class));
        }
    }

    static class ViewModel {
        private IObservableList people = new WritableList();

        ViewModel() {
            Person fergus = new Person("Fergus McDuck", UNKNOWN, UNKNOWN);
            Person downy = new Person("Downy O'Drake", UNKNOWN, UNKNOWN);
            Person scrooge = new Person("Scrooge McDuck", downy, fergus);
            Person hortense = new Person("Hortense McDuck", downy, fergus);
            Person quackmore = new Person("Quackmore Duck", UNKNOWN, UNKNOWN);
            Person della = new Person("Della Duck", hortense, quackmore);
            Person donald = new Person("Donald Duck", hortense, quackmore);
            donald.setFather(quackmore);
            donald.setMother(hortense);
            della.setFather(quackmore);
            della.setMother(hortense);
            hortense.setMother(downy);
            hortense.setFather(fergus);
            scrooge.setMother(downy);
            scrooge.setFather(fergus);
            this.people.add((Object)UNKNOWN);
            this.people.add((Object)downy);
            this.people.add((Object)fergus);
            this.people.add((Object)scrooge);
            this.people.add((Object)quackmore);
            this.people.add((Object)hortense);
            this.people.add((Object)della);
            this.people.add((Object)donald);
        }

        public IObservableList getPeople() {
            return this.people;
        }
    }
}

