/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.examples.databinding.mask.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.examples.databinding.mask.internal.WorkQueue;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class SWTUtil {
    private static Map mapDisplayOntoWorkQueue = new HashMap();

    private SWTUtil() {
    }

    public static void greedyExec(Display d, Runnable r) {
        if (d.isDisposed()) {
            return;
        }
        WorkQueue queue = SWTUtil.getQueueFor(d);
        queue.asyncExec(r);
    }

    public static void runOnce(Display d, Runnable r) {
        if (d.isDisposed()) {
            return;
        }
        WorkQueue queue = SWTUtil.getQueueFor(d);
        queue.runOnce(r);
    }

    public static void cancelExec(Display d, Runnable r) {
        if (d.isDisposed()) {
            return;
        }
        WorkQueue queue = SWTUtil.getQueueFor(d);
        queue.cancelExec(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WorkQueue getQueueFor(final Display d) {
        Map map = mapDisplayOntoWorkQueue;
        synchronized (map) {
            WorkQueue result = (WorkQueue)mapDisplayOntoWorkQueue.get(d);
            if (result == null) {
                final WorkQueue q = result = new WorkQueue(d);
                mapDisplayOntoWorkQueue.put(d, result);
                d.asyncExec(new Runnable(){

                    public void run() {
                        d.disposeExec(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run() {
                                Map map = mapDisplayOntoWorkQueue;
                                synchronized (map) {
                                    q.cancelAll();
                                    mapDisplayOntoWorkQueue.remove(d);
                                }
                            }
                        });
                    }
                });
            }
            return result;
        }
    }

    public static RGB mix(RGB rgb1, RGB rgb2, double ratio) {
        return new RGB(SWTUtil.interp(rgb1.red, rgb2.red, ratio), SWTUtil.interp(rgb1.green, rgb2.green, ratio), SWTUtil.interp(rgb1.blue, rgb2.blue, ratio));
    }

    private static int interp(int i1, int i2, double ratio) {
        int result = (int)((double)i1 * ratio + (double)i2 * (1.0 - ratio));
        if (result < 0) {
            result = 0;
        }
        if (result > 255) {
            result = 255;
        }
        return result;
    }
}

