/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.internal.theme;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.ui.css.core.engine.CSSElementContext;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.core.util.impl.resources.FileResourcesLocatorImpl;
import org.eclipse.e4.ui.css.core.util.impl.resources.OSGiResourceLocator;
import org.eclipse.e4.ui.css.core.util.resources.IResourceLocator;
import org.eclipse.e4.ui.css.swt.helpers.EclipsePreferencesHelper;
import org.eclipse.e4.ui.css.swt.internal.theme.Theme;
import org.eclipse.e4.ui.css.swt.theme.ITheme;
import org.eclipse.e4.ui.css.swt.theme.IThemeEngine;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.prefs.BackingStoreException;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSStyleDeclaration;

public class ThemeEngine
implements IThemeEngine {
    private List<Theme> themes = new ArrayList<Theme>();
    private List<CSSEngine> cssEngines = new ArrayList<CSSEngine>();
    private Display display;
    private ITheme currentTheme;
    private List<String> globalStyles = new ArrayList<String>();
    private List<IResourceLocator> globalSourceLocators = new ArrayList<IResourceLocator>();
    private HashMap<String, List<String>> stylesheets = new HashMap();
    private HashMap<String, List<String>> modifiedStylesheets = new HashMap();
    private HashMap<String, List<IResourceLocator>> sourceLocators = new HashMap();
    private static final String THEMEID_KEY = "themeid";
    public static final String THEME_PLUGIN_ID = "org.eclipse.e4.ui.css.swt.theme";

    public ThemeEngine(Display display) {
        IConfigurationElement ce;
        int n;
        int n2;
        IConfigurationElement[] iConfigurationElementArray;
        IExtension e;
        int n3;
        File done;
        File oldModDir;
        this.display = display;
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        IExtensionPoint extPoint = registry.getExtensionPoint(THEME_PLUGIN_ID);
        Location configLocation = Platform.getConfigurationLocation();
        String e4CSSPath = null;
        try {
            URL locationURL = new URL(configLocation.getDataArea(THEME_PLUGIN_ID).toString());
            File locationFile = new File(locationURL.getFile());
            e4CSSPath = locationFile.getPath();
        }
        catch (IOException iOException) {}
        Path path = new Path(String.valueOf(e4CSSPath) + System.getProperty("file.separator"));
        File modDir = new File(path.toFile().toURI());
        if (!modDir.exists()) {
            modDir.mkdirs();
        }
        if ((oldModDir = new File(String.valueOf(System.getProperty("user.home")) + System.getProperty("file.separator") + ".e4css" + System.getProperty("file.separator"))).exists() && !(done = new File(oldModDir, ".processed")).exists()) {
            try {
                File[] oldModifiedFiles;
                done.createNewFile();
                File[] fileArray = oldModifiedFiles = oldModDir.listFiles();
                int n4 = oldModifiedFiles.length;
                n3 = 0;
                while (n3 < n4) {
                    File oldModifiedFile = fileArray[n3];
                    if (oldModifiedFile.getName().contains(".css")) {
                        this.copyFile(oldModifiedFile.getPath(), path + System.getProperty("file.separator") + oldModifiedFile.getName());
                    }
                    ++n3;
                }
            }
            catch (IOException iOException) {}
        }
        File[] modifiedFiles = modDir.listFiles();
        IExtension[] iExtensionArray = extPoint.getExtensions();
        n3 = iExtensionArray.length;
        int n5 = 0;
        while (n5 < n3) {
            e = iExtensionArray[n5];
            iConfigurationElementArray = this.getPlatformMatches(e.getConfigurationElements());
            n2 = iConfigurationElementArray.length;
            n = 0;
            while (n < n2) {
                ce = iConfigurationElementArray[n];
                if (ce.getName().equals("theme")) {
                    try {
                        int slash;
                        String originalCSSFile;
                        String basestylesheeturi;
                        String version = ce.getAttribute("os_version");
                        if (version == null) {
                            version = "";
                        }
                        if (!(basestylesheeturi = (originalCSSFile = ce.getAttribute("basestylesheeturi"))).startsWith("platform:/plugin/")) {
                            basestylesheeturi = "platform:/plugin/" + ce.getContributor().getName() + "/" + basestylesheeturi;
                        }
                        String themeId = String.valueOf(ce.getAttribute("id")) + version;
                        this.registerTheme(themeId, ce.getAttribute("label"), basestylesheeturi, version);
                        if (modifiedFiles != null && (slash = originalCSSFile.lastIndexOf("/")) != -1) {
                            originalCSSFile = originalCSSFile.substring(slash + 1);
                            File[] fileArray = modifiedFiles;
                            int n6 = modifiedFiles.length;
                            int n7 = 0;
                            while (n7 < n6) {
                                File modifiedFile = fileArray[n7];
                                String modifiedFileName = modifiedFile.getName();
                                if (modifiedFileName.contains(".css") && modifiedFileName.equals(originalCSSFile)) {
                                    ArrayList<String> styleSheets = new ArrayList<String>();
                                    styleSheets.add(modifiedFile.toURI().toString());
                                    this.modifiedStylesheets.put(themeId, styleSheets);
                                }
                                ++n7;
                            }
                        }
                    }
                    catch (IllegalArgumentException e1) {
                        e1.printStackTrace();
                    }
                }
                ++n;
            }
            ++n5;
        }
        iExtensionArray = extPoint.getExtensions();
        n3 = iExtensionArray.length;
        n5 = 0;
        while (n5 < n3) {
            e = iExtensionArray[n5];
            iConfigurationElementArray = this.getPlatformMatches(e.getConfigurationElements());
            n2 = iConfigurationElementArray.length;
            n = 0;
            while (n < n2) {
                ce = iConfigurationElementArray[n];
                if (ce.getName().equals("stylesheet")) {
                    int n8;
                    IConfigurationElement[] cces = ce.getChildren(THEMEID_KEY);
                    if (cces.length == 0) {
                        this.registerStylesheet("platform:/plugin/" + ce.getContributor().getName() + "/" + ce.getAttribute("uri"), new String[0]);
                        IConfigurationElement[] iConfigurationElementArray2 = ce.getChildren("osgiresourcelocator");
                        n8 = iConfigurationElementArray2.length;
                        int basestylesheeturi = 0;
                        while (basestylesheeturi < n8) {
                            IConfigurationElement resourceEl = iConfigurationElementArray2[basestylesheeturi];
                            String uri = resourceEl.getAttribute("uri");
                            if (uri != null) {
                                this.registerResourceLocator((IResourceLocator)new OSGiResourceLocator(uri), new String[0]);
                            }
                            ++basestylesheeturi;
                        }
                    } else {
                        String[] themes = new String[cces.length];
                        int i = 0;
                        while (i < cces.length) {
                            themes[i] = cces[i].getAttribute("refid");
                            ++i;
                        }
                        this.registerStylesheet("platform:/plugin/" + ce.getContributor().getName() + "/" + ce.getAttribute("uri"), themes);
                        IConfigurationElement[] iConfigurationElementArray3 = ce.getChildren("osgiresourcelocator");
                        int n9 = iConfigurationElementArray3.length;
                        n8 = 0;
                        while (n8 < n9) {
                            IConfigurationElement resourceEl = iConfigurationElementArray3[n8];
                            String uri = resourceEl.getAttribute("uri");
                            if (uri != null) {
                                this.registerResourceLocator((IResourceLocator)new OSGiResourceLocator(uri), new String[0]);
                            }
                            ++n8;
                        }
                    }
                }
                ++n;
            }
            ++n5;
        }
        this.registerResourceLocator((IResourceLocator)new OSGiResourceLocator("platform:/plugin/org.eclipse.ui.themes/css/"), new String[0]);
        this.registerResourceLocator((IResourceLocator)new FileResourcesLocatorImpl(), new String[0]);
    }

    @Override
    public synchronized ITheme registerTheme(String id, String label, String basestylesheetURI) throws IllegalArgumentException {
        return this.registerTheme(id, label, basestylesheetURI, "");
    }

    public synchronized ITheme registerTheme(String id, String label, String basestylesheetURI, String osVersion) throws IllegalArgumentException {
        for (Theme t : this.themes) {
            if (!t.getId().equals(id)) continue;
            throw new IllegalArgumentException("A theme with the id '" + id + "' is already registered");
        }
        Theme theme = new Theme(id, label);
        if (osVersion != "") {
            theme.setOsVersion(osVersion);
        }
        this.themes.add(theme);
        this.registerStyle(id, basestylesheetURI);
        return theme;
    }

    @Override
    public synchronized void registerStylesheet(String uri, String ... themes) {
        Bundle bundle = FrameworkUtil.getBundle(ThemeEngine.class);
        String osname = bundle.getBundleContext().getProperty("osgi.os");
        String wsname = bundle.getBundleContext().getProperty("osgi.ws");
        uri = uri.replaceAll("\\$os\\$", osname).replaceAll("\\$ws\\$", wsname);
        if (themes.length == 0) {
            this.globalStyles.add(uri);
        } else {
            String[] stringArray = themes;
            int n = themes.length;
            int n2 = 0;
            while (n2 < n) {
                String t = stringArray[n2];
                this.registerStyle(t, uri);
                ++n2;
            }
        }
    }

    @Override
    public synchronized void registerResourceLocator(IResourceLocator locator, String ... themes) {
        if (themes.length == 0) {
            this.globalSourceLocators.add(locator);
        } else {
            String[] stringArray = themes;
            int n = themes.length;
            int n2 = 0;
            while (n2 < n) {
                String t = stringArray[n2];
                List<IResourceLocator> list = this.sourceLocators.get(t);
                if (list == null) {
                    list = new ArrayList<IResourceLocator>();
                    this.sourceLocators.put(t, list);
                }
                list.add(locator);
                ++n2;
            }
        }
    }

    private void registerStyle(String id, String stylesheet) {
        List<String> s = this.stylesheets.get(id);
        if (s == null) {
            s = new ArrayList<String>();
            this.stylesheets.put(id, s);
        }
        s.add(stylesheet);
    }

    private List<String> getAllStyles(String id) {
        List<String> m = this.modifiedStylesheets.get(id);
        if (m != null) {
            m = new ArrayList<String>(m);
            m.addAll(this.globalStyles);
            return m;
        }
        List<String> s = this.stylesheets.get(id);
        if (s == null) {
            s = Collections.emptyList();
        }
        s = new ArrayList<String>(s);
        s.addAll(this.globalStyles);
        return s;
    }

    private List<IResourceLocator> getResourceLocators(String id) {
        ArrayList<IResourceLocator> list = new ArrayList<IResourceLocator>(this.globalSourceLocators);
        List<IResourceLocator> s = this.sourceLocators.get(id);
        if (s != null) {
            list.addAll(s);
        }
        return list;
    }

    private IConfigurationElement[] getPlatformMatches(IConfigurationElement[] elements) {
        Bundle bundle = FrameworkUtil.getBundle(ThemeEngine.class);
        String osname = bundle.getBundleContext().getProperty("osgi.os");
        String wsname = bundle.getBundleContext().getProperty("ogsi.ws");
        ArrayList<IConfigurationElement> matchingElements = new ArrayList<IConfigurationElement>();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String elementOs = element.getAttribute("os");
            String elementWs = element.getAttribute("ws");
            if (osname != null && (elementOs == null || elementOs.contains(osname))) {
                matchingElements.add(element);
            } else if (wsname != null && wsname.equalsIgnoreCase(elementWs)) {
                matchingElements.add(element);
            }
            ++n2;
        }
        return matchingElements.toArray(new IConfigurationElement[matchingElements.size()]);
    }

    @Override
    public void setTheme(String themeId, boolean restore) {
        String osVersion = System.getProperty("os.version");
        if (osVersion != null) {
            boolean found = false;
            block0: for (Theme t : this.themes) {
                String[] osVersions;
                String osVersionList = t.getOsVersion();
                if (osVersionList == null) continue;
                String[] stringArray = osVersions = osVersionList.split(",");
                int n = osVersions.length;
                int n2 = 0;
                while (n2 < n) {
                    String osVersionFromTheme = stringArray[n2];
                    if (osVersionFromTheme != null && osVersion.contains(osVersionFromTheme)) {
                        String themeVersion = String.valueOf(themeId) + osVersionList;
                        if (t.getId().equals(themeVersion)) {
                            this.setTheme(t, restore);
                            found = true;
                            continue block0;
                        }
                    }
                    ++n2;
                }
            }
            if (found) {
                return;
            }
        }
        for (Theme t : this.themes) {
            if (!t.getId().equals(themeId)) continue;
            this.setTheme(t, restore);
            break;
        }
    }

    @Override
    public void setTheme(ITheme theme, boolean restore) {
        this.setTheme(theme, restore, false);
    }

    public void setTheme(ITheme theme, boolean restore, boolean force) {
        Assert.isNotNull((Object)theme, (String)"The theme must not be null");
        if (this.currentTheme != theme || force) {
            if (this.currentTheme != null) {
                for (IResourceLocator l : this.getResourceLocators(this.currentTheme.getId())) {
                    for (CSSEngine engine : this.cssEngines) {
                        engine.getResourcesLocatorManager().unregisterResourceLocator(l);
                    }
                }
            }
            this.currentTheme = theme;
            for (CSSEngine engine : this.cssEngines) {
                engine.reset();
            }
            for (IResourceLocator l : this.getResourceLocators(theme.getId())) {
                for (CSSEngine engine : this.cssEngines) {
                    engine.getResourcesLocatorManager().registerResourceLocator(l);
                }
            }
            for (String stylesheet : this.getAllStyles(theme.getId())) {
                InputStream stream = null;
                try {
                    URL url = FileLocator.resolve((URL)new URL(stylesheet.toString()));
                    for (CSSEngine engine : this.cssEngines) {
                        try {
                            try {
                                stream = url.openStream();
                                InputSource source = new InputSource();
                                source.setByteStream(stream);
                                source.setURI(url.toString());
                                engine.parseStyleSheet(source);
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                                if (stream == null) continue;
                                try {
                                    stream.close();
                                }
                                catch (IOException e2) {
                                    e2.printStackTrace();
                                }
                                continue;
                            }
                        }
                        catch (Throwable throwable) {
                            if (stream != null) {
                                try {
                                    stream.close();
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                            throw throwable;
                        }
                        if (stream == null) continue;
                        try {
                            stream.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (restore) {
            IEclipsePreferences pref = this.getPreferences();
            EclipsePreferencesHelper.setPreviousThemeId((String)pref.get(THEMEID_KEY, null));
            EclipsePreferencesHelper.setCurrentThemeId((String)theme.getId());
            pref.put(THEMEID_KEY, theme.getId());
            try {
                pref.flush();
            }
            catch (BackingStoreException e) {
                e.printStackTrace();
            }
        }
        this.sendThemeChangeEvent(restore);
        for (CSSEngine engine : this.cssEngines) {
            engine.reapply();
        }
    }

    private void sendThemeChangeEvent(boolean restore) {
        EventAdmin eventAdmin = this.getEventAdmin();
        if (eventAdmin == null) {
            return;
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("themeEngine", this);
        data.put("theme", this.currentTheme);
        data.put("device", this.display);
        data.put("restore", restore);
        Event event = new Event("org/eclipse/e4/ui/css/swt/theme/ThemeManager/themeChanged", data);
        eventAdmin.sendEvent(event);
    }

    public List<IResourceLocator> getCurrentResourceLocators() {
        if (this.currentTheme == null) {
            return Collections.emptyList();
        }
        return this.getResourceLocators(this.currentTheme.getId());
    }

    private EventAdmin getEventAdmin() {
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        if (bundle == null) {
            return null;
        }
        BundleContext context = bundle.getBundleContext();
        ServiceReference eventAdminRef = context.getServiceReference(EventAdmin.class);
        return (EventAdmin)context.getService(eventAdminRef);
    }

    @Override
    public synchronized List<ITheme> getThemes() {
        return Collections.unmodifiableList(new ArrayList<Theme>(this.themes));
    }

    @Override
    public void applyStyles(Object widget, boolean applyStylesToChildNodes) {
        for (CSSEngine engine : this.cssEngines) {
            Element element = engine.getElement(widget);
            if (element == null) continue;
            engine.applyStyles((Object)element, applyStylesToChildNodes);
        }
    }

    private String getPreferenceThemeId() {
        return this.getPreferences().get(THEMEID_KEY, null);
    }

    private IEclipsePreferences getPreferences() {
        return new InstanceScope().getNode(FrameworkUtil.getBundle(ThemeEngine.class).getSymbolicName());
    }

    void copyFile(String from, String to) throws IOException {
        FileInputStream fStream = null;
        FilterOutputStream outputStream = null;
        try {
            int c;
            fStream = new FileInputStream(from);
            outputStream = new BufferedOutputStream(new FileOutputStream(to));
            byte[] buffer = new byte[4096];
            while ((c = fStream.read(buffer)) != -1) {
                ((BufferedOutputStream)outputStream).write(buffer, 0, c);
            }
        }
        finally {
            if (fStream != null) {
                fStream.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    @Override
    public void restore(String alternateTheme) {
        String prefThemeId = this.getPreferenceThemeId();
        boolean flag = true;
        if (prefThemeId != null) {
            for (ITheme t : this.getThemes()) {
                if (!prefThemeId.equals(t.getId())) continue;
                this.setTheme(t, false);
                flag = false;
                break;
            }
        }
        if (alternateTheme != null && flag) {
            this.setTheme(alternateTheme, false);
        }
    }

    @Override
    public ITheme getActiveTheme() {
        return this.currentTheme;
    }

    @Override
    public CSSStyleDeclaration getStyle(Object widget) {
        for (CSSEngine engine : this.cssEngines) {
            Element e;
            CSSElementContext context = engine.getCSSElementContext(widget);
            if (context == null || (e = context.getElement()) == null) continue;
            return engine.getViewCSS().getComputedStyle(e, null);
        }
        return null;
    }

    public List<String> getStylesheets(ITheme selection) {
        ArrayList ss = this.stylesheets.get(selection.getId());
        return ss == null ? new ArrayList() : ss;
    }

    public void themeModified(ITheme theme, List<String> paths) {
        this.modifiedStylesheets.put(theme.getId(), paths);
        this.setTheme(theme, false, true);
    }

    public void resetCurrentTheme() {
        if (this.currentTheme != null) {
            this.setTheme(this.currentTheme, false, true);
        }
    }

    public List<String> getModifiedStylesheets(ITheme selection) {
        ArrayList ss = this.modifiedStylesheets.get(selection.getId());
        return ss == null ? new ArrayList() : ss;
    }

    public void resetModifiedStylesheets(ITheme selection) {
        this.modifiedStylesheets.remove(selection.getId());
    }

    @Override
    public void addCSSEngine(CSSEngine cssEngine) {
        this.cssEngines.add(cssEngine);
        this.resetCurrentTheme();
    }

    public Collection<CSSEngine> getCSSEngines() {
        return this.cssEngines;
    }

    @Override
    public void removeCSSEngine(CSSEngine cssEngine) {
        this.cssEngines.remove(cssEngine);
    }
}

