/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.observable.set;

import org.eclipse.core.databinding.observable.DecoratingObservableCollection;
import org.eclipse.core.databinding.observable.ListenerList;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.core.databinding.observable.set.SetChangeEvent;
import org.eclipse.core.databinding.observable.set.SetDiff;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecoratingObservableSet<E>
extends DecoratingObservableCollection<E>
implements IObservableSet<E> {
    private IObservableSet<E> decorated;
    private ISetChangeListener<E> setChangeListener;
    protected ListenerList<ISetChangeListener<E>> setChangeListenerList = null;

    public DecoratingObservableSet(IObservableSet<E> decorated, boolean disposeDecoratedOnDispose) {
        super(decorated, disposeDecoratedOnDispose);
        this.decorated = decorated;
    }

    @Override
    public void clear() {
        this.getterCalled();
        this.decorated.clear();
    }

    @Override
    public synchronized void addSetChangeListener(ISetChangeListener<E> listener) {
        this.addListener(this.getSetListenerList(), listener);
    }

    @Override
    public synchronized void removeSetChangeListener(ISetChangeListener<E> listener) {
        if (this.setChangeListenerList != null) {
            this.removeListener(this.setChangeListenerList, listener);
        }
    }

    @Override
    protected boolean hasListeners() {
        return this.setChangeListenerList != null && this.setChangeListenerList.hasListeners() || super.hasListeners();
    }

    private ListenerList<ISetChangeListener<E>> getSetListenerList() {
        if (this.setChangeListenerList == null) {
            this.setChangeListenerList = new ListenerList();
        }
        return this.setChangeListenerList;
    }

    protected void fireSetChange(SetDiff<? extends E> diff) {
        super.fireChange();
        if (this.setChangeListenerList != null) {
            this.setChangeListenerList.fireEvent(new SetChangeEvent<E>(this, diff));
        }
    }

    @Override
    protected void fireChange() {
        throw new RuntimeException("fireChange should not be called, use fireSetChange() instead");
    }

    @Override
    protected void firstListenerAdded() {
        if (this.setChangeListener == null) {
            this.setChangeListener = new ISetChangeListener<E>(){

                @Override
                public void handleSetChange(SetChangeEvent<E> event) {
                    DecoratingObservableSet.this.handleSetChange(event);
                }
            };
        }
        this.decorated.addSetChangeListener(this.setChangeListener);
        super.firstListenerAdded();
    }

    @Override
    protected void lastListenerRemoved() {
        super.lastListenerRemoved();
        if (this.setChangeListener != null) {
            this.decorated.removeSetChangeListener(this.setChangeListener);
            this.setChangeListener = null;
        }
    }

    protected void handleSetChange(SetChangeEvent<E> event) {
        this.fireSetChange(event.diff);
    }

    @Override
    public synchronized void dispose() {
        if (this.decorated != null && this.setChangeListener != null) {
            this.decorated.removeSetChangeListener(this.setChangeListener);
        }
        this.decorated = null;
        this.setChangeListener = null;
        super.dispose();
    }
}

