/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.observable.map;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.map.MapDiff;
import org.eclipse.core.databinding.observable.map.ObservableMap;
import org.eclipse.core.internal.databinding.observable.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WritableMap<K, V>
extends ObservableMap<K, V> {
    private final Object keyType;
    private final Object valueType;

    public WritableMap() {
        this(Realm.getDefault(), null, null);
    }

    public WritableMap(Realm realm) {
        this(realm, null, null);
    }

    public WritableMap(Object keyType, Object valueType) {
        this(Realm.getDefault(), keyType, valueType);
    }

    public WritableMap(Realm realm, Object keyType, Object valueType) {
        super(realm, new HashMap());
        this.keyType = keyType;
        this.valueType = valueType;
    }

    @Override
    public Object getKeyType() {
        return this.keyType;
    }

    @Override
    public Object getValueType() {
        return this.valueType;
    }

    @Override
    public V put(K key, V value) {
        this.checkRealm();
        boolean containedKeyBefore = this.wrappedMap.containsKey(key);
        V result = this.wrappedMap.put(key, value);
        boolean containedKeyAfter = this.wrappedMap.containsKey(key);
        if (containedKeyBefore != containedKeyAfter || !Util.equals(result, value)) {
            MapDiff<K, V> diff = containedKeyBefore ? (containedKeyAfter ? Diffs.createMapDiffSingleChange(key, result, value) : Diffs.createMapDiffSingleRemove(key, result)) : Diffs.createMapDiffSingleAdd(key, value);
            this.fireMapChange(diff);
        }
        return result;
    }

    @Override
    public V remove(Object key) {
        this.checkRealm();
        if (this.wrappedMap.containsKey(key)) {
            Object result = this.wrappedMap.remove(key);
            this.fireMapChange(Diffs.createMapDiffSingleRemove(key, result));
            return result;
        }
        return null;
    }

    @Override
    public void clear() {
        this.checkRealm();
        if (!this.isEmpty()) {
            HashMap copy = new HashMap(this.wrappedMap);
            this.wrappedMap.clear();
            this.fireMapChange(Diffs.createMapDiffRemoveAll(copy));
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.checkRealm();
        HashSet<K> addedKeys = new HashSet<K>(map.size());
        HashMap<K, V> changes = new HashMap<K, V>(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            boolean add = !this.wrappedMap.containsKey(entry.getKey());
            V previousValue = this.wrappedMap.put(entry.getKey(), entry.getValue());
            if (add) {
                addedKeys.add(entry.getKey());
                continue;
            }
            changes.put(entry.getKey(), previousValue);
        }
        if (!addedKeys.isEmpty() || !changes.isEmpty()) {
            Set removedKeys = Collections.emptySet();
            this.fireMapChange(Diffs.createMapDiff(addedKeys, removedKeys, changes.keySet(), changes, this.wrappedMap));
        }
    }
}

