/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.observable.list;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.databinding.observable.AbstractObservable;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.ListenerList;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.AbstractObservableList;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ListDiff;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObservableList<E>
extends AbstractObservable
implements IObservableList<E> {
    protected List<E> wrappedList;
    private boolean stale = false;
    private Object elementTypeAsObject;
    private Class<E> elementType;
    private ListenerList<IListChangeListener<E>> listChangeListenerList = null;

    protected ObservableList(List<E> wrappedList, Object elementType) {
        this(Realm.getDefault(), wrappedList, elementType);
    }

    protected ObservableList(List<E> wrappedList, Class<E> elementType) {
        this(Realm.getDefault(), wrappedList, elementType);
    }

    protected ObservableList(Realm realm, List<E> wrappedList, Object elementType) {
        super(realm);
        this.wrappedList = wrappedList;
        this.elementTypeAsObject = elementType;
        this.elementType = elementType instanceof Class ? (Class)elementType : null;
    }

    protected ObservableList(Realm realm, List<E> wrappedList, Class<E> elementType) {
        super(realm);
        this.wrappedList = wrappedList;
        this.elementTypeAsObject = elementType;
        this.elementType = elementType;
    }

    @Override
    public synchronized void addListChangeListener(IListChangeListener<E> listener) {
        this.addListener(this.getListChangeListenerList(), listener);
    }

    @Override
    public synchronized void removeListChangeListener(IListChangeListener<E> listener) {
        if (this.listChangeListenerList != null) {
            this.removeListener(this.listChangeListenerList, listener);
        }
    }

    private ListenerList<IListChangeListener<E>> getListChangeListenerList() {
        if (this.listChangeListenerList == null) {
            this.listChangeListenerList = new ListenerList();
        }
        return this.listChangeListenerList;
    }

    @Override
    protected boolean hasListeners() {
        return this.listChangeListenerList != null && this.listChangeListenerList.hasListeners() || super.hasListeners();
    }

    protected void fireListChange(ListDiff<? extends E> diff) {
        super.fireChange();
        if (this.listChangeListenerList != null) {
            this.listChangeListenerList.fireEvent(new ListChangeEvent<E>(this, diff));
        }
    }

    @Override
    public boolean contains(Object o) {
        this.getterCalled();
        return this.wrappedList.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        this.getterCalled();
        return this.wrappedList.containsAll(c);
    }

    @Override
    public boolean equals(Object o) {
        this.getterCalled();
        return o == this || this.wrappedList.equals(o);
    }

    @Override
    public int hashCode() {
        this.getterCalled();
        return this.wrappedList.hashCode();
    }

    @Override
    public boolean isEmpty() {
        this.getterCalled();
        return this.wrappedList.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        this.getterCalled();
        final Iterator<E> wrappedIterator = this.wrappedList.iterator();
        return new Iterator<E>(){

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasNext() {
                return wrappedIterator.hasNext();
            }

            @Override
            public E next() {
                return wrappedIterator.next();
            }
        };
    }

    @Override
    public int size() {
        this.getterCalled();
        return this.wrappedList.size();
    }

    @Override
    public Object[] toArray() {
        this.getterCalled();
        return this.wrappedList.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        this.getterCalled();
        return this.wrappedList.toArray(a);
    }

    public String toString() {
        this.getterCalled();
        return this.wrappedList.toString();
    }

    @Override
    public E get(int index) {
        this.getterCalled();
        return this.wrappedList.get(index);
    }

    @Override
    public int indexOf(Object o) {
        this.getterCalled();
        return this.wrappedList.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        this.getterCalled();
        return this.wrappedList.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        this.getterCalled();
        final ListIterator<E> wrappedIterator = this.wrappedList.listIterator(index);
        return new ListIterator<E>(){

            @Override
            public int nextIndex() {
                return wrappedIterator.nextIndex();
            }

            @Override
            public int previousIndex() {
                return wrappedIterator.previousIndex();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasNext() {
                return wrappedIterator.hasNext();
            }

            @Override
            public boolean hasPrevious() {
                return wrappedIterator.hasPrevious();
            }

            @Override
            public E next() {
                return wrappedIterator.next();
            }

            @Override
            public E previous() {
                return wrappedIterator.previous();
            }

            @Override
            public void add(E o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void set(E o) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public List<E> subList(final int fromIndex, final int toIndex) {
        this.getterCalled();
        if (fromIndex < 0 || fromIndex > toIndex || toIndex > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        return new AbstractObservableList<E>(this.getRealm()){

            @Override
            public Object getElementType() {
                return ObservableList.this.getElementType();
            }

            @Override
            public Class<E> getElementClass() {
                return ObservableList.this.getElementClass();
            }

            @Override
            public E get(int location) {
                return ObservableList.this.get(fromIndex + location);
            }

            @Override
            protected int doGetSize() {
                return toIndex - fromIndex;
            }
        };
    }

    protected void getterCalled() {
        ObservableTracker.getterCalled(this);
    }

    @Override
    public E set(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E move(int oldIndex, int newIndex) {
        this.checkRealm();
        int size = this.wrappedList.size();
        if (oldIndex < 0 || oldIndex >= size) {
            throw new IndexOutOfBoundsException("oldIndex: " + oldIndex + ", size:" + size);
        }
        if (newIndex < 0 || newIndex >= size) {
            throw new IndexOutOfBoundsException("newIndex: " + newIndex + ", size:" + size);
        }
        E element = this.remove(oldIndex);
        this.add(newIndex, element);
        return element;
    }

    @Override
    public E remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(E o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isStale() {
        this.getterCalled();
        return this.stale;
    }

    public void setStale(boolean stale) {
        this.checkRealm();
        boolean wasStale = this.stale;
        this.stale = stale;
        if (!wasStale && stale) {
            this.fireStale();
        }
    }

    @Override
    protected void fireChange() {
        throw new RuntimeException("fireChange should not be called, use fireListChange() instead");
    }

    @Override
    public synchronized void dispose() {
        this.listChangeListenerList = null;
        super.dispose();
    }

    @Override
    public Object getElementType() {
        return this.elementTypeAsObject;
    }

    @Override
    public Class<E> getElementClass() {
        return this.elementType;
    }

    protected void updateWrappedList(List<E> newList) {
        List<E> oldList = this.wrappedList;
        ListDiff<E> listDiff = Diffs.computeListDiff(oldList, newList);
        this.wrappedList = newList;
        this.fireListChange(listDiff);
    }
}

