/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.observable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.databinding.observable.IObservablesListener;
import org.eclipse.core.databinding.observable.ListenerListCopy;
import org.eclipse.core.databinding.observable.ObservableEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListenerList<L extends IObservablesListener<L>> {
    public static final int EQUALITY = 0;
    public static final int IDENTITY = 1;
    private final boolean identity;
    private volatile List<L> listeners = Collections.emptyList();

    public ListenerList() {
        this(0);
    }

    public ListenerList(int mode) {
        if (mode != 0 && mode != 1) {
            throw new IllegalArgumentException();
        }
        this.identity = mode == 1;
    }

    public synchronized void add(L listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        int oldSize = this.listeners.size();
        for (IObservablesListener listener2 : this.listeners) {
            if (!(this.identity ? listener == listener2 : listener.equals(listener2))) continue;
            return;
        }
        ArrayList<L> newListeners = new ArrayList<L>(oldSize + 1);
        newListeners.addAll(this.listeners);
        newListeners.add(listener);
        this.listeners = newListeners;
    }

    public List<L> getListeners() {
        return this.listeners;
    }

    public void fireEvent(ObservableEvent<?, L> event) {
        for (IObservablesListener listener : this.listeners) {
            event.dispatch(listener);
        }
    }

    public boolean isEmpty() {
        return this.listeners.isEmpty();
    }

    public synchronized void remove(L listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        int oldSize = this.listeners.size();
        if (oldSize == 0) {
            return;
        }
        if (oldSize == 1) {
            IObservablesListener listener2 = (IObservablesListener)this.listeners.get(0);
            if (this.identity ? listener == listener2 : listener.equals(listener2)) {
                this.listeners = Collections.emptyList();
            }
        } else {
            ArrayList<L> newListeners = new ArrayList<L>(oldSize - 1);
            boolean match = false;
            for (IObservablesListener listener2 : this.listeners) {
                if (this.identity ? listener == listener2 : listener.equals(listener2)) {
                    match = true;
                    continue;
                }
                newListeners.add(listener2);
            }
            if (match) {
                this.listeners = newListeners;
            }
        }
    }

    public int size() {
        return this.listeners.size();
    }

    public synchronized void clear() {
        this.listeners = Collections.emptyList();
    }

    public boolean hasListeners() {
        return !this.isEmpty();
    }

    public ListenerListCopy<L> getReadOnlyCopy() {
        return new ListenerListCopy<L>(this.listeners);
    }

    boolean isListStillCurrent(List<L> copy) {
        return this.listeners == copy;
    }
}

