/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.util.session;

import java.util.Arrays;
import java.util.NoSuchElementException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.platform.discovery.util.internal.session.HistoryTrack;
import org.eclipse.platform.discovery.util.internal.session.IHistoryTrack;

public class HistoryTrackTests
extends TestSuite {
    public static Test suite() {
        TestSuite s = new TestSuite();
        s.addTestSuite(TestInstantiationConstraints.class);
        s.addTestSuite(TestEmpty.class);
        s.addTestSuite(TestWithOneElementNonOversized.class);
        s.addTestSuite(TestWithOneElementOversized.class);
        s.addTestSuite(TestNonOversized.class);
        s.addTestSuite(TestOversized.class);
        s.addTestSuite(TestHistoryRenewed.class);
        return s;
    }

    private static abstract class Fixture
    extends TestCase
    implements HistoryManagerTestCase {
        protected Object[] tracked;
        protected int limit;
        protected IHistoryTrack<Object> target;

        public Fixture(int numTracked, int limit) {
            this.limit = limit;
            this.reinitializeTracked(numTracked);
        }

        protected void reinitializeTracked(int numTracked) {
            this.tracked = new Object[numTracked];
            int i = 0;
            while (i < this.tracked.length) {
                this.tracked[i] = new Object();
                ++i;
            }
        }

        public void setUp() {
            this.target = new HistoryTrack(this.limit);
            this.fillit();
        }

        protected void fillit() {
            int i = 0;
            while (i < this.tracked.length) {
                this.target.track(this.tracked[i]);
                ++i;
            }
        }

        protected void rewind() {
            while (this.target.hasPrevious()) {
                this.target.previous();
            }
        }

        protected void noSuchElExcNotThrown() {
            Fixture.fail((String)"NoSuchElementException not thrown");
        }
    }

    private static interface HistoryManagerTestCase {
        public void testIsEmpty();

        public void testHasNext();

        public void testHasPrevious();

        public void testNext();

        public void testPrevious();

        public void testLast();

        public void testFirst();

        public void testAsList();

        public void testCurrent();
    }

    public static class TestEmpty
    extends Fixture {
        public TestEmpty() {
            super(0, 1);
        }

        @Override
        public void testAsList() {
            TestEmpty.assertEquals((int)0, (int)this.target.asList().size());
        }

        @Override
        public void testCurrent() {
            try {
                this.target.current();
                this.noSuchElExcNotThrown();
            }
            catch (NoSuchElementException noSuchElementException) {}
        }

        @Override
        public void testFirst() {
            try {
                this.target.first();
                this.noSuchElExcNotThrown();
            }
            catch (NoSuchElementException noSuchElementException) {}
        }

        @Override
        public void testLast() {
            try {
                this.target.last();
                this.noSuchElExcNotThrown();
            }
            catch (NoSuchElementException noSuchElementException) {}
        }

        @Override
        public void testNext() {
            try {
                this.target.next();
                this.noSuchElExcNotThrown();
            }
            catch (NoSuchElementException noSuchElementException) {}
        }

        @Override
        public void testPrevious() {
            try {
                this.target.previous();
                this.noSuchElExcNotThrown();
            }
            catch (NoSuchElementException noSuchElementException) {}
        }

        @Override
        public void testHasNext() {
            TestEmpty.assertFalse((boolean)this.target.hasNext());
        }

        @Override
        public void testHasPrevious() {
            TestEmpty.assertFalse((boolean)this.target.hasPrevious());
        }

        @Override
        public void testIsEmpty() {
            TestEmpty.assertTrue((boolean)this.target.isEmpty());
        }
    }

    public static class TestHistoryRenewed
    extends TestNonOversized {
        public TestHistoryRenewed() {
            super(5, 5);
        }

        @Override
        public void setUp() {
            super.setUp();
            this.target.previous();
            this.target.previous();
            Object newlyTracked = new Object();
            this.target.track(newlyTracked);
            this.tracked = Arrays.copyOf(this.tracked, this.tracked.length - 1);
            this.tracked[this.tracked.length - 1] = newlyTracked;
        }
    }

    public static class TestInstantiationConstraints
    extends TestCase {
        public void testLimitLZ() {
            try {
                new HistoryTrack(0);
                TestInstantiationConstraints.fail((String)"IllegalArgumentException not thrown");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    public static class TestNonOversized
    extends Fixture {
        public TestNonOversized() {
            this(3, 5);
        }

        public TestNonOversized(int trackNum, int limit) {
            super(trackNum, limit);
        }

        @Override
        public void testAsList() {
            TestNonOversized.assertEquals((int)this.tracked.length, (int)this.target.asList().size());
            int i = 0;
            while (i < this.tracked.length) {
                TestNonOversized.assertEquals((Object)this.tracked[i], this.target.asList().get(i));
                ++i;
            }
        }

        @Override
        public void testCurrent() {
            TestNonOversized.assertSame((Object)this.tracked[this.tracked.length - 1], (Object)this.target.current());
        }

        @Override
        public void testFirst() {
            TestNonOversized.assertSame((Object)this.tracked[0], (Object)this.target.first());
        }

        @Override
        public void testHasNext() {
            TestNonOversized.assertFalse((boolean)this.target.hasNext());
        }

        @Override
        public void testHasPrevious() {
            TestNonOversized.assertTrue((boolean)this.target.hasPrevious());
        }

        @Override
        public void testIsEmpty() {
            TestNonOversized.assertFalse((boolean)this.target.isEmpty());
        }

        @Override
        public void testLast() {
            TestNonOversized.assertSame((Object)this.tracked[this.tracked.length - 1], (Object)this.target.last());
            this.target.previous();
            TestNonOversized.assertSame((Object)this.tracked[this.tracked.length - 1], (Object)this.target.last());
        }

        @Override
        public void testNext() {
            try {
                this.target.next();
                this.noSuchElExcNotThrown();
            }
            catch (NoSuchElementException noSuchElementException) {}
            this.target.previous();
            TestNonOversized.assertTrue((boolean)this.target.hasNext());
            TestNonOversized.assertSame((Object)this.tracked[this.tracked.length - 1], (Object)this.target.next());
            TestNonOversized.assertSame((Object)this.tracked[this.tracked.length - 1], (Object)this.target.current());
        }

        @Override
        public void testPrevious() {
            this.rewind();
            TestNonOversized.assertSame((Object)this.tracked[0], (Object)this.target.current());
            try {
                this.target.previous();
                this.noSuchElExcNotThrown();
            }
            catch (NoSuchElementException noSuchElementException) {}
            this.target.next();
            TestNonOversized.assertTrue((boolean)this.target.hasPrevious());
            TestNonOversized.assertSame((Object)this.tracked[0], (Object)this.target.previous());
        }
    }

    public static class TestOversized
    extends TestNonOversized {
        public TestOversized() {
            super(3, 3);
        }

        @Override
        public void setUp() {
            super.setUp();
            this.reinitializeTracked(3);
            this.fillit();
        }
    }

    public static class TestWithOneElementNonOversized
    extends Fixture {
        public TestWithOneElementNonOversized() {
            super(1, 1);
        }

        @Override
        public void testAsList() {
            TestWithOneElementNonOversized.assertEquals((int)1, (int)this.target.asList().size());
            TestWithOneElementNonOversized.assertSame((Object)this.tracked[0], this.target.asList().get(0));
        }

        @Override
        public void testCurrent() {
            TestWithOneElementNonOversized.assertSame((Object)this.tracked[0], (Object)this.target.current());
        }

        @Override
        public void testFirst() {
            TestWithOneElementNonOversized.assertSame((Object)this.tracked[0], (Object)this.target.first());
        }

        @Override
        public void testHasNext() {
            TestWithOneElementNonOversized.assertFalse((boolean)this.target.hasNext());
        }

        @Override
        public void testHasPrevious() {
            TestWithOneElementNonOversized.assertFalse((boolean)this.target.hasPrevious());
        }

        @Override
        public void testIsEmpty() {
            TestWithOneElementNonOversized.assertFalse((boolean)this.target.isEmpty());
        }

        @Override
        public void testLast() {
            TestWithOneElementNonOversized.assertSame((Object)this.tracked[0], (Object)this.target.last());
        }

        @Override
        public void testNext() {
            try {
                this.target.next();
                this.noSuchElExcNotThrown();
            }
            catch (NoSuchElementException noSuchElementException) {}
            this.testHasPrevious();
            this.testHasNext();
        }

        @Override
        public void testPrevious() {
            try {
                this.target.previous();
                this.noSuchElExcNotThrown();
            }
            catch (NoSuchElementException noSuchElementException) {
                this.testHasPrevious();
                this.testHasNext();
            }
        }
    }

    public static class TestWithOneElementOversized
    extends TestWithOneElementNonOversized {
        @Override
        public void setUp() {
            super.setUp();
            this.reinitializeTracked(1);
            this.fillit();
        }
    }
}

