/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.util.internal.longop;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.platform.discovery.testutils.utils.jmock.Mock;
import org.eclipse.platform.discovery.util.api.longop.ILongOperation;
import org.eclipse.platform.discovery.util.api.longop.ILongOperationRunner;
import org.eclipse.platform.discovery.util.api.longop.LongOpCanceledException;
import org.eclipse.platform.discovery.util.internal.longop.AbstractLongOpRunnerTests;
import org.eclipse.platform.discovery.util.internal.longop.SingleForkThreadRunner;
import org.jmock.core.Constraint;
import org.jmock.core.Invocation;
import org.jmock.core.Stub;

public class SingleForkThreadRunnerTests
extends TestSuite {
    public static Test suite() {
        TestSuite s = new TestSuite();
        s.addTestSuite(WithNoNestedOp.class);
        s.addTestSuite(WithSubOpTest.class);
        return s;
    }

    public static class WithNoNestedOp
    extends AbstractLongOpRunnerTests {
        protected Mock<Set<Thread>> trackerMock;
        private Set<Thread> trackerMockSet;

        @Override
        public void setUp() throws Exception {
            this.trackerMock = this.createThreadTracker();
            super.setUp();
        }

        protected Mock<Set<Thread>> createThreadTracker() {
            Mock tmpMock = this.mock(Set.class);
            this.trackerMockSet = new HashSet<Thread>();
            tmpMock.expects(this.once()).method("add").with((Constraint)this.same(Thread.currentThread())).will(new Stub(){

                public Object invoke(Invocation arg0) throws Throwable {
                    return WithNoNestedOp.this.trackerMockSet.add((Thread)arg0.parameterValues.get(0));
                }

                public StringBuffer describeTo(StringBuffer arg0) {
                    arg0.append("Marks thread as already running a long operation");
                    return arg0;
                }
            });
            tmpMock.expects(this.once()).method("remove").with((Constraint)this.same(Thread.currentThread())).will(new Stub(){

                public Object invoke(Invocation arg0) throws Throwable {
                    return WithNoNestedOp.this.trackerMockSet.remove((Thread)arg0.parameterValues.get(0));
                }

                public StringBuffer describeTo(StringBuffer arg0) {
                    arg0.append("Marks the thread as not running a long operation");
                    return arg0;
                }
            });
            tmpMock.stubs().method("contains").withAnyArguments().will(new Stub(){

                public Object invoke(Invocation arg0) throws Throwable {
                    return WithNoNestedOp.this.trackerMockSet.contains((Thread)arg0.parameterValues.get(0));
                }

                public StringBuffer describeTo(StringBuffer arg0) {
                    arg0.append("Checks whether this thread is currently running a long operation");
                    return arg0;
                }
            });
            return tmpMock;
        }

        @Override
        protected ILongOperationRunner newRunner(final IProgressMonitor monitor) {
            return new SingleForkThreadRunner(monitor, (Set)this.trackerMock.proxy()){

                public <T> T runInNewThread(ILongOperation<T> op) throws LongOpCanceledException, InvocationTargetException {
                    try {
                        return (T)op.run(monitor);
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (LongOpCanceledException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
        }
    }

    public static class WithSubOpTest
    extends WithNoNestedOp {
        @Override
        protected ILongOperation<Object> newObjRetOp(final Object o) {
            return new ILongOperation<Object>(){

                public Object run(IProgressMonitor monitor) throws Exception {
                    return WithSubOpTest.this.target.run((ILongOperation)new ILongOperation<Object>(){

                        public Object run(IProgressMonitor monitor) throws LongOpCanceledException, Exception {
                            WithSubOpTest.assertTrue((boolean)(monitor instanceof SubProgressMonitor));
                            return o;
                        }
                    });
                }
            };
        }

        @Override
        protected ILongOperation<Object> newExcThrowingOp(final Exception e) {
            return new ILongOperation<Object>(){

                public Object run(IProgressMonitor monitor) throws Exception {
                    return WithSubOpTest.this.target.run((ILongOperation)new ILongOperation<Object>(){

                        public Object run(IProgressMonitor monitor) throws LongOpCanceledException, Exception {
                            WithSubOpTest.assertTrue((boolean)(monitor instanceof SubProgressMonitor));
                            throw e;
                        }
                    });
                }
            };
        }

        @Override
        protected ILongOperation<Object> newErrThrowingOp(final Error e) {
            return new ILongOperation<Object>(){

                public Object run(IProgressMonitor monitor) throws Exception {
                    return WithSubOpTest.this.target.run((ILongOperation)new ILongOperation<Object>(){

                        public Object run(IProgressMonitor monitor) throws LongOpCanceledException, Exception {
                            WithSubOpTest.assertTrue((boolean)(monitor instanceof SubProgressMonitor));
                            throw e;
                        }
                    });
                }
            };
        }
    }
}

