/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.test.unit.internal;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.platform.discovery.runtime.api.IDestinationsProvider;
import org.eclipse.platform.discovery.runtime.api.ISearchDestination;
import org.eclipse.platform.discovery.runtime.api.ISearchProvider;
import org.eclipse.platform.discovery.runtime.api.ISearchSubdestination;
import org.eclipse.platform.discovery.runtime.internal.ISearchProviderConfiguration;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IDestinationCategoryDescription;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IObjectTypeDescription;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.ISearchProviderDescription;
import org.eclipse.platform.discovery.testutils.utils.registry.ExtensionRegistryBuilder;
import org.eclipse.platform.discovery.ui.internal.view.SearchConsoleView;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class SubdestinationsSelectionPersistedTest {
    private SearchConsoleViewExtended consoleView;
    private IExtensionRegistry extensionRegistry;
    @Mock
    private IDestinationsProvider destinationsProvider;
    @Mock
    private ISearchDestination searchDestination;
    @Mock
    private ISearchProviderDescription searchProviderDescr;
    @Mock
    private IObjectTypeDescription objectType;
    @Mock
    private IDestinationCategoryDescription destCategory;
    @Mock
    private ISearchProviderDescription searchProvider;
    @Mock
    private ISearchSubdestination subdestination;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.consoleView = new SearchConsoleViewExtended();
        this.stubObjectType();
        this.stubDestinationCategory();
        this.stubDestinationsProvider();
        this.stubSearchProvider();
        this.stubSubdestination();
        this.extensionRegistry = this.stubExtensionsRegistry();
    }

    private void stubDestinationsProvider() {
        Mockito.stub((Object)this.destinationsProvider.getSearchDestinations()).toReturn(new HashSet<ISearchDestination>(Arrays.asList(this.searchDestination)));
    }

    private void stubSubdestination() {
        Mockito.stub((Object)this.subdestination.getId()).toReturn((Object)"my.subdestination");
        String destCategoryId = this.destCategory.getId();
        Mockito.stub((Object)this.subdestination.getDestinationCategoryId()).toReturn((Object)destCategoryId);
    }

    private void stubSearchProvider() {
        Mockito.stub((Object)this.searchProvider.getId()).toReturn((Object)"my.search.provider.id");
        Mockito.stub((Object)this.searchProvider.getObjectType()).toReturn((Object)this.objectType);
    }

    private void stubDestinationCategory() {
        Mockito.stub((Object)this.destCategory.getId()).toReturn((Object)"my.category.id");
        Mockito.stub((Object)this.destCategory.getDestinationProviderIds()).toReturn(Arrays.asList("my.dest.provider.id"));
        Mockito.stub((Object)this.destCategory.getDestinationsClass()).toReturn(ISearchDestination.class);
    }

    private void stubObjectType() {
        Mockito.stub((Object)this.objectType.getId()).toReturn((Object)"my.object.id");
    }

    private IExtensionRegistry stubExtensionsRegistry() {
        ExtensionRegistryBuilder registryBuilder = new ExtensionRegistryBuilder();
        registryBuilder.addObjectType(this.objectType.getId(), this.objectType.getDisplayName());
        registryBuilder.addDestinationCategory(this.destCategory.getId(), this.destCategory.getDisplayName());
        registryBuilder.addSearchProvider(this.searchProvider.getId(), "foo", (ISearchProvider)Mockito.mock(ISearchProvider.class), this.objectType.getId(), "true", new String[]{this.destCategory.getId()});
        registryBuilder.addSearchSubdestination(this.subdestination.getId(), this.subdestination.getDisplayName(), this.subdestination.getDestinationCategoryId(), this.objectType.getId(), "false", new String[0]);
        return registryBuilder.getRegistry();
    }

    @Test
    public void testSubdestinationsSelectionPersisted() {
        this.consoleView.getSearchProviderConfiguration().activateSubdestination(this.objectType, this.destCategory, this.searchProvider, this.subdestination, true);
        Assert.assertTrue((String)"Subdestination is still inactive", (boolean)this.consoleView.getSearchProviderConfiguration().isSubdestinationActive(this.subdestination, this.objectType, this.destCategory, this.searchProvider));
    }

    private class SearchConsoleViewExtended
    extends SearchConsoleView {
        private SearchConsoleViewExtended() {
        }

        protected IExtensionRegistry extensionRegistry() {
            return SubdestinationsSelectionPersistedTest.this.extensionRegistry;
        }

        protected ISearchProviderConfiguration getSearchProviderConfiguration() {
            return super.getSearchProviderConfiguration();
        }
    }
}

