/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.test.comp.internal.pageobjects;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.LinkedList;
import junit.framework.Assert;
import org.eclipse.platform.discovery.core.api.ISearchContext;
import org.eclipse.platform.discovery.core.api.SearchEvent;
import org.eclipse.platform.discovery.core.internal.IDestinationsManager;
import org.eclipse.platform.discovery.core.internal.ISearchSession;
import org.eclipse.platform.discovery.core.internal.SearchConsoleController;
import org.eclipse.platform.discovery.core.internal.console.ISearchConsoleController;
import org.eclipse.platform.discovery.core.internal.console.ISearchConsoleControllerOutputView;
import org.eclipse.platform.discovery.core.internal.events.handlers.ISearchEventHandler;
import org.eclipse.platform.discovery.runtime.api.SearchFailedException;
import org.eclipse.platform.discovery.runtime.internal.ISearchProviderConfiguration;
import org.eclipse.platform.discovery.runtime.internal.ProviderNotFoundException;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IDestinationCategoryDescription;
import org.eclipse.platform.discovery.testutils.utils.pageobjects.InShellPageObject;
import org.eclipse.platform.discovery.ui.api.IGenericViewCustomization;
import org.eclipse.platform.discovery.ui.api.IViewUiContext;
import org.eclipse.platform.discovery.ui.api.impl.DefaultSessionIds;
import org.eclipse.platform.discovery.ui.internal.plugin.DiscoveryUIMessages;
import org.eclipse.platform.discovery.ui.internal.search.advancedparams.IAdvancedSearchParamsDisplayer;
import org.eclipse.platform.discovery.ui.internal.view.ISearchProviderSelector;
import org.eclipse.platform.discovery.ui.internal.view.SearchConsoleView;
import org.eclipse.platform.discovery.ui.internal.view.impl.ITabbedSessionDisplayer;
import org.eclipse.platform.discovery.ui.test.comp.internal.pageobjects.swtbot.SWTBotHyperlink;
import org.eclipse.platform.discovery.ui.test.comp.internal.pageobjects.swtbot.SWTBotTextWithMessage;
import org.eclipse.platform.discovery.ui.test.comp.internal.pageobjects.swtbot.SwtBotUtils;
import org.eclipse.platform.discovery.util.api.env.IDiscoveryEnvironment;
import org.eclipse.platform.discovery.util.internal.session.ISessionManager;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swtbot.swt.finder.exceptions.WidgetNotFoundException;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.results.VoidResult;
import org.eclipse.swtbot.swt.finder.widgets.AbstractSWTBot;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotButton;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotCombo;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotLabel;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.forms.widgets.AbstractHyperlink;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class SearchConsolePageObject
extends InShellPageObject {
    @Mock
    private IWorkbenchPartSite viewSite;
    @Mock
    private IDestinationsManager destManager;
    private final ISearchProviderConfiguration searchProviderConfiguration;
    private final ITabbedSessionDisplayer<ISearchContext> sessionDisplayer;
    private final IAdvancedSearchParamsDisplayer advancedParamsDisplayer;
    private final IDiscoveryEnvironment env;
    private final IViewUiContext uiContext;
    private final SwtBotUtils botUtils;
    private PageObjectConsoleView consoleView;
    private PageObjectController viewController;

    public SearchConsolePageObject(ISearchProviderConfiguration searchProviderConfiguration, ITabbedSessionDisplayer<ISearchContext> sessionDisplayer, IAdvancedSearchParamsDisplayer advancedParamsDisplayer, IDiscoveryEnvironment environment, IViewUiContext uiContext) {
        MockitoAnnotations.initMocks((Object)((Object)this));
        this.searchProviderConfiguration = searchProviderConfiguration;
        this.sessionDisplayer = sessionDisplayer;
        this.advancedParamsDisplayer = advancedParamsDisplayer;
        this.env = environment;
        this.uiContext = uiContext;
        this.botUtils = new SwtBotUtils();
    }

    protected Shell createShell() {
        Shell shell = super.createShell();
        Mockito.stub((Object)this.viewSite.getShell()).toReturn((Object)shell);
        return shell;
    }

    protected void createContent(final Shell parent, FormToolkit formToolkit) {
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                parent.setLayout((Layout)new FillLayout(512));
                SearchConsolePageObject.this.consoleView = new PageObjectConsoleView();
                SearchConsolePageObject.this.consoleView.setEnvironment(SearchConsolePageObject.this.env);
                SearchConsolePageObject.this.consoleView.setUiContext(SearchConsolePageObject.this.uiContext);
                SearchConsolePageObject.this.consoleView.createPartControl((Composite)parent);
            }
        });
    }

    public void open() {
        super.open();
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                ((Shell)((SearchConsolePageObject)SearchConsolePageObject.this).shell().widget).layout();
                SearchConsolePageObject.this.consoleView.setDefaultSessionId(DefaultSessionIds.mainSearchSessionId);
                SearchConsolePageObject.this.consoleView.setEnvironment(SearchConsolePageObject.this.env);
                SearchConsolePageObject.this.viewController = new PageObjectController(SearchConsolePageObject.this.searchProviderConfiguration, (ISearchConsoleControllerOutputView)SearchConsolePageObject.this.consoleView, SearchConsolePageObject.this.env, null, DefaultSessionIds.mainSearchSessionId);
                SearchConsolePageObject.this.consoleView.registerController((ISearchConsoleController)SearchConsolePageObject.this.viewController);
                SearchConsolePageObject.this.consoleView.setDestinationsManager(SearchConsolePageObject.this.destManager);
                SearchConsolePageObject.this.consoleView.initializationCompleted();
            }
        });
    }

    public IWorkbenchPartSite getViewSiteMock() {
        return this.viewSite;
    }

    public String getSelectedObject() {
        SWTBotCombo objectsCombo = this.findObjectTypesCombo();
        return objectsCombo.selectionIndex() == -1 ? null : objectsCombo.selection();
    }

    public void selectObject(String objectName) {
        this.findObjectTypesCombo().setSelection(objectName);
    }

    public Collection<String> getCategories() {
        LinkedList<String> categories = new LinkedList<String>();
        SWTBotTreeItem[] sWTBotTreeItemArray = this.getAllCategoryItems();
        int n = sWTBotTreeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            SWTBotTreeItem item = sWTBotTreeItemArray[n2];
            categories.add(item.getText());
            ++n2;
        }
        return categories;
    }

    public void verifyManageDestinationsWorksCorrectly() {
        SWTBotHyperlink manageDestinationsLink = new SWTBotHyperlink((AbstractHyperlink)this.botUtils.findOneChildControlOfExactType(this.shell().widget, Hyperlink.class, true));
        manageDestinationsLink.click();
        ((IDestinationsManager)Mockito.verify((Object)this.destManager)).manageDestinations((Shell)Mockito.same((Object)((Shell)this.shell().widget)), (IDestinationCategoryDescription)Mockito.same((Object)this.consoleView.getSearchProviderSelector().getActiveDestinationCategory()));
    }

    public void verifySearchPerformed(String objectTypeId, String destinationName, String keyword) {
        Assert.assertNotNull((String)"Search was not invoked", (Object)this.viewController.lastSearchEvent);
        Assert.assertEquals((String)"Unexpected object id", (String)objectTypeId, (String)this.viewController.lastSearchEvent.getSearchParameters().getObjectTypeId());
        Assert.assertEquals((String)"Unexpected destination", (String)destinationName, (String)this.viewController.lastSearchEvent.getSearchParameters().getSearchDestination().getDisplayName());
        Assert.assertEquals((String)"Unexpected keyword", (String)keyword, (String)this.viewController.lastSearchEvent.getSearchParameters().getKeywordString());
    }

    private SWTBotTreeItem getCategoryItem(String categoryName) {
        SWTBotTreeItem[] sWTBotTreeItemArray = this.getAllCategoryItems();
        int n = sWTBotTreeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            SWTBotTreeItem categoryItem = sWTBotTreeItemArray[n2];
            if (categoryItem.getText().equals(categoryName)) {
                return categoryItem;
            }
            ++n2;
        }
        throw new WidgetNotFoundException(MessageFormat.format("Category {0} not found", categoryName));
    }

    private SWTBotTree findDestinationsTree() {
        return new SWTBotTree(this.findSiblingByLabel(DiscoveryUIMessages.SEARCH_IN_LIST_VIEWER_LABEL, Tree.class));
    }

    private SWTBotTreeItem[] getAllCategoryItems() {
        return this.findDestinationsTree().getAllItems();
    }

    private SWTBotCombo findObjectTypesCombo() {
        return new SWTBotCombo(this.findSiblingByLabel(DiscoveryUIMessages.SEARCH_FOR_LIST_VIEWER_LABEL, Combo.class));
    }

    private <T extends Widget> T findSiblingByLabel(String labelText, Class<T> targetClass) {
        return this.botUtils.findSibling((AbstractSWTBot<? extends Control>)this.bot().label(labelText), targetClass);
    }

    public void selectDestination(String categoryName, String destinationName) {
        this.findDestination(categoryName, destinationName).select();
    }

    public boolean isDestinationVisible(String categoryName, String destinationName) {
        try {
            this.findDestination(categoryName, destinationName);
            return true;
        }
        catch (WidgetNotFoundException widgetNotFoundException) {
            return false;
        }
    }

    public Collection<String> getDestinationsForCategory(String categoryName) {
        LinkedList<String> result = new LinkedList<String>();
        SWTBotTreeItem[] sWTBotTreeItemArray = this.getCategoryItem(categoryName).getItems();
        int n = sWTBotTreeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            SWTBotTreeItem destinationItem = sWTBotTreeItemArray[n2];
            result.add(destinationItem.getText());
            ++n2;
        }
        return result;
    }

    public void expandDestinations() {
        SWTBotTreeItem[] sWTBotTreeItemArray = this.getAllCategoryItems();
        int n = sWTBotTreeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            SWTBotTreeItem categoryItem = sWTBotTreeItemArray[n2];
            categoryItem.expand();
            ++n2;
        }
    }

    public boolean canSelectHierarchy() {
        return this.findGroupingHierarchyCombo().isEnabled();
    }

    public String getSelectedGroupingHierarchy() {
        return this.findGroupingHierarchyCombo().getText();
    }

    public String getKeyword() {
        SWTBotTextWithMessage keywordText = this.findKeywordText();
        if (!keywordText.isEnabled()) {
            return keywordText.getText();
        }
        if (keywordText.getText().length() == 0) {
            return keywordText.getMessage();
        }
        return keywordText.getText();
    }

    public void enterKeyword(String keyword) {
        if (!this.canEnterSearchText()) {
            throw new IllegalStateException("Cannot enter keyword as the text is disabled");
        }
        this.findKeywordText().setText(keyword);
    }

    public void selectFirstPossibleDestination() {
        this.expandDestinations();
        this.getAllCategoryItems()[0].getItems()[0].select();
    }

    public void search() {
        if (!this.canSearch()) {
            throw new IllegalStateException("Search is not possible now as the search button is disabled");
        }
        this.findSearchButton().click();
    }

    public void registerViewCustomization(IGenericViewCustomization ... customizations) {
        IGenericViewCustomization[] iGenericViewCustomizationArray = customizations;
        int n = customizations.length;
        int n2 = 0;
        while (n2 < n) {
            IGenericViewCustomization cust = iGenericViewCustomizationArray[n2];
            this.consoleView.registerViewCustomization(cust);
            ++n2;
        }
    }

    public void showResult(final ISearchContext searchContext) {
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                SearchConsolePageObject.this.consoleView.showResult(searchContext);
            }
        });
    }

    public boolean canSelectObject() {
        return this.findObjectTypesCombo().isEnabled();
    }

    public boolean canSelectDestination() {
        return this.findDestinationsTree().isEnabled();
    }

    public boolean canEnterSearchText() {
        return this.findKeywordText().isEnabled();
    }

    public boolean canSelectSubdestination() {
        return this.findSubdestinationsSelectorButton().isEnabled();
    }

    public boolean canSearch() {
        return this.findSearchButton().isEnabled();
    }

    private SWTBotTreeItem findDestination(String categoryName, String destinationName) {
        SWTBotTreeItem[] sWTBotTreeItemArray = this.getAllCategoryItems();
        int n = sWTBotTreeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            SWTBotTreeItem categoryItem = sWTBotTreeItemArray[n2];
            if (categoryItem.getText().equals(categoryName)) {
                try {
                    return categoryItem.getNode(destinationName);
                }
                catch (WidgetNotFoundException e) {
                    throw new WidgetNotFoundException(MessageFormat.format("Coulkd find destination {0} for category {1}", destinationName, categoryName), (Throwable)e);
                }
            }
            ++n2;
        }
        throw new WidgetNotFoundException(MessageFormat.format("Could find category {0}", categoryName));
    }

    private SWTBotTextWithMessage findKeywordText() {
        return new SWTBotTextWithMessage(this.findSiblingByLabel(DiscoveryUIMessages.SEARCH_KEYWORD_LABEL, Text.class));
    }

    private SWTBotLabel findSubdestinationsSelectorButton() {
        return new SWTBotLabel(this.findSiblingByLabel(DiscoveryUIMessages.SEARCH_KEYWORD_LABEL, Label.class));
    }

    private SWTBotButton findSearchButton() {
        return this.bot().button(DiscoveryUIMessages.SEARCH_BUTTON_LABEL);
    }

    private SWTBotCombo findGroupingHierarchyCombo() {
        return new SWTBotCombo(this.findSiblingByLabel(DiscoveryUIMessages.GROUP_BY_LABEL, Combo.class));
    }

    private class PageObjectConsoleView
    extends SearchConsoleView {
        private PageObjectConsoleView() {
        }

        protected ISearchProviderConfiguration getSearchProviderConfiguration() {
            return SearchConsolePageObject.this.searchProviderConfiguration;
        }

        protected ITabbedSessionDisplayer<ISearchContext> createSessionsDisplayer() {
            return SearchConsolePageObject.this.sessionDisplayer;
        }

        public IWorkbenchPartSite getSite() {
            return SearchConsolePageObject.this.viewSite;
        }

        protected IAdvancedSearchParamsDisplayer createAdvancedSearchParamsDisplayer(Composite parent, FormToolkit formToolkit) {
            return SearchConsolePageObject.this.advancedParamsDisplayer;
        }

        protected ISearchProviderSelector getSearchProviderSelector() {
            return this.searchProviderSelector;
        }
    }

    private class PageObjectController
    extends SearchConsoleController {
        public SearchEvent lastSearchEvent;

        public PageObjectController(ISearchProviderConfiguration providerConfiguration, ISearchConsoleControllerOutputView searchConsoleView, IDiscoveryEnvironment consoleEnv, ISessionManager<ISearchSession> sessionManager, String defaultSessionId) {
            super(providerConfiguration, searchConsoleView, consoleEnv, sessionManager, defaultSessionId);
        }

        protected ISearchEventHandler createSearchEventHandler() {
            return new ISearchEventHandler(){

                public void handleSearch(SearchEvent event) throws ProviderNotFoundException, SearchFailedException {
                    PageObjectController.this.lastSearchEvent = event;
                }
            };
        }
    }
}

