/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.test.comp.internal;

import org.eclipse.platform.discovery.ui.test.comp.internal.pageobjects.TabbedSessionDisplayerPageObject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TabbedSessionDisplayerTest {
    private final TabbedSessionDisplayerPageObject tabbedSessionDisplayer = new TabbedSessionDisplayerPageObject();
    private static final String NON_NAVIGATABLE_SESSION_ID = "not navigatable";
    private static final String NON_NAVIGATABLE_HISTORY_ITEM = "nonnavigatable history item";
    private static final String NAVIGATABLE_SESSION_ID = "navigatable";
    private static final String NAVIGATABLE_HISTORY_ITEM_1 = "navigatable history item 1";
    private static final String NAVIGATABLE_HISTORY_ITEM_2 = "navigatable history item 2";

    @Before
    public void setUp() {
        this.tabbedSessionDisplayer.addSession(NAVIGATABLE_SESSION_ID, NAVIGATABLE_HISTORY_ITEM_1, NAVIGATABLE_HISTORY_ITEM_2);
        this.tabbedSessionDisplayer.addUnnavigableSession(NON_NAVIGATABLE_SESSION_ID, NON_NAVIGATABLE_HISTORY_ITEM);
    }

    @After
    public void tearDown() {
        this.tabbedSessionDisplayer.tearDown();
    }

    @Test
    public void tabsOpen() {
        this.tabbedSessionDisplayer.displaySessions(new String[]{NAVIGATABLE_SESSION_ID, NON_NAVIGATABLE_SESSION_ID}, new boolean[]{true, true});
        Assert.assertTrue((String)"Tab should be open", (boolean)this.tabbedSessionDisplayer.isSessionOpen(NAVIGATABLE_SESSION_ID));
        Assert.assertTrue((String)"Tab should be open", (boolean)this.tabbedSessionDisplayer.isSessionOpen(NON_NAVIGATABLE_SESSION_ID));
    }

    @Test
    public void nextAndPrevoiusAreDisplayedForNavigableSession() {
        this.tabbedSessionDisplayer.displaySessions(new String[]{NAVIGATABLE_SESSION_ID}, new boolean[]{true});
        Assert.assertTrue((String)"Could not find previous button", (boolean)this.tabbedSessionDisplayer.isNavigateToNextAvailable());
        Assert.assertTrue((String)"Could not find next button", (boolean)this.tabbedSessionDisplayer.isNavigateToPreviousAvailable());
    }

    @Test
    public void nextAndPrevoiusAreNotDisplayedForNonNavigableSession() {
        this.tabbedSessionDisplayer.displaySessions(new String[]{NON_NAVIGATABLE_SESSION_ID}, new boolean[]{true});
        Assert.assertFalse((String)"Could not find previous button", (boolean)this.tabbedSessionDisplayer.isNavigateToNextAvailable());
        Assert.assertFalse((String)"Could not find next button", (boolean)this.tabbedSessionDisplayer.isNavigateToPreviousAvailable());
    }

    @Test
    public void uncloseableTab() {
        this.tabbedSessionDisplayer.displaySessions(new String[]{NON_NAVIGATABLE_SESSION_ID}, new boolean[1]);
        this.tabbedSessionDisplayer.closeSession(NON_NAVIGATABLE_SESSION_ID);
        Assert.assertTrue((String)"Tab should still be open because it is not closeable", (boolean)this.tabbedSessionDisplayer.isSessionOpen(NON_NAVIGATABLE_SESSION_ID));
    }

    @Test
    public void closeableTab() {
        this.tabbedSessionDisplayer.displaySessions(new String[]{NON_NAVIGATABLE_SESSION_ID}, new boolean[]{true});
        this.tabbedSessionDisplayer.closeSession(NON_NAVIGATABLE_SESSION_ID);
        Assert.assertFalse((String)"Tab was not closed", (boolean)this.tabbedSessionDisplayer.isSessionOpen(NON_NAVIGATABLE_SESSION_ID));
    }

    @Test
    public void navButtonsDisappearOnSelectingNonNavigableSession() {
        this.tabbedSessionDisplayer.displaySessions(new String[]{NAVIGATABLE_SESSION_ID, NON_NAVIGATABLE_SESSION_ID}, new boolean[2]);
        this.tabbedSessionDisplayer.selectSession(NAVIGATABLE_SESSION_ID);
        this.tabbedSessionDisplayer.selectSession(NON_NAVIGATABLE_SESSION_ID);
        Assert.assertFalse((String)"Session is not navigable, buttons not expected", (boolean)this.tabbedSessionDisplayer.isNavigateToPreviousAvailable());
        Assert.assertFalse((String)"Session is not navigable, buttons not expected", (boolean)this.tabbedSessionDisplayer.isNavigateToNextAvailable());
    }

    @Test
    public void navButtonsReappearOnSelectingNavigableSession() {
        this.tabbedSessionDisplayer.displaySessions(new String[]{NAVIGATABLE_SESSION_ID, NON_NAVIGATABLE_SESSION_ID}, new boolean[2]);
        this.tabbedSessionDisplayer.selectSession(NON_NAVIGATABLE_SESSION_ID);
        this.tabbedSessionDisplayer.selectSession(NAVIGATABLE_SESSION_ID);
        Assert.assertTrue((String)"Session is navigable, but nav buttons are not available", (boolean)this.tabbedSessionDisplayer.isNavigateToPreviousAvailable());
        Assert.assertTrue((String)"Session is navigable, but nav buttons are not available", (boolean)this.tabbedSessionDisplayer.isNavigateToNextAvailable());
    }

    @Test
    public void navigateHistory() {
        this.tabbedSessionDisplayer.displaySessions(new String[]{NAVIGATABLE_SESSION_ID}, new boolean[1]);
        Assert.assertFalse((String)"Previous button should be disabled by default", (boolean)this.tabbedSessionDisplayer.isNavigateToPreviousEnabled());
        Assert.assertTrue((String)"Next button should be enabled by default", (boolean)this.tabbedSessionDisplayer.isNavigateToNextEnabled());
        this.tabbedSessionDisplayer.navigateToNext();
        Assert.assertTrue((String)"Previous button should be enabled now", (boolean)this.tabbedSessionDisplayer.isNavigateToPreviousEnabled());
        Assert.assertFalse((String)"Next button should be disabled now", (boolean)this.tabbedSessionDisplayer.isNavigateToNextEnabled());
        this.tabbedSessionDisplayer.navigateToPrevious();
        Assert.assertFalse((String)"Previous button should be disabled now", (boolean)this.tabbedSessionDisplayer.isNavigateToPreviousEnabled());
        Assert.assertTrue((String)"Next button should be enabled now", (boolean)this.tabbedSessionDisplayer.isNavigateToNextEnabled());
    }
}

