/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.examples.databinding.snippets;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.property.list.IListProperty;
import org.eclipse.core.databinding.property.list.MultiListProperty;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.ObservableListTreeContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class Snippet029TreeViewerMultiListProperty {
    protected Shell shell;
    private TreeViewer viewer;

    public static void main(String[] args) {
        try {
            Snippet029TreeViewerMultiListProperty window = new Snippet029TreeViewerMultiListProperty();
            window.open();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void open() {
        final Display display = Display.getDefault();
        Realm.runWithDefault((Realm)SWTObservables.getRealm((Display)display), (Runnable)new Runnable(){

            public void run() {
                Snippet029TreeViewerMultiListProperty.this.createContents();
                Snippet029TreeViewerMultiListProperty.this.shell.open();
                Snippet029TreeViewerMultiListProperty.this.shell.layout();
                while (!Snippet029TreeViewerMultiListProperty.this.shell.isDisposed()) {
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
            }
        });
    }

    protected void createContents() {
        this.shell = new Shell();
        this.shell.setSize(509, 375);
        this.shell.setText("Snippet028DuplexingObservableValue.java");
        GridLayout gridLayout = new GridLayout();
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.numColumns = 4;
        this.shell.setLayout((Layout)new FillLayout());
        this.viewer = new TreeViewer((Composite)this.shell, 67586);
        this.bindUI();
    }

    private void bindUI() {
        Catalog fruits = new Catalog("Fruits");
        ArrayList<AbstractModelObject> items = new ArrayList<AbstractModelObject>();
        items.add(new CatalogItem("Apple"));
        items.add(new CatalogItem("Orange"));
        fruits.setCatalogs(items);
        Catalog vegetables = new Catalog("Vegetables");
        items = new ArrayList();
        items.add(new CatalogItem("Peas"));
        items.add(new CatalogItem("Carrots"));
        items.add(new CatalogItem("Potatoes"));
        vegetables.setItems(items);
        Catalog foods = new Catalog("Foods");
        items = new ArrayList();
        items.add(fruits);
        items.add(vegetables);
        foods.setCatalogs(items);
        items = new ArrayList();
        items.add(new CatalogItem("Own Hand"));
        foods.setItems(items);
        Catalog catalog = new Catalog("Main Catalog");
        items = new ArrayList();
        items.add(foods);
        catalog.setCatalogs(items);
        MultiListProperty childrenProperty = new MultiListProperty(new IListProperty[]{BeanProperties.list((String)"catalogs"), BeanProperties.list((String)"items")});
        ObservableListTreeContentProvider contentProvider = new ObservableListTreeContentProvider(childrenProperty.listFactory(), null);
        this.viewer.setContentProvider((IContentProvider)contentProvider);
        ObservableMapLabelProvider labelProvider = new ObservableMapLabelProvider(BeanProperties.value((String)"name").observeDetail(contentProvider.getKnownElements())){
            Image catalogImage;
            Image catalogItemImage;
            {
                this.catalogImage = this.createCatalogImage();
                this.catalogItemImage = this.createCatalogItemImage();
            }

            public Image getImage(Object element) {
                if (element instanceof Catalog) {
                    return this.catalogImage;
                }
                if (element instanceof CatalogItem) {
                    return this.catalogItemImage;
                }
                return super.getImage(element);
            }

            public void dispose() {
                this.catalogImage.dispose();
                this.catalogItemImage.dispose();
                super.dispose();
            }

            private Image createCatalogImage() {
                Display display = Display.getCurrent();
                Image catalogImage = new Image((Device)display, 12, 12);
                GC gc = new GC((Drawable)catalogImage);
                gc.setBackground(display.getSystemColor(5));
                gc.fillArc(1, 1, 10, 10, 0, 360);
                gc.dispose();
                return catalogImage;
            }

            private Image createCatalogItemImage() {
                Display display = Display.getCurrent();
                Image catalogImage = new Image((Device)display, 12, 12);
                GC gc = new GC((Drawable)catalogImage);
                gc.setBackground(display.getSystemColor(13));
                gc.fillPolygon(new int[]{1, 10, 5, 1, 6, 1, 10, 10, 1, 10});
                gc.dispose();
                return catalogImage;
            }
        };
        this.viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.viewer.setInput((Object)catalog);
    }

    public static abstract class AbstractModelObject {
        private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.propertyChangeSupport.addPropertyChangeListener(listener);
        }

        public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.propertyChangeSupport.removePropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
        }

        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public static class Catalog
    extends AbstractModelObject {
        private String name;
        private List catalogs = new ArrayList();
        private List items = new ArrayList();

        public Catalog(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
            this.firePropertyChange("name", this.name, this.name);
        }

        public List getCatalogs() {
            return this.catalogs;
        }

        public void setCatalogs(List catalogs) {
            this.catalogs = catalogs;
            this.firePropertyChange("catalogs", this.catalogs, this.catalogs);
        }

        public List getItems() {
            return this.items;
        }

        public void setItems(List items) {
            this.items = items;
            this.firePropertyChange("items", this.items, this.items);
        }
    }

    public static class CatalogItem
    extends AbstractModelObject {
        private String name;

        public CatalogItem(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
            this.firePropertyChange("name", this.name, this.name);
        }
    }
}

