/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.examples.databinding.mask.internal;

import java.util.ArrayList;
import org.eclipse.jface.examples.databinding.mask.EditMaskParseException;

public class EditMaskLexerAndToken {
    private static ArrayList reservedWords = new ArrayList();
    private static ArrayList inputRegexes = new ArrayList();
    private String charRegex;
    private String literal;
    private boolean readOnly;
    private String input;

    public EditMaskLexerAndToken() {
        reservedWords.add("#");
        reservedWords.add("A");
        reservedWords.add("a");
        reservedWords.add("n");
        inputRegexes.add("^[0-9]$");
        inputRegexes.add("^[A-Z]$");
        inputRegexes.add("^[a-zA-Z]$");
        inputRegexes.add("^[0-9a-zA-Z]$");
        this.charRegex = null;
        this.literal = null;
        this.input = null;
    }

    private boolean recognizeReservedWord(String inputMask, int position) {
        String input = inputMask.substring(position, position + 1);
        int reservedWord = 0;
        while (reservedWord < reservedWords.size()) {
            if (input.equals(reservedWords.get(reservedWord))) {
                this.charRegex = (String)inputRegexes.get(reservedWord);
                this.literal = null;
                input = null;
                this.readOnly = false;
                return true;
            }
            ++reservedWord;
        }
        return false;
    }

    private boolean recognizeBackslashLiteral(String inputMask, int position) throws EditMaskParseException {
        String input = inputMask.substring(position, position + 1);
        if (input.equals("\\")) {
            try {
                input = inputMask.substring(position + 1, position + 2);
                this.charRegex = null;
                this.input = input;
                this.literal = input;
                this.readOnly = true;
                return true;
            }
            catch (Throwable throwable) {
                throw new EditMaskParseException("Found a \\ without a character after it: " + inputMask);
            }
        }
        return false;
    }

    private boolean recognizeLiteral(String inputMask, int position) {
        this.input = this.literal = inputMask.substring(position, position + 1);
        this.charRegex = null;
        this.readOnly = true;
        return true;
    }

    public int initializeEditMask(String inputMask, int position) throws EditMaskParseException {
        this.clear();
        if (this.recognizeReservedWord(inputMask, position)) {
            return 1;
        }
        if (this.recognizeBackslashLiteral(inputMask, position)) {
            return 2;
        }
        if (!this.recognizeLiteral(inputMask, position)) {
            throw new EditMaskParseException("Should never see this error in this implementation!");
        }
        this.readOnly = true;
        return 1;
    }

    public boolean accept(String inputCharacter) {
        if (this.readOnly) {
            return false;
        }
        if (this.literal != null) {
            return false;
        }
        if (!this.canAcceptMoreCharacters()) {
            return false;
        }
        if (inputCharacter.matches(this.charRegex)) {
            this.input = inputCharacter;
            return true;
        }
        return false;
    }

    public String getInput() {
        return this.input;
    }

    public void clear() {
        if (!this.isReadOnly()) {
            this.input = null;
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isComplete() {
        return this.input != null;
    }

    public boolean canAcceptMoreCharacters() {
        return !this.isComplete();
    }

    public int getMinimumLength() {
        return 1;
    }
}

