/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.databinding.preference;

import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.databinding.preference.INodeTypingMethods;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeObserver<T>
extends AbstractObservableValue<T> {
    private static final String defaultString = "";
    private final IEclipsePreferences node;
    private final String key;
    private Class<T> valueClass;
    private INodeTypingMethods<T> nodeTypingMethods;

    public NodeObserver(IEclipsePreferences node, final String key, Class<T> valueClass, final INodeTypingMethods<T> nodeTypingMethods) {
        this.node = node;
        this.key = key;
        this.valueClass = valueClass;
        this.nodeTypingMethods = nodeTypingMethods;
        node.addPreferenceChangeListener(new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                if (event.getKey().equals(key)) {
                    String oldValueAsString = (String)event.getOldValue();
                    Object oldValue = oldValueAsString == null ? null : nodeTypingMethods.convertToType(oldValueAsString);
                    String newValueAsString = (String)event.getNewValue();
                    Object newValue = newValueAsString == null ? null : nodeTypingMethods.convertToType(newValueAsString);
                    NodeObserver.this.fireValueChange(Diffs.createValueDiff(oldValue, newValue));
                }
            }
        });
    }

    public boolean containsKey() {
        return this.node.get(this.key, defaultString) != defaultString;
    }

    public String get() {
        return this.node.get(this.key, null);
    }

    protected T doGetValue() {
        String value = this.node.get(this.key, defaultString);
        if (value == defaultString) {
            throw new RuntimeException("doGetValue called when not set");
        }
        return value == null ? null : (T)this.nodeTypingMethods.convertToType(value);
    }

    public Object getValueType() {
        return this.valueClass;
    }

    public Class<T> getValueClass() {
        return this.valueClass;
    }
}

